/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.catalog.AbstractGeoResource;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.GeoResourceInfo;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveDelta;
import org.geotools.catalog.Service;
import org.geotools.catalog.defaults.DefaultGeoResourceInfo;
import org.geotools.catalog.defaults.DefaultResolveChangeEvent;
import org.geotools.catalog.defaults.DefaultResolveDelta;
import org.geotools.catalog.wms.WMSService;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.xml.WMSSchema;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.ProgressListener;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSGeoResource
extends AbstractGeoResource {
    WMSService parent;
    Layer layer;
    private GeoResourceInfo info;

    private WMSGeoResource() {
    }

    public WMSGeoResource(WMSService parent, Layer layer) {
        this.parent = parent;
        this.layer = layer;
    }

    public Resolve parent(ProgressListener monitor) throws IOException {
        return this.parent;
    }

    public Resolve.Status getStatus() {
        return this.parent.getStatus();
    }

    public GeoResourceInfo getInfo(ProgressListener monitor) throws IOException {
        if (this.info == null) {
            this.info = new WMSResourceInfo(monitor);
            DefaultResolveDelta delta = new DefaultResolveDelta((Resolve)this, ResolveDelta.Kind.CHANGED);
            this.parent(monitor).parent(monitor).fire((ResolveChangeEvent)new DefaultResolveChangeEvent((Object)this, ResolveChangeEvent.Type.POST_CHANGE, (ResolveDelta)delta));
        }
        return this.info;
    }

    public URI getIdentifier() {
        try {
            return new URI(this.parent.getIdentifier().toString() + "#" + this.layer.getName());
        }
        catch (Throwable e) {
            return this.parent.getIdentifier();
        }
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(Service.class)) {
            return this.parent;
        }
        if (adaptee.isAssignableFrom(GeoResource.class)) {
            return this;
        }
        if (adaptee.isAssignableFrom(GeoResourceInfo.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(WebMapServer.class)) {
            return this.parent.getWMS(monitor);
        }
        if (adaptee.isAssignableFrom(Layer.class)) {
            return this.layer;
        }
        return null;
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(GeoResource.class) || adaptee.isAssignableFrom(WebMapServer.class) || adaptee.isAssignableFrom(Layer.class) || adaptee.isAssignableFrom(Service.class);
    }

    public Throwable getMessage() {
        return this.parent.getMessage();
    }

    private class WMSResourceInfo
    extends DefaultGeoResourceInfo {
        WMSResourceInfo(ProgressListener monitor) throws IOException {
            WebMapServer wms = WMSGeoResource.this.parent.getWMS(monitor);
            WMSCapabilities caps = wms.getCapabilities();
            GeneralEnvelope env = null;
            CoordinateReferenceSystem crs = null;
            try {
                crs = CRS.decode((String)"EPSG:4326");
                env = WMSGeoResource.this.parent.getWMS(null).getEnvelope(WMSGeoResource.this.layer, crs);
            }
            catch (FactoryException e) {
                throw (IOException)new IOException("Bounds not available").initCause(e);
            }
            this.bounds = new ReferencedEnvelope(new Envelope(env.getMinimum(0), env.getMaximum(0), env.getMinimum(1), env.getMaximum(1)), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            String parentid = WMSGeoResource.this.parent != null && WMSGeoResource.this.parent.getIdentifier() != null ? WMSGeoResource.this.getIdentifier().toString() : "";
            this.name = WMSGeoResource.this.layer.getName();
            ArrayList<String> keywordsFromWMS = new ArrayList<String>();
            if (caps.getService().getKeywordList() != null) {
                keywordsFromWMS.addAll(Arrays.asList(caps.getService().getKeywordList()));
            }
            if (WMSGeoResource.this.layer.getKeywords() != null) {
                keywordsFromWMS.addAll(Arrays.asList(WMSGeoResource.this.layer.getKeywords()));
            }
            keywordsFromWMS.add("WMS");
            keywordsFromWMS.add(WMSGeoResource.this.layer.getName());
            keywordsFromWMS.add(caps.getService().getName());
            keywordsFromWMS.add(parentid);
            this.keywords = keywordsFromWMS.toArray(new String[keywordsFromWMS.size()]);
            this.description = WMSGeoResource.this.layer.get_abstract() != null && WMSGeoResource.this.layer.get_abstract().length() != 0 ? WMSGeoResource.this.layer.get_abstract() : caps.getService().get_abstract();
            this.description = caps.getService().get_abstract();
            this.title = WMSGeoResource.this.layer.getTitle() != null && WMSGeoResource.this.layer.getTitle().length() != 0 ? WMSGeoResource.this.layer.getTitle() : caps.getService().getTitle();
        }

        public String getName() {
            return WMSGeoResource.this.layer.getName();
        }

        public URI getSchema() {
            return WMSSchema.NAMESPACE;
        }

        public String getTitle() {
            return this.getName();
        }
    }
}

