/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.wms;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.catalog.AbstractService;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveDelta;
import org.geotools.catalog.ServiceInfo;
import org.geotools.catalog.defaults.DefaultResolveChangeEvent;
import org.geotools.catalog.defaults.DefaultResolveDelta;
import org.geotools.catalog.defaults.DefaultServiceInfo;
import org.geotools.catalog.wms.WMSGeoResource;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.GetCapabilitiesResponse;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.Specification;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WMS1_0_0;
import org.geotools.data.wms.WMS1_1_0;
import org.geotools.data.wms.WMS1_1_1;
import org.geotools.data.wms.WMSUtils;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetFeatureInfoRequest;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.data.wms.response.GetFeatureInfoResponse;
import org.geotools.data.wms.response.GetMapResponse;
import org.geotools.data.wms.xml.WMSSchema;
import org.geotools.ows.ServiceException;
import org.geotools.util.ProgressListener;
import org.xml.sax.SAXException;

public class WMSService
extends AbstractService {
    public static final String WMS_URL_KEY = "net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY";
    public static final String WMS_WMS_KEY = "net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_WMS_KEY";
    private Map params;
    private Throwable error;
    private URI uri;
    private WebMapServer wms = null;
    private WMSServiceInfo info;
    private List members = null;

    public WMSService(Catalog parent, URI uri, Map params) {
        super(parent);
        Object obj;
        this.params = params;
        this.uri = uri;
        if (params.containsKey(WMS_WMS_KEY) && (obj = params.get(WMS_WMS_KEY)) instanceof WebMapServer) {
            this.wms = (WebMapServer)((Object)obj);
        }
    }

    public Resolve.Status getStatus() {
        return this.error != null ? Resolve.Status.BROKEN : (this.wms == null ? Resolve.Status.NOTCONNECTED : Resolve.Status.CONNECTED);
    }

    protected WebMapServer getWMS(ProgressListener theUserIsWatching) throws IOException {
        if (this.wms == null) {
            try {
                URL url1 = (URL)this.getConnectionParams().get(WMS_URL_KEY);
                this.wms = new CustomWMS(url1);
            }
            catch (IOException persived) {
                this.error = persived;
                throw persived;
            }
            catch (Throwable nak) {
                IOException broken = new IOException("Could not connect to WMS. Possible reason: " + nak.getLocalizedMessage());
                broken.initCause(nak);
                this.error = broken;
                throw broken;
            }
            DefaultResolveDelta delta = new DefaultResolveDelta((Resolve)this, ResolveDelta.Kind.CHANGED);
            this.parent(theUserIsWatching).fire((ResolveChangeEvent)new DefaultResolveChangeEvent((Object)this, ResolveChangeEvent.Type.POST_CHANGE, (ResolveDelta)delta));
        }
        return this.wms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getInfo(ProgressListener monitor) throws IOException {
        if (this.info == null) {
            WebMapServer webMapServer = this.getWMS(monitor);
            synchronized (webMapServer) {
                if (this.info == null) {
                    this.info = new WMSServiceInfo(monitor);
                    DefaultResolveDelta delta = new DefaultResolveDelta((Resolve)this, ResolveDelta.Kind.CHANGED);
                    this.parent(monitor).fire((ResolveChangeEvent)new DefaultResolveChangeEvent((Object)this, ResolveChangeEvent.Type.POST_CHANGE, (ResolveDelta)delta));
                }
            }
        }
        return this.info;
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(ServiceInfo.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(List.class)) {
            return this.members(monitor);
        }
        if (adaptee.isAssignableFrom(WebMapServer.class)) {
            return this.getWMS(monitor);
        }
        return null;
    }

    public Map getConnectionParams() {
        return this.params;
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(WebMapServer.class) || adaptee.isAssignableFrom(ServiceInfo.class) || adaptee.isAssignableFrom(List.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List members(ProgressListener monitor) throws IOException {
        if (this.members == null) {
            WebMapServer webMapServer = this.getWMS(monitor);
            synchronized (webMapServer) {
                if (this.members == null) {
                    this.getWMS(monitor);
                    this.members = new LinkedList();
                    Layer[] layers = WMSUtils.getNamedLayers(this.getWMS(monitor).getCapabilities());
                    if (layers != null) {
                        for (int i = 0; i < layers.length; ++i) {
                            if (layers[i].getChildren().length != 0) continue;
                            Layer layer = layers[i];
                            this.members.add(new WMSGeoResource(this, layer));
                        }
                    }
                }
            }
        }
        return this.members;
    }

    public Throwable getMessage() {
        return this.error;
    }

    public URI getIdentifier() {
        return this.uri;
    }

    public class CustomWMS
    extends WebMapServer {
        public CustomWMS(URL serverURL) throws IOException, ServiceException, SAXException {
            super(serverURL);
            if (this.getCapabilities() == null) {
                throw new IOException("Unable to parse capabilities document.");
            }
        }

        public GetCapabilitiesResponse issueRequest(GetCapabilitiesRequest arg0) throws IOException, ServiceException {
            return super.issueRequest(arg0);
        }

        public GetFeatureInfoResponse issueRequest(GetFeatureInfoRequest arg0) throws IOException, ServiceException {
            return super.issueRequest(arg0);
        }

        public GetMapResponse issueRequest(GetMapRequest arg0) throws IOException, ServiceException {
            return super.issueRequest(arg0);
        }

        protected void setupSpecifications() {
            this.specs = new Specification[3];
            this.specs[0] = new WMS1_0_0();
            this.specs[1] = new WMS1_1_0();
            this.specs[2] = new WMS1_1_1();
        }
    }

    class WMSServiceInfo
    extends DefaultServiceInfo {
        private WMSCapabilities caps = null;

        WMSServiceInfo(ProgressListener monitor) {
            String[] t;
            try {
                this.caps = WMSService.this.getWMS(monitor).getCapabilities();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                this.caps = null;
            }
            String[] stringArray = this.caps == null ? null : (this.keywords = this.caps.getService() == null ? null : this.caps.getService().getKeywordList());
            if (this.keywords == null) {
                t = new String[2];
            } else {
                t = new String[this.keywords.length + 2];
                System.arraycopy(this.keywords, 0, t, 2, this.keywords.length);
            }
            t[0] = "WMS";
            t[1] = WMSService.this.getIdentifier().toString();
            this.keywords = t;
        }

        public String getAbstract() {
            return this.caps == null ? null : (this.caps.getService() == null ? null : this.caps.getService().get_abstract());
        }

        public String getDescription() {
            return WMSService.this.getIdentifier().toString();
        }

        public URI getSchema() {
            return WMSSchema.NAMESPACE;
        }

        public URI getSource() {
            return WMSService.this.getIdentifier();
        }

        public String getTitle() {
            return this.caps == null || this.caps.getService() == null ? (WMSService.this.getIdentifier() == null ? "BROKEN" : WMSService.this.getIdentifier().toString()) : this.caps.getService().getTitle();
        }
    }
}

