/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.wms;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Service;
import org.geotools.catalog.ServiceFactory;
import org.geotools.catalog.wms.WMSService;

public class WMSServiceFactory
implements ServiceFactory {
    public Service createService(Catalog parent, URI id, Map params) {
        if (params == null) {
            return null;
        }
        if (!params.containsKey("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY") && id == null && !params.containsKey("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_WMS_KEY")) {
            return null;
        }
        if (params.containsKey("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY")) {
            URL base = null;
            if (params.get("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY") instanceof URL) {
                base = (URL)params.get("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY");
            } else {
                try {
                    base = new URL((String)params.get("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY"));
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                    return null;
                }
                params.remove(params.get("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY"));
                params.put("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY", base);
            }
            if (id == null) {
                try {
                    id = new URI(base.toExternalForm());
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            return new WMSService(parent, id, params);
        }
        return null;
    }

    public boolean canProcess(URI uri) {
        try {
            return WMSServiceFactory.isWMS(uri.toURL());
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public Map createParams(URI uri) {
        URL url;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (!WMSServiceFactory.isWMS(url)) {
            return null;
        }
        HashMap<String, URL> params2 = new HashMap<String, URL>();
        params2.put("net.refractions.udig.catalog.internal.wms.WMSServiceImpl.WMS_URL_KEY", url);
        return params2;
    }

    public static boolean isWMS(URL url) {
        if (url == null) {
            return false;
        }
        String PATH = url.getPath();
        String QUERY = url.getQuery();
        String PROTOCOL = url.getProtocol();
        if (PROTOCOL.indexOf("http") == -1) {
            return false;
        }
        if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=") != -1) {
            return QUERY.toUpperCase().indexOf("SERVICE=WMS") != -1;
        }
        if (PATH != null && PATH.toUpperCase().indexOf("GEOSERVER/WMS") != -1) {
            return true;
        }
        return true;
    }
}

