/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.referencing.CRS;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WMSUtils {
    private static Map crsCache = new HashMap();

    public static Layer[] getNamedLayers(WMSCapabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        ArrayList<Layer> namedLayersList = new ArrayList<Layer>();
        Layer[] layers = capabilities.getLayerList().toArray(new Layer[capabilities.getLayerList().size()]);
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i].getName() == null || layers[i].getName().length() == 0) continue;
            namedLayersList.add(layers[i]);
        }
        Layer[] namedLayers = new Layer[namedLayersList.size()];
        for (int i = 0; i < namedLayersList.size(); ++i) {
            namedLayers[i] = (Layer)namedLayersList.get(i);
        }
        return namedLayers;
    }

    public static Set getQueryableLayers(WMSCapabilities capabilities) {
        TreeSet<Layer> layers = new TreeSet<Layer>();
        Layer[] namedLayers = WMSUtils.getNamedLayers(capabilities);
        for (int i = 0; i < namedLayers.length; ++i) {
            Layer layer = namedLayers[i];
            if (!layer.isQueryable()) continue;
            layers.add(layer);
        }
        return layers;
    }

    public static Set getSRSs(WMSCapabilities capabilities) {
        TreeSet srss = new TreeSet();
        Layer[] layers = capabilities.getLayerList().toArray(new Layer[capabilities.getLayerList().size()]);
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i].getSrs() == null) continue;
            srss.addAll(layers[i].getSrs());
        }
        return srss;
    }

    public static Set findCommonEPSGs(List layers) {
        TreeSet set = new TreeSet();
        Layer first = (Layer)layers.get(0);
        set.addAll(first.getSrs());
        for (int i = 1; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            set.retainAll(layer.getSrs());
        }
        return set;
    }

    public static String matchEPSG(CoordinateReferenceSystem crs, Set codes) {
        Iterator iter;
        TreeSet previous = (TreeSet)crsCache.get(crs);
        if (previous != null) {
            iter = previous.iterator();
            while (iter.hasNext()) {
                String code = (String)iter.next();
                if (!codes.contains(code)) continue;
                return code;
            }
        }
        iter = crs.getIdentifiers().iterator();
        while (iter.hasNext()) {
            Identifier ident = (Identifier)iter.next();
            String epsgCode = ident.toString();
            if (!codes.contains(epsgCode)) continue;
            if (crsCache.get(crs) == null) {
                crsCache.put(crs, new TreeSet());
            }
            TreeSet set = (TreeSet)crsCache.get(crs);
            set.add(epsgCode);
            return epsgCode;
        }
        iter = null;
        iter = codes.iterator();
        while (iter.hasNext()) {
            MathTransform transform;
            CoordinateReferenceSystem epsgCRS;
            String epsgCode = (String)iter.next();
            try {
                epsgCRS = CRS.decode((String)epsgCode);
            }
            catch (Exception e) {
                continue;
            }
            try {
                transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)epsgCRS, (boolean)true);
            }
            catch (FactoryException e) {
                continue;
            }
            if (!transform.isIdentity()) continue;
            if (crsCache.get(crs) == null) {
                crsCache.put(crs, new TreeSet());
            }
            TreeSet set = (TreeSet)crsCache.get(crs);
            set.add(epsgCode);
            return epsgCode;
        }
        return null;
    }
}

