/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms;

import java.io.IOException;
import java.net.URL;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.GetCapabilitiesResponse;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.OperationType;
import org.geotools.data.ows.Request;
import org.geotools.data.ows.Specification;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WMS1_0_0;
import org.geotools.data.wms.WMS1_1_0;
import org.geotools.data.wms.WMS1_1_1;
import org.geotools.data.wms.WMS1_3_0;
import org.geotools.data.wms.WMSSpecification;
import org.geotools.data.wms.request.DescribeLayerRequest;
import org.geotools.data.wms.request.GetFeatureInfoRequest;
import org.geotools.data.wms.request.GetLegendGraphicRequest;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.data.wms.request.GetStylesRequest;
import org.geotools.data.wms.request.PutStylesRequest;
import org.geotools.data.wms.response.DescribeLayerResponse;
import org.geotools.data.wms.response.GetFeatureInfoResponse;
import org.geotools.data.wms.response.GetLegendGraphicResponse;
import org.geotools.data.wms.response.GetMapResponse;
import org.geotools.data.wms.response.GetStylesResponse;
import org.geotools.data.wms.response.PutStylesResponse;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.ows.ServiceException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WebMapServer
extends AbstractOpenWebService {
    public WebMapServer(URL serverURL) throws IOException, ServiceException {
        super(serverURL);
    }

    protected void setupSpecifications() {
        this.specs = new Specification[4];
        this.specs[0] = new WMS1_0_0();
        this.specs[1] = new WMS1_1_0();
        this.specs[2] = new WMS1_1_1();
        this.specs[3] = new WMS1_3_0();
    }

    public GetCapabilitiesResponse issueRequest(GetCapabilitiesRequest request) throws IOException, ServiceException {
        return (GetCapabilitiesResponse)this.internalIssueRequest((Request)request);
    }

    public GetMapResponse issueRequest(GetMapRequest request) throws IOException, ServiceException {
        return (GetMapResponse)this.internalIssueRequest(request);
    }

    public GetFeatureInfoResponse issueRequest(GetFeatureInfoRequest request) throws IOException, ServiceException {
        return (GetFeatureInfoResponse)this.internalIssueRequest(request);
    }

    public DescribeLayerResponse issueRequest(DescribeLayerRequest request) throws IOException, ServiceException {
        return (DescribeLayerResponse)this.internalIssueRequest(request);
    }

    public GetLegendGraphicResponse issueRequest(GetLegendGraphicRequest request) throws IOException, ServiceException {
        return (GetLegendGraphicResponse)this.internalIssueRequest(request);
    }

    public GetStylesResponse issueRequest(GetStylesRequest request) throws IOException, ServiceException {
        return (GetStylesResponse)this.internalIssueRequest(request);
    }

    public PutStylesResponse issueRequest(PutStylesRequest request) throws IOException, ServiceException {
        return (PutStylesResponse)this.internalIssueRequest(request);
    }

    public WMSCapabilities getCapabilities() {
        return (WMSCapabilities)this.capabilities;
    }

    private WMSSpecification getSpecification() {
        return (WMSSpecification)this.specification;
    }

    private URL findURL(OperationType operation) {
        if (operation.getGet() != null) {
            return operation.getGet();
        }
        return this.serverURL;
    }

    public GetMapRequest createGetMapRequest() {
        URL onlineResource = this.findURL(this.getCapabilities().getRequest().getGetMap());
        return this.getSpecification().createGetMapRequest(onlineResource);
    }

    public GetFeatureInfoRequest createGetFeatureInfoRequest(GetMapRequest getMapRequest) {
        if (this.getCapabilities().getRequest().getGetFeatureInfo() == null) {
            throw new UnsupportedOperationException("This Web Map Server does not support GetFeatureInfo requests");
        }
        URL onlineResource = this.findURL(this.getCapabilities().getRequest().getGetFeatureInfo());
        GetFeatureInfoRequest request = this.getSpecification().createGetFeatureInfoRequest(onlineResource, getMapRequest);
        return request;
    }

    public DescribeLayerRequest createDescribeLayerRequest() throws UnsupportedOperationException {
        if (this.getCapabilities().getRequest().getDescribeLayer() == null) {
            throw new UnsupportedOperationException("Server does not specify a DescribeLayer operation. Cannot be performed");
        }
        URL onlineResource = this.getCapabilities().getRequest().getDescribeLayer().getGet();
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        DescribeLayerRequest request = this.getSpecification().createDescribeLayerRequest(onlineResource);
        return request;
    }

    public GetLegendGraphicRequest createGetLegendGraphicRequest() throws UnsupportedOperationException {
        if (this.getCapabilities().getRequest().getGetLegendGraphic() == null) {
            throw new UnsupportedOperationException("Server does not specify a GetLegendGraphic operation. Cannot be performed");
        }
        URL onlineResource = this.getCapabilities().getRequest().getGetLegendGraphic().getGet();
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        GetLegendGraphicRequest request = this.getSpecification().createGetLegendGraphicRequest(onlineResource);
        return request;
    }

    public GetStylesRequest createGetStylesRequest() throws UnsupportedOperationException {
        if (this.getCapabilities().getRequest().getGetStyles() == null) {
            throw new UnsupportedOperationException("Server does not specify a GetStyles operation. Cannot be performed");
        }
        URL onlineResource = this.getCapabilities().getRequest().getGetStyles().getGet();
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        GetStylesRequest request = this.getSpecification().createGetStylesRequest(onlineResource);
        return request;
    }

    public PutStylesRequest createPutStylesRequest() throws UnsupportedOperationException {
        if (this.getCapabilities().getRequest().getPutStyles() == null) {
            throw new UnsupportedOperationException("Server does not specify a PutStyles operation. Cannot be performed");
        }
        URL onlineResource = this.getCapabilities().getRequest().getPutStyles().getGet();
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        PutStylesRequest request = this.getSpecification().createPutStylesRequest(onlineResource);
        return request;
    }

    public GeneralEnvelope getEnvelope(Layer layer, CoordinateReferenceSystem crs) {
        return layer.getEnvelope(crs);
    }
}

