/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms.gce;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.gce.WMSParameterMaker;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.opengis.coverage.grid.Format;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

public class WMSFormat
implements Format {
    private WMSCapabilities capabilities;

    public WMSFormat(WMSCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public boolean accepts(Object input) {
        if (input instanceof String) {
            try {
                URL url = new URL((String)input);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        if (input instanceof URL) {
            return true;
        }
        return input instanceof WMSCapabilities;
    }

    public ParameterValueGroup getReadParameters() {
        GeneralParameterDescriptor[] params = new GeneralParameterDescriptor[16];
        WMSParameterMaker maker = new WMSParameterMaker(this.capabilities);
        params[0] = maker.createVersionReadParam();
        params[1] = maker.createRequestReadParam();
        params[2] = maker.createFormatReadParam();
        params[3] = maker.createHeightReadParam();
        params[4] = maker.createWidthReadParam();
        params[5] = maker.createSRSReadParam();
        params[6] = maker.createLayersReadParam();
        params[7] = maker.createBBoxMinXReadParam();
        params[8] = maker.createBBoxMinYReadParam();
        params[9] = maker.createBBoxMaxXReadParam();
        params[10] = maker.createBBoxMaxYReadParam();
        params[11] = maker.createTransparentReadParam();
        params[12] = maker.createBGColorReadParam();
        params[13] = maker.createExceptionsReadParam();
        params[14] = maker.createElevationReadParam();
        params[15] = maker.createTimeReadParam();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", this.capabilities.getService().getName());
        properties.put("remarks", this.capabilities.getService().get_abstract());
        return new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(properties, params));
    }

    public String getName() {
        return "Web Map Server";
    }

    public String getDescription() {
        return "Web Map Server";
    }

    public String getVendor() {
        return "Open GIS Consortium";
    }

    public String getDocURL() {
        return "http://www.opengis.org";
    }

    public String getVersion() {
        return this.capabilities.getVersion();
    }

    public ParameterValueGroup getWriteParameters() {
        return null;
    }
}

