/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms.gce;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidParameterException;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.gce.WMSFormatFactory;
import org.geotools.data.wms.gce.WMSReader;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageExchange;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.xml.sax.SAXException;

public class WMSGridCoverageExchange
implements GridCoverageExchange {
    private Format[] formats;
    private WMSCapabilities capabilities;
    private WebMapServer wms;

    public WMSGridCoverageExchange(Object source) throws SAXException, URISyntaxException, IOException {
        if (source instanceof String || source instanceof URL) {
            URL url = null;
            url = source instanceof String ? new URL((String)source) : (URL)source;
            this.wms = new WebMapServer(url);
            this.capabilities = this.wms.getCapabilities();
        } else if (source instanceof WMSCapabilities) {
            this.capabilities = (WMSCapabilities)((Object)source);
        }
        WMSFormatFactory factory = new WMSFormatFactory(this.capabilities);
        if (!factory.isAvailable()) {
            throw new RuntimeException("WMS support is not available");
        }
        this.formats = new Format[1];
        this.formats[0] = factory.createFormat();
    }

    public void dispose() throws IOException {
    }

    public Format[] getFormats() {
        return this.formats;
    }

    public GridCoverageReader getReader(Object source) throws IOException {
        if (source instanceof String || source instanceof URL) {
            if (source instanceof String) {
                try {
                    new URL((String)source);
                }
                catch (MalformedURLException e) {
                    throw new InvalidParameterException("Unable to convert source to a URL (it is malformed)");
                }
            }
            return new WMSReader((Object)this.wms);
        }
        throw new InvalidParameterException("Source is not of a support type");
    }

    public GridCoverageWriter getWriter(Object destination, Format format) throws IOException {
        throw new RuntimeException("Writing is not supported for WMSs");
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean setDataSource(Object datasource) {
        if (datasource instanceof String || datasource instanceof URL) {
            try {
                new URL((String)datasource);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }

    public WMSCapabilities getCapabilities() {
        return this.capabilities;
    }
}

