/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms.gce;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WMSUtils;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.opengis.layer.Style;
import org.opengis.parameter.GeneralParameterDescriptor;

public class WMSParameterMaker {
    private WMSCapabilities capabilities;

    public WMSParameterMaker(WMSCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    private Map fillProperties(String name, String remarks) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", name);
        properties.put("remarks", remarks);
        return properties;
    }

    public GeneralParameterDescriptor createVersionReadParam() {
        Object[] validValues = new String[]{"1.0.0", "1.1.0", "1.1.1", "1.3.0"};
        Map properties = this.fillProperties("VERSION", "Value contains the version of the WMS server to be used");
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, String.class, validValues, null, null, null, null, true);
        return param;
    }

    public GeneralParameterDescriptor createFormatReadParam() {
        Map properties = this.fillProperties("FORMAT", "Value contains the desired format");
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, String.class, (Object[])this.capabilities.getRequest().getGetMap().getFormatStrings(), null, null, null, null, true);
        return param;
    }

    public GeneralParameterDescriptor createRequestReadParam() {
        Map properties = this.fillProperties("REQUEST", "Value contains the the type of the request");
        String getMap = "GetMap";
        Object[] validValues = new String[]{getMap};
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, String.class, validValues, (Object)getMap, null, null, null, true);
        return param;
    }

    public GeneralParameterDescriptor createSRSReadParam() {
        Map properties = this.fillProperties("SRS", "Value contains the desired SRS for the entire map");
        TreeSet srs = new TreeSet();
        this.retrieveSRSs(this.capabilities.getLayerList().toArray(new Layer[this.capabilities.getLayerList().size()]), srs);
        Object[] validValues = srs.toArray();
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, String.class, validValues, null, null, null, null, true);
        return param;
    }

    private void retrieveSRSs(Layer[] layers, Set srsSet) {
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i].getSrs() == null) continue;
            srsSet.addAll(layers[i].getSrs());
        }
    }

    public GeneralParameterDescriptor createWidthReadParam() {
        Map properties = this.fillProperties("WIDTH", "Value contains the width, in pixels, of the requested map");
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, Integer.class, null, null, (Comparable)new Integer(1), null, null, true);
        return param;
    }

    public GeneralParameterDescriptor createHeightReadParam() {
        Map properties = this.fillProperties("HEIGHT", "Value contains the height, in pixels, of the requested map");
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, Integer.class, null, null, (Comparable)new Integer(1), null, null, true);
        return param;
    }

    public GeneralParameterDescriptor createLayersReadParam() {
        Map properties = this.fillProperties("LAYERS", "Describes each layer in the WMS and the styles associated with. The parameter name is the name of the layer. The valueis the style for that layer. The valid values are all the styles that layer can be drawn with.");
        List<Layer> layers = Arrays.asList(WMSUtils.getNamedLayers(this.capabilities));
        DefaultParameterDescriptor[] layerParams = new DefaultParameterDescriptor[layers.size()];
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = layers.get(i);
            Map layerProperties = this.fillProperties(layer.getName(), "");
            Object[] styles = new String[layer.getStyles().size()];
            for (int j = 0; j < layer.getStyles().size(); ++j) {
                Style style = (Style)layer.getStyles().get(j);
                styles[i] = style.getName();
            }
            layerParams[i] = new DefaultParameterDescriptor(layerProperties, class$java$lang$String == null ? WMSParameterMaker.class$("java.lang.String") : class$java$lang$String, styles, null, null, null, null, false);
        }
        DefaultParameterDescriptorGroup param = new DefaultParameterDescriptorGroup(properties, 0, layers.size(), (GeneralParameterDescriptor[])layerParams);
        return param;
    }

    private GeneralParameterDescriptor createBBoxParam(String coordDescriptor) {
        Map properties = this.fillProperties("BBOX_" + coordDescriptor.toUpperCase(), "Value contains the " + coordDescriptor + " value for the bounding box");
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, Double.class, null, null, null, null, null, true);
        return param;
    }

    public GeneralParameterDescriptor createBBoxMinXReadParam() {
        return this.createBBoxParam("minX");
    }

    public GeneralParameterDescriptor createBBoxMinYReadParam() {
        return this.createBBoxParam("minY");
    }

    public GeneralParameterDescriptor createBBoxMaxXReadParam() {
        return this.createBBoxParam("maxX");
    }

    public GeneralParameterDescriptor createBBoxMaxYReadParam() {
        return this.createBBoxParam("maxY");
    }

    public GeneralParameterDescriptor createTransparentReadParam() {
        Map properties = this.fillProperties("TRANSPARENT", "Value indicates map transparency");
        Object[] validValues = new Boolean[]{new Boolean(true), new Boolean(false)};
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, Boolean.class, validValues, (Object)new Boolean(false), null, null, null, false);
        return param;
    }

    public GeneralParameterDescriptor createBGColorReadParam() {
        Map properties = this.fillProperties("BGCOLOR", "Value indicates map background colour in hex format (0xRRGGBB)");
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, String.class, null, (Object)"0xFFFFFF", null, null, null, false);
        return param;
    }

    public GeneralParameterDescriptor createExceptionsReadParam() {
        Map properties = this.fillProperties("EXCEPTIONS", "Value indicates the format in which exceptions are returned");
        String defaultValue = "application/vnd.ogc.se_xml";
        Object[] validValues = new String[]{defaultValue};
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, String.class, validValues, (Object)defaultValue, null, null, null, false);
        return param;
    }

    public GeneralParameterDescriptor createTimeReadParam() {
        Map properties = this.fillProperties("TIME", "Value indicates the time value desired");
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, String.class, null, null, null, null, null, false);
        return param;
    }

    public GeneralParameterDescriptor createElevationReadParam() {
        Map properties = this.fillProperties("ELEVATION", "Value indicates the elevation value desired");
        DefaultParameterDescriptor param = new DefaultParameterDescriptor(properties, String.class, null, null, null, null, null, false);
        return param;
    }
}

