/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms.gce;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.geotools.coverage.FactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.gce.WMSFormat;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.data.wms.response.GetMapResponse;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.MetadataNameNotFoundException;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.Envelope;
import org.xml.sax.SAXException;

public class WMSReader
implements GridCoverageReader {
    private Object source;
    private boolean hasNext = true;
    private WMSFormat format;
    private WebMapServer wms;

    public WMSReader(Object source) throws IOException {
        this.source = source;
        if (!(source instanceof WebMapServer)) {
            throw new RuntimeException("source is not of type WebMapServer");
        }
        this.wms = (WebMapServer)((Object)source);
        this.format = new WMSFormat(this.wms.getCapabilities());
    }

    public Object getSource() {
        return this.source;
    }

    public String[] getMetadataNames() throws IOException {
        return null;
    }

    public String getMetadataValue(String arg0) throws IOException, MetadataNameNotFoundException {
        return null;
    }

    public String[] listSubNames() throws IOException {
        return null;
    }

    public String getCurrentSubname() throws IOException {
        return null;
    }

    public boolean hasMoreGridCoverages() throws IOException {
        return this.hasNext;
    }

    public void skip() throws IOException {
        this.hasNext = false;
    }

    public void dispose() throws IOException {
        this.hasNext = false;
    }

    public void setFormat(WMSFormat format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public GridCoverage read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        GetMapResponse response;
        GetMapRequest request = this.wms.createGetMapRequest();
        double minx = 0.0;
        double miny = 0.0;
        double maxx = 0.0;
        double maxy = 0.0;
        DefaultGeographicCRS crs = null;
        for (int i = 0; i < parameters.length; ++i) {
            GeneralParameterValue generalValue = parameters[i];
            String paramName = generalValue.getDescriptor().getName().getCode();
            if (generalValue == null) continue;
            if (paramName.equals("LAYERS")) {
                ParameterGroup groupValue = (ParameterGroup)generalValue;
                String layers = "";
                String styles = "";
                List layerList = groupValue.values();
                for (int j = 0; j < layerList.size(); ++j) {
                    Parameter parameter = (Parameter)layerList.get(j);
                    layers = layers + parameter.getDescriptor().getName().getCode();
                    styles = styles + (String)parameter.getValue();
                    if (j >= layerList.size() - 1) continue;
                    layers = layers + ",";
                    styles = styles + ",";
                }
                request.setProperty("LAYERS", layers);
                request.setProperty("STYLES", styles);
                continue;
            }
            ParameterValue value = (ParameterValue)generalValue;
            if (paramName.equals("BBOX_MINX")) {
                minx = (Double)value.getValue();
                continue;
            }
            if (paramName.equals("BBOX_MINY")) {
                miny = (Double)value.getValue();
                continue;
            }
            if (paramName.equals("BBOX_MAXX")) {
                maxx = (Double)value.getValue();
                continue;
            }
            if (paramName.equals("BBOX_MAXY")) {
                maxy = (Double)value.getValue();
                continue;
            }
            if (paramName.equals("HEIGHT")) {
                request.setProperty("HEIGHT", ((Integer)value.getValue()).toString());
                continue;
            }
            if (paramName.equals("WIDTH")) {
                request.setProperty("WIDTH", ((Integer)value.getValue()).toString());
                continue;
            }
            if (paramName.equals("TRANSPARENT")) {
                if (value.booleanValue()) {
                    request.setProperty("TRANSPARENT", "TRUE");
                    continue;
                }
                request.setProperty("TRANSPARENT", "FALSE");
                continue;
            }
            if (value.getValue() == null) continue;
            if (paramName.equals("SRS")) {
                String srs = value.stringValue();
                try {
                    crs = CRS.decode((String)srs);
                }
                catch (FactoryException e1) {
                    e1.printStackTrace();
                }
            }
            request.setProperty(value.getDescriptor().getName().getCode(), value.stringValue());
        }
        String bbox = minx + "," + miny + "," + maxx + "," + maxy;
        request.setProperty("BBOX", bbox);
        try {
            response = this.wms.issueRequest(request);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getLocalizedMessage());
        }
        BufferedImage image = ImageIO.read(response.getInputStream());
        if (image == null) {
            throw new IOException("Image cannot be read from:" + (Object)((Object)response));
        }
        if (crs == null) {
            crs = DefaultGeographicCRS.WGS84;
        }
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{minx, miny}, new double[]{maxx, maxy});
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)crs);
        this.hasNext = false;
        GridCoverageFactory factory = FactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D coverage = factory.create((CharSequence)"wmsMap", (RenderedImage)image, (Envelope)envelope);
        return coverage;
    }
}

