/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms.request;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.request.AbstractWMSRequest;
import org.geotools.data.wms.request.GetMapRequest;
import org.opengis.layer.Style;

public abstract class AbstractGetMapRequest
extends AbstractWMSRequest
implements GetMapRequest {
    Stack layers = new Stack();
    Stack styles = new Stack();

    public AbstractGetMapRequest(URL onlineResource, Properties properties) {
        super(onlineResource, properties);
    }

    public URL getFinalURL() {
        if (!this.layers.isEmpty()) {
            String layerString = "";
            String styleString = "";
            ListIterator layerIter = this.layers.listIterator(this.layers.size());
            ListIterator styleIter = this.styles.listIterator(this.styles.size());
            while (layerIter.hasPrevious()) {
                String layerName = (String)layerIter.previous();
                String styleName = (String)styleIter.previous();
                try {
                    layerString = layerString + URLEncoder.encode(layerName, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    layerString = layerString + layerName;
                }
                try {
                    styleString = styleString + URLEncoder.encode(StringUtils.defaultString((String)styleName), "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    styleString = styleString + StringUtils.defaultString((String)styleName);
                }
                if (!layerIter.hasPrevious()) continue;
                layerString = layerString + ",";
                styleString = styleString + ",";
            }
            this.setProperty("LAYERS", layerString);
            this.setProperty("STYLES", styleString);
        }
        return super.getFinalURL();
    }

    protected abstract void initVersion();

    protected void initRequest() {
        this.setProperty("REQUEST", "GetMap");
    }

    public void setVersion(String version) {
        this.properties.setProperty("VERSION", version);
    }

    public void addLayer(Layer layer, String style) {
        this.addLayer(layer.getName(), style);
    }

    public void addLayer(Layer layer) {
        this.addLayer(layer, "");
    }

    public void addLayer(String layerName, String style) {
        this.layers.push(layerName);
        if (style == null) {
            style = "";
        }
        this.styles.push(style);
    }

    public void addLayer(Layer layer, Style style) {
        if (style == null) {
            this.addLayer(layer.getName(), "");
            return;
        }
        this.addLayer(layer.getName(), style.getName());
    }

    public void addLayer(String layerName, Style style) {
        if (style == null) {
            this.addLayer(layerName, "");
            return;
        }
        this.addLayer(layerName, style.getName());
    }

    public void setSRS(String srs) {
        this.properties.setProperty("SRS", srs);
    }

    public void setBBox(String bbox) {
        this.properties.setProperty("BBOX", bbox);
    }

    public void setBBox(CRSEnvelope box) {
        StringBuffer sb = new StringBuffer();
        sb.append(box.getMinX());
        sb.append(",");
        sb.append(box.getMinY() + ",");
        sb.append(box.getMaxX() + ",");
        sb.append(box.getMaxY());
        this.setBBox(sb.toString());
    }

    public void setFormat(String format) {
        this.properties.setProperty("FORMAT", format);
    }

    public void setDimensions(String width, String height) {
        this.properties.setProperty("HEIGHT", height);
        this.properties.setProperty("WIDTH", width);
    }

    public void setTransparent(boolean transparent) {
        String value = "FALSE";
        if (transparent) {
            value = "TRUE";
        }
        this.properties.setProperty("TRANSPARENT", value);
    }

    public void setBGColour(String bgColour) {
        this.properties.setProperty("BGCOLOR", bgColour);
    }

    public void setExceptions(String exceptions) {
        this.properties.setProperty("EXCEPTIONS", exceptions);
    }

    public void setTime(String time) {
        this.properties.setProperty("TIME", time);
    }

    public void setElevation(String elevation) {
        this.properties.setProperty("ELEVATION", elevation);
    }

    public void setSampleDimensionValue(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void setVendorSpecificParameter(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void setDimensions(int width, int height) {
        this.setDimensions("" + width, "" + height);
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }
}

