/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.dir;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.view.DefaultView;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;

public class DirectoryDataStore
implements DataStore,
LockingManager {
    private File dir;
    private Map dataStores;
    private String[] createOrder;
    private List contents = null;

    private DirectoryDataStore() {
    }

    public FeatureSource getView(Query query) throws IOException, SchemaException {
        return new DefaultView(this.getFeatureSource(query.getTypeName()), query);
    }

    public DirectoryDataStore(File f, String[] co) throws MalformedURLException, IOException {
        this.dir = f;
        this.createOrder = co;
        this.dataStores = new HashMap();
        File[] children = f.listFiles();
        for (int i = 0; i < children.length; ++i) {
            AbstractFileDataStore afds;
            if (!children[i].isFile() || (afds = (AbstractFileDataStore)FileDataStoreFinder.getDataStore((URL)children[i].toURL())) == null) continue;
            this.dataStores.put(afds.getTypeNames()[0], afds);
        }
    }

    public String[] getTypeNames() throws IOException {
        HashSet<String> l = new HashSet<String>();
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            AbstractFileDataStore afds = (AbstractFileDataStore)i.next();
            String[] strs = afds.getTypeNames();
            if (strs == null) continue;
            for (int j = 0; j < strs.length; ++j) {
                l.add(strs[j]);
            }
        }
        return l.toArray(new String[l.size()]);
    }

    public FeatureType getSchema(String typeName) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getSchema();
        }
        return null;
    }

    public void createSchema(FeatureType featureType) throws IOException {
        boolean notDone = true;
        for (int i = 0; notDone && i < this.createOrder.length; ++i) {
            AbstractFileDataStore afds;
            File f = new File(this.dir, featureType.getTypeName() + this.createOrder[i]);
            if (f.exists() || (afds = (AbstractFileDataStore)FileDataStoreFinder.getDataStore((URL)f.toURL())) == null) continue;
            afds.createSchema(featureType);
            this.dataStores.put(featureType.getTypeName(), afds);
            notDone = false;
        }
    }

    public void updateSchema(String typeName, FeatureType featureType) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            afds.updateSchema(featureType);
        }
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureSource();
        }
        return null;
    }

    public FeatureReader getFeatureReader(Query query, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(query.getTypeName());
        if (afds != null) {
            return afds.getFeatureReader(query, transaction);
        }
        return null;
    }

    public FeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureWriter(filter, transaction);
        }
        return null;
    }

    public FeatureWriter getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureWriter(transaction);
        }
        return null;
    }

    public FeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null) {
            return afds.getFeatureWriterAppend(transaction);
        }
        return null;
    }

    public LockingManager getLockingManager() {
        return this;
    }

    public boolean exists(String authID) {
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            AbstractFileDataStore afds = (AbstractFileDataStore)i.next();
            if (afds.getLockingManager() == null || !afds.getLockingManager().exists(authID)) continue;
            return true;
        }
        return false;
    }

    public boolean release(String authID, Transaction transaction) throws IOException {
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            AbstractFileDataStore afds = (AbstractFileDataStore)i.next();
            if (afds.getLockingManager() == null || !afds.getLockingManager().exists(authID)) continue;
            return afds.getLockingManager().release(authID, transaction);
        }
        return false;
    }

    public boolean refresh(String authID, Transaction transaction) throws IOException {
        Iterator i = this.dataStores.values().iterator();
        while (i.hasNext()) {
            AbstractFileDataStore afds = (AbstractFileDataStore)i.next();
            if (afds.getLockingManager() == null || !afds.getLockingManager().exists(authID)) continue;
            return afds.getLockingManager().refresh(authID, transaction);
        }
        return false;
    }

    public void unLockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null && afds.getLockingManager() != null) {
            afds.getLockingManager().unLockFeatureID(typeName, authID, transaction, featureLock);
        }
    }

    public void lockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
        AbstractFileDataStore afds = (AbstractFileDataStore)this.dataStores.get(typeName);
        if (afds != null && afds.getLockingManager() != null) {
            afds.getLockingManager().lockFeatureID(typeName, authID, transaction, featureLock);
        }
    }
}

