/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.dir;

import [Ljava.lang.String;;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.dir.DirectoryDataStore;

public class DirectoryDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataStoreFactorySpi.Param DIRECTORY = new DataStoreFactorySpi.Param("data_directory url", URL.class, "Directory containing geospatial vector files", true);
    public static final DataStoreFactorySpi.Param CREATE_SUFFIX_ORDER = new DataStoreFactorySpi.Param("suffix_list", String;.class, "space delimited list of prefixes to attempt and create new files for.", true){

        public String text(Object value) {
            if (value instanceof String[]) {
                String[] values = (String[])value;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < values.length; ++i) {
                    sb.append(values[i] + " ");
                }
                sb.setLength(sb.length() - 1);
                return sb.toString();
            }
            return super.text(value);
        }
    };

    public DataStore createDataStore(Map params) throws IOException {
        if (!this.canProcess(params)) {
            throw new IOException("Invalid parameters for DirectoryDataStore");
        }
        URL url = (URL)DIRECTORY.lookUp(params);
        File f = new File(url.getFile());
        String[] strs = (String[])CREATE_SUFFIX_ORDER.lookUp(params);
        if (strs == null) {
            throw new IOException("Invalid parameter " + DirectoryDataStoreFactory.CREATE_SUFFIX_ORDER.key + " : is null");
        }
        if (!f.isDirectory()) {
            throw new IOException("Invalid parameter " + DirectoryDataStoreFactory.DIRECTORY.key + " : is not a valid directory");
        }
        return new DirectoryDataStore(f, strs);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        if (!this.canProcess(params)) {
            throw new IOException("Invalid parameters for DirectoryDataStore");
        }
        URL url = (URL)DIRECTORY.lookUp(params);
        File f = new File(url.getFile());
        if (f.exists()) {
            throw new IOException("Invalid parameter " + DirectoryDataStoreFactory.DIRECTORY.key + " : directory already exists");
        }
        if (!f.isDirectory()) {
            throw new IOException("Invalid parameter " + DirectoryDataStoreFactory.DIRECTORY.key + " : is not a valid directory");
        }
        if (!f.createNewFile()) {
            throw new IOException("Invalid parameter " + DirectoryDataStoreFactory.DIRECTORY.key + " : cannot create directory");
        }
        String[] strs = (String[])CREATE_SUFFIX_ORDER.lookUp(params);
        if (strs == null) {
            throw new IOException("Invalid parameter " + DirectoryDataStoreFactory.CREATE_SUFFIX_ORDER.key + " : is null");
        }
        return new DirectoryDataStore(f, strs);
    }

    public String getDisplayName() {
        return "Directory DataStore";
    }

    public String getDescription() {
        return "Propagates to multiple file types representing a directory";
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{DIRECTORY, CREATE_SUFFIX_ORDER};
    }

    public boolean canProcess(Map params) {
        try {
            URL url = (URL)DIRECTORY.lookUp(params);
            File f = new File(url.getFile());
            String[] str = (String[])CREATE_SUFFIX_ORDER.lookUp(params);
            return f != null && str != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

