/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import com.vividsolutions.jts.geom.Geometry;
import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.io.TripletId;
import org.geotools.data.vpf.util.DataUtils;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;

public class VPFColumn
implements AttributeType,
DataTypesDefinition {
    private boolean attemptLookup = false;
    private final AttributeType attribute;
    private final int elementsNumber;
    private final String narrTable;
    private final char keyType;
    private final String colDesc;
    private final String thematicIdx;
    private final char typeChar;
    private final String valDescTableName;

    public VPFColumn(String name, char type, int elementsNumber, char keyType, String colDesc, String valDescTableName, String thematicIdx, String narrTable) {
        this.typeChar = type;
        this.elementsNumber = elementsNumber;
        this.keyType = keyType;
        this.colDesc = colDesc;
        this.valDescTableName = valDescTableName;
        this.thematicIdx = thematicIdx;
        this.narrTable = narrTable;
        this.attribute = elementsNumber > 0 ? AttributeTypeFactory.newAttributeType((String)name, (Class)this.getColumnClass(), (boolean)true, (int)elementsNumber) : AttributeTypeFactory.newAttributeType((String)name, (Class)this.getColumnClass(), (boolean)true, (int)Integer.MAX_VALUE);
    }

    public Class getColumnClass() {
        Class columnClass;
        switch (this.typeChar) {
            case 'I': {
                columnClass = Integer.class;
                break;
            }
            case 'F': {
                columnClass = Float.class;
                break;
            }
            case 'R': {
                columnClass = Double.class;
                break;
            }
            case 'B': 
            case 'C': 
            case 'Y': 
            case 'Z': {
                columnClass = Geometry.class;
                break;
            }
            case 'K': {
                columnClass = TripletId.class;
                break;
            }
            case 'S': {
                this.attemptLookup = true;
            }
            default: {
                columnClass = String.class;
            }
        }
        return columnClass;
    }

    public Object createDefaultValue() {
        return this.attribute.createDefaultValue();
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        return this.attribute.duplicate(src);
    }

    public int getColumnSize() {
        return DataUtils.getDataTypeSize(this.typeChar) * this.elementsNumber;
    }

    public String getName() {
        return this.attribute.getName();
    }

    public String getNarrTable() {
        return this.narrTable;
    }

    public String getThematicIdx() {
        return this.thematicIdx;
    }

    public Class getType() {
        return this.attribute.getType();
    }

    public String getValDescTableName() {
        return this.valDescTableName;
    }

    public boolean isGeometry() {
        return this.attribute instanceof Geometry;
    }

    public boolean isNillable() {
        return this.attribute.isNillable();
    }

    public Object parse(Object value) throws IllegalArgumentException {
        return this.attribute.parse(value);
    }

    public void validate(Object obj) throws IllegalArgumentException {
        this.attribute.validate(obj);
    }

    public char getTypeChar() {
        return this.typeChar;
    }

    public int getElementsNumber() {
        return this.elementsNumber;
    }

    public GeometryAttributeType getGeometryAttributeType() {
        GeometryAttributeType result = null;
        if (this.isGeometry()) {
            result = (GeometryAttributeType)this.attribute;
        }
        return result;
    }

    public boolean isAttemptLookup() {
        return this.attemptLookup;
    }

    public Filter getRestriction() {
        return this.attribute.getRestriction();
    }

    public int getMinOccurs() {
        return 1;
    }

    public int getMaxOccurs() {
        return 1;
    }

    public boolean equals(Object obj) {
        return this.attribute.equals(obj);
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }
}

