/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.geotools.data.vpf.ColumnPair;
import org.geotools.data.vpf.VPFColumn;
import org.geotools.data.vpf.VPFCoverage;
import org.geotools.data.vpf.VPFLibrary;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.readers.AreaGeometryFactory;
import org.geotools.data.vpf.readers.ConnectedNodeGeometryFactory;
import org.geotools.data.vpf.readers.EntityNodeGeometryFactory;
import org.geotools.data.vpf.readers.LineGeometryFactory;
import org.geotools.data.vpf.readers.TextGeometryFactory;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.AnnotationFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class VPFFeatureClass
implements DataTypesDefinition,
FileConstants,
FeatureType {
    private DefaultFeatureType featureType;
    private final List columns = new Vector();
    private final VPFCoverage coverage;
    private final String directoryName;
    private final AbstractList fileList = new Vector();
    private final AbstractList joinList = new Vector();
    private final String typeName;
    private final URI namespace;
    private VPFGeometryFactory geometryFactory;
    private boolean textTypeFeature = false;

    public VPFFeatureClass(VPFCoverage cCoverage, String cName, String cDirectoryName) throws SchemaException {
        this(cCoverage, cName, cDirectoryName, null);
    }

    public VPFFeatureClass(VPFCoverage cCoverage, String cName, String cDirectoryName, URI cNamespace) throws SchemaException {
        this.coverage = cCoverage;
        this.directoryName = cDirectoryName;
        this.typeName = cName;
        this.namespace = cNamespace == null ? VPFLibrary.DEFAULT_NAMESPACE : cNamespace;
        String fcsFileName = this.directoryName + File.separator + "fcs";
        try {
            VPFFile fcsFile = VPFFileFactory.getInstance().getFile(fcsFileName);
            Iterator iter = fcsFile.readAllRows().iterator();
            while (iter.hasNext()) {
                Feature feature = (Feature)iter.next();
                String featureClassName = feature.getAttribute("feature_class").toString().trim();
                if (!this.typeName.equals(featureClassName)) continue;
                this.addFCS(feature);
            }
            iter = this.columns.iterator();
            GeometryAttributeType gat = null;
            AttributeType geometryColumn = null;
            while (iter.hasNext()) {
                if (!(class$com$vividsolutions$jts$geom$Geometry == null ? VPFFeatureClass.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom((geometryColumn = (AttributeType)iter.next()).getType())) continue;
                if (geometryColumn instanceof GeometryAttributeType) {
                    gat = (GeometryAttributeType)geometryColumn;
                    break;
                }
                if (!(geometryColumn instanceof VPFColumn)) break;
                gat = ((VPFColumn)geometryColumn).getGeometryAttributeType();
                break;
            }
            Vector<FeatureType> superTypes = new Vector<FeatureType>();
            if (this.textTypeFeature) {
                superTypes.add(AnnotationFeatureType.ANNOTATION);
            }
            this.featureType = new DefaultFeatureType(cName, this.namespace, (Collection)this.columns, superTypes, gat);
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    private void addFCS(Feature row) {
        String table1 = row.getAttribute("table1").toString();
        String table1Key = row.getAttribute("table1_key").toString();
        String table2 = row.getAttribute("table2").toString();
        String table2Key = row.getAttribute("table2_key").toString();
        try {
            AttributeType joinColumn2;
            VPFFile vpfFile1 = VPFFileFactory.getInstance().getFile(this.directoryName.concat(File.separator).concat(table1));
            this.addFileToTable(vpfFile1);
            VPFFile vpfFile2 = null;
            VPFColumn joinColumn1 = (VPFColumn)vpfFile1.getAttributeType(table1Key);
            try {
                vpfFile2 = VPFFileFactory.getInstance().getFile(this.directoryName.concat(File.separator).concat(table2));
                this.addFileToTable(vpfFile2);
                joinColumn2 = (VPFColumn)vpfFile2.getAttributeType(table2Key);
            }
            catch (IOException exc) {
                this.fileList.add(null);
                joinColumn2 = this.buildGeometryColumn(table2);
            }
            if (!this.joinList.contains(new ColumnPair(joinColumn2, joinColumn1))) {
                this.joinList.add(new ColumnPair(joinColumn1, joinColumn2));
            }
        }
        catch (IOException exc) {
            // empty catch block
        }
    }

    private AttributeType buildGeometryColumn(String table) {
        AttributeType result = null;
        table = table.trim().toLowerCase();
        CoordinateReferenceSystem crs = this.getCoverage().getLibrary().getCoordinateReferenceSystem();
        result = crs != null ? AttributeTypeFactory.newAttributeType((String)"GEOMETRY", (Class)Geometry.class, (boolean)true, (int)-1, null, (Object)crs) : AttributeTypeFactory.newAttributeType((String)"GEOMETRY", (Class)Geometry.class, (boolean)true);
        this.columns.add(result);
        this.setGeometryFactory(table);
        return result;
    }

    private void setGeometryFactory(String table) {
        if (table.equals("edg")) {
            this.geometryFactory = new LineGeometryFactory();
        } else if (table.equals("fac")) {
            this.geometryFactory = new AreaGeometryFactory();
        } else if (table.equals("cnd")) {
            this.geometryFactory = new ConnectedNodeGeometryFactory();
        } else if (table.equals("end")) {
            this.geometryFactory = new EntityNodeGeometryFactory();
        } else if (table.equals("txt")) {
            this.geometryFactory = new TextGeometryFactory();
            this.textTypeFeature = true;
        }
    }

    private void addFileToTable(VPFFile vpfFile) {
        boolean addPrimaryKey = this.fileList.isEmpty();
        if (!this.fileList.contains(vpfFile)) {
            int inx;
            this.fileList.add(vpfFile);
            int n = inx = addPrimaryKey ? 0 : 1;
            while (inx < vpfFile.getAttributeCount()) {
                this.columns.add(vpfFile.getAttributeType(inx));
                ++inx;
            }
        }
    }

    public VPFCoverage getCoverage() {
        return this.coverage;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public List getFileList() {
        return this.fileList;
    }

    public List getJoinList() {
        return this.joinList;
    }

    public URI getNamespace() {
        return this.featureType.getNamespace();
    }

    public String getTypeName() {
        return this.featureType.getTypeName();
    }

    public AttributeType[] getAttributeTypes() {
        return this.featureType.getAttributeTypes();
    }

    public boolean hasAttributeType(String xPath) {
        return this.featureType.hasAttributeType(xPath);
    }

    public AttributeType getAttributeType(String xPath) {
        return this.featureType.getAttributeType(xPath);
    }

    public int find(AttributeType type) {
        return this.featureType.find(type);
    }

    public GeometryAttributeType getDefaultGeometry() {
        return this.featureType.getDefaultGeometry();
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public AttributeType getAttributeType(int position) {
        return this.featureType.getAttributeType(position);
    }

    public boolean isDescendedFrom(URI nsURI, String typeName) {
        return this.featureType.isDescendedFrom(nsURI, typeName);
    }

    public boolean isDescendedFrom(FeatureType type) {
        return this.featureType.isDescendedFrom(type);
    }

    public boolean isAbstract() {
        return this.featureType.isAbstract();
    }

    public FeatureType[] getAncestors() {
        return this.featureType.getAncestors();
    }

    public Feature duplicate(Feature feature) throws IllegalAttributeException {
        return this.featureType.duplicate(feature);
    }

    public Feature create(Object[] attributes) throws IllegalAttributeException {
        if (attributes.length > 0 && attributes[0] != null) {
            return this.create(attributes, attributes[0].toString());
        }
        return this.featureType.create(attributes);
    }

    public Feature create(Object[] attributes, String featureID) throws IllegalAttributeException {
        return this.featureType.create(attributes, featureID);
    }

    public VPFGeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public int find(String attName) {
        return this.featureType.find(attName);
    }

    public boolean equals(Object obj) {
        return this.featureType.equals(obj);
    }

    public int hashCode() {
        return this.featureType.hashCode();
    }
}

