/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.vpf.ColumnPair;
import org.geotools.data.vpf.VPFColumn;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FCode;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class VPFFeatureReader
implements FeatureReader,
FCode {
    private boolean hasNext = true;
    private boolean nextCalled = true;
    private Feature currentFeature = null;
    private final VPFFeatureType featureType;

    public VPFFeatureReader(VPFFeatureType type) {
        this.featureType = type;
    }

    public void close() throws IOException {
        this.reset();
    }

    private Map generateFileRowMap(VPFFile file, Feature row) throws IOException {
        Object tileFileName = null;
        HashMap<VPFFile, Feature> rows = new HashMap<VPFFile, Feature>();
        rows.put(file, row);
        Iterator joinIter = this.featureType.getFeatureClass().getJoinList().iterator();
        while (joinIter.hasNext()) {
            ColumnPair columnPair = (ColumnPair)joinIter.next();
            VPFFile primaryFile = this.getVPFFile(columnPair.column1);
            VPFFile joinFile = null;
            joinFile = this.getVPFFile(columnPair.column2);
            if (rows.containsKey(joinFile) || !rows.containsKey(primaryFile)) continue;
            Feature joinRow = (Feature)rows.get(primaryFile);
            try {
                int joinID = Integer.parseInt(joinRow.getAttribute(columnPair.column1.getName()).toString());
                rows.put(joinFile, this.getVPFFile(columnPair.column2).getRowFromId(columnPair.column2.getName(), joinID));
            }
            catch (NullPointerException exc) {
                rows.put(joinFile, null);
            }
            catch (IllegalAttributeException exc) {
                exc.printStackTrace();
                rows.put(joinFile, null);
            }
        }
        return rows;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        if (this.nextCalled) {
            while (this.readNext()) {
            }
            this.nextCalled = false;
        }
        return this.hasNext;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        this.nextCalled = true;
        return this.currentFeature;
    }

    private boolean readNext() throws IOException {
        boolean result = true;
        VPFFile file = (VPFFile)this.featureType.getFeatureClass().getFileList().get(0);
        this.hasNext = false;
        Feature row = null;
        try {
            if (file.hasNext()) {
                row = file.readFeature();
            }
        }
        catch (IOException exc1) {
            exc1.printStackTrace();
        }
        catch (IllegalAttributeException exc1) {
            exc1.printStackTrace();
        }
        if (row == null) {
            this.hasNext = false;
            result = false;
        } else if (this.featureType.getFaccCode() != null) {
            try {
                Object temp = null;
                for (int i = 0; temp == null && i < ALLOWED_FCODE_ATTRIBUTES.length; ++i) {
                    temp = row.getAttribute(ALLOWED_FCODE_ATTRIBUTES[i]);
                }
                String faccCode = temp.toString().trim();
                if (this.featureType.getFaccCode().equals(faccCode)) {
                    this.retrieveObject(file, row);
                    this.hasNext = true;
                    result = false;
                }
            }
            catch (RuntimeException exc) {
                // empty catch block
            }
        }
        return result;
    }

    private void retrieveObject(VPFFile file, Feature row) throws IOException {
        VPFFile secondFile = null;
        VPFColumn column = null;
        Map rows = this.generateFileRowMap(file, row);
        AttributeType[] attributes = this.featureType.getFeatureClass().getAttributeTypes();
        Object[] values = new Object[this.featureType.getAttributeCount()];
        Object value = null;
        String featureId = null;
        for (int inx = 0; inx < attributes.length; ++inx) {
            if (!attributes[inx].getName().equals("id")) continue;
            value = row.getAttribute(inx);
            if (value == null) break;
            featureId = value.toString();
            break;
        }
        try {
            this.currentFeature = this.featureType.create(values, featureId);
        }
        catch (IllegalAttributeException exc) {
            exc.printStackTrace();
        }
        for (int inx = 0; inx < attributes.length; ++inx) {
            try {
                if (attributes[inx].getName().equals("annotation_attribute_name")) {
                    try {
                        this.currentFeature.setAttribute(inx, (Object)"nam");
                    }
                    catch (IllegalAttributeException exc) {
                        exc.printStackTrace();
                    }
                    continue;
                }
                column = (VPFColumn)attributes[inx];
                value = null;
                secondFile = this.getVPFFile(column);
                Feature tempRow = (Feature)rows.get(secondFile);
                if (tempRow != null) {
                    value = tempRow.getAttribute(column.getName());
                    if (column.isAttemptLookup()) {
                        try {
                            String featureClassName = this.getVPFFile(column).getFileName();
                            String intVdtFileName = this.featureType.getFeatureClass().getDirectoryName().concat(File.separator).concat("int.vdt");
                            VPFFile intVdtFile = VPFFileFactory.getInstance().getFile(intVdtFileName);
                            Iterator intVdtIter = intVdtFile.readAllRows().iterator();
                            while (intVdtIter.hasNext()) {
                                Feature intVdtRow = (Feature)intVdtIter.next();
                                if (!intVdtRow.getAttribute("table").toString().trim().equals(featureClassName) || Short.parseShort(intVdtRow.getAttribute("value").toString()) != Short.parseShort(value.toString()) || !intVdtRow.getAttribute("attribute").toString().trim().equals(column.getName())) continue;
                                value = intVdtRow.getAttribute("description").toString().trim();
                                break;
                            }
                        }
                        catch (IOException exc) {
                        }
                        catch (RuntimeException exc) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.currentFeature.setAttribute(inx, value);
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    exc.printStackTrace();
                }
                catch (IllegalAttributeException exc) {
                    exc.printStackTrace();
                }
                continue;
            }
            catch (ClassCastException exc2) {
                try {
                    this.featureType.getFeatureClass().getGeometryFactory().createGeometry(this.featureType, this.currentFeature);
                    continue;
                }
                catch (IllegalAttributeException exc) {
                    exc.printStackTrace();
                    continue;
                }
                catch (SQLException exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    private VPFFile getVPFFile(AttributeType column) {
        VPFFile result = null;
        Iterator iter = this.featureType.getFeatureClass().getFileList().iterator();
        while (iter.hasNext()) {
            VPFFile temp = (VPFFile)iter.next();
            if (temp == null || temp.find(column) < 0) continue;
            result = temp;
            break;
        }
        return result;
    }

    public void reset() {
        VPFFile file = (VPFFile)this.featureType.getFeatureClass().getFileList().get(0);
        file.reset();
        VPFFileFactory.getInstance().reset();
    }
}

