/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.net.URI;
import java.util.List;
import org.geotools.data.vpf.VPFCoverage;
import org.geotools.data.vpf.VPFFeatureClass;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;

public class VPFFeatureType
implements FeatureType {
    private final VPFFeatureClass featureClass;
    private final String typeName;
    private final String faccCode;

    public VPFFeatureType(VPFFeatureClass cFeatureClass, Feature cFeature) {
        this.featureClass = cFeatureClass;
        this.faccCode = cFeature.getAttribute("value").toString().trim();
        String mainTableFileName = cFeature.getAttribute("table").toString().trim();
        String tempTypeName = cFeature.getAttribute("description").toString().trim();
        try {
            int index = mainTableFileName.lastIndexOf(".") + 1;
            String dimensionality = mainTableFileName.substring(index, index + 1).toLowerCase();
            if (dimensionality.equals("a")) {
                tempTypeName = tempTypeName.concat(" Area");
            } else if (dimensionality.equals("l")) {
                tempTypeName = tempTypeName.concat(" Line");
            } else if (dimensionality.equals("p")) {
                tempTypeName = tempTypeName.concat(" Point");
            } else if (dimensionality.equals("t")) {
                tempTypeName = tempTypeName.concat(" Text");
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        tempTypeName = tempTypeName.toUpperCase();
        tempTypeName = tempTypeName.replace(' ', '_');
        tempTypeName = tempTypeName.replace('/', '_');
        tempTypeName = tempTypeName.replace('(', '_');
        this.typeName = tempTypeName = tempTypeName.replace(')', '_');
    }

    public VPFFeatureType(VPFFeatureClass cFeatureClass) {
        this.featureClass = cFeatureClass;
        this.faccCode = null;
        this.typeName = cFeatureClass.getTypeName().toUpperCase();
    }

    public Feature create(Object[] attributes) throws IllegalAttributeException {
        return this.featureClass.create(attributes);
    }

    public Feature create(Object[] attributes, String featureID) throws IllegalAttributeException {
        return this.featureClass.create(attributes, featureID);
    }

    public Feature duplicate(Feature feature) throws IllegalAttributeException {
        return this.featureClass.duplicate(feature);
    }

    public int find(AttributeType type) {
        return this.featureClass.find(type);
    }

    public FeatureType[] getAncestors() {
        return this.featureClass.getAncestors();
    }

    public int getAttributeCount() {
        return this.featureClass.getAttributeCount();
    }

    public AttributeType getAttributeType(int position) {
        return this.featureClass.getAttributeType(position);
    }

    public AttributeType getAttributeType(String xPath) {
        return this.featureClass.getAttributeType(xPath);
    }

    public AttributeType[] getAttributeTypes() {
        return this.featureClass.getAttributeTypes();
    }

    public VPFCoverage getCoverage() {
        return this.featureClass.getCoverage();
    }

    public GeometryAttributeType getDefaultGeometry() {
        return this.featureClass.getDefaultGeometry();
    }

    public String getDirectoryName() {
        return this.featureClass.getDirectoryName();
    }

    public VPFFeatureClass getFeatureClass() {
        return this.featureClass;
    }

    public List getFileList() {
        return this.featureClass.getFileList();
    }

    public List getJoinList() {
        return this.featureClass.getJoinList();
    }

    public URI getNamespace() {
        return this.featureClass.getNamespace();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean hasAttributeType(String xPath) {
        return this.featureClass.hasAttributeType(xPath);
    }

    public boolean isAbstract() {
        return this.featureClass.isAbstract();
    }

    public boolean isDescendedFrom(FeatureType type) {
        return this.featureClass.isDescendedFrom(type);
    }

    public boolean isDescendedFrom(URI nsURI, String typeName) {
        return this.featureClass.isDescendedFrom(nsURI, typeName);
    }

    public String getFaccCode() {
        return this.faccCode;
    }

    public int find(String attName) {
        return this.featureClass.find(attName);
    }

    public boolean equals(Object obj) {
        return this.featureClass.equals(obj);
    }

    public int hashCode() {
        return this.featureClass.hashCode();
    }
}

