/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.vpf.VPFCoverage;
import org.geotools.data.vpf.VPFFeatureReader;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.ifc.VPFLibraryIfc;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class VPFLibrary
extends AbstractDataStore
implements FileConstants,
VPFLibraryIfc {
    private final double xmin;
    private final double ymin;
    private final double xmax;
    private final double ymax;
    private final File directory;
    private final String libraryName;
    private final List coverages = new Vector();
    private CoordinateReferenceSystem crs;
    private boolean loggedCRSException = false;
    static URI DEFAULT_NAMESPACE;
    private URI namespace = DEFAULT_NAMESPACE;
    private final Map tileMap = new HashMap();

    public VPFLibrary(Feature libraryFeature, File dir) throws IOException, SchemaException {
        this.xmin = ((Number)libraryFeature.getAttribute("xmin")).doubleValue();
        this.ymin = ((Number)libraryFeature.getAttribute("ymin")).doubleValue();
        this.xmax = ((Number)libraryFeature.getAttribute("xmax")).doubleValue();
        this.ymax = ((Number)libraryFeature.getAttribute("ymax")).doubleValue();
        this.libraryName = libraryFeature.getAttribute("library_name").toString();
        this.directory = new File(dir, this.libraryName);
        this.setCoverages();
    }

    public VPFLibrary(File dir) throws IOException, SchemaException {
        this(dir, DEFAULT_NAMESPACE);
    }

    public VPFLibrary(File dir, URI namespace) throws IOException, SchemaException {
        String vpfTableName = new File(dir, "lht").toString();
        VPFFile lhtFile = VPFFileFactory.getInstance().getFile(vpfTableName);
        lhtFile.reset();
        this.namespace = namespace;
        try {
            lhtFile.readFeature();
        }
        catch (IllegalAttributeException exc) {
            exc.printStackTrace();
            throw new IOException("Illegal values in library attribute table");
        }
        this.xmin = -180.0;
        this.ymin = -90.0;
        this.xmax = 180.0;
        this.ymax = 90.0;
        this.directory = dir;
        String directoryName = this.directory.getPath();
        this.libraryName = directoryName.substring(directoryName.lastIndexOf(File.separator) + 1);
        this.setCoverages();
    }

    private void setCoverages() throws IOException, SchemaException {
        if (!this.directory.getName().equals("rference")) {
            String vpfTableName = new File(this.directory, "cat").toString();
            VPFFile vpfFile = VPFFileFactory.getInstance().getFile(vpfTableName);
            Iterator iter = vpfFile.readAllRows().iterator();
            while (iter.hasNext()) {
                Feature feature = (Feature)iter.next();
                String directoryName = this.directory.getPath();
                VPFCoverage coverage = new VPFCoverage(this, feature, directoryName, this.namespace);
                this.coverages.add(coverage);
                if (!coverage.getName().toLowerCase().equals("tileref")) continue;
                this.createTilingSchema(coverage);
            }
        }
    }

    public List getCoverages() {
        return this.coverages;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public String toString() {
        return "Dette er library : " + this.libraryName + " with extensions:\n" + this.getXmin() + " " + this.getYmin() + " - " + this.getXmax() + " " + this.getYmax() + "\n";
    }

    public Map getTileMap() {
        return this.tileMap;
    }

    private void createTilingSchema(VPFCoverage coverage) throws IOException {
        VPFFeatureType tileType = (VPFFeatureType)coverage.getFeatureTypes().get(0);
        VPFFile tileFile = (VPFFile)tileType.getFeatureClass().getFileList().get(0);
        Iterator rowsIter = tileFile.readAllRows().iterator();
        while (rowsIter.hasNext()) {
            Feature row = (Feature)rowsIter.next();
            Short rowId = new Short(Short.parseShort(row.getAttribute("id").toString()));
            String value = row.getAttribute("tile_name").toString();
            String[] tmp = value.split("\\\\");
            value = tmp[0];
            int ii = tmp.length;
            for (int i = 1; i < ii; ++i) {
                value = value.concat(File.separator).concat(tmp[i]);
            }
            this.tileMap.put(rowId, value);
        }
    }

    public String[] getTypeNames() {
        int inx;
        String[] result = null;
        int coveragesCount = this.coverages.size();
        int featureTypesCount = 0;
        int index = 0;
        List[] coverageTypes = new List[coveragesCount];
        for (inx = 0; inx < coveragesCount; ++inx) {
            coverageTypes[inx] = ((VPFCoverage)this.coverages.get(inx)).getFeatureTypes();
            featureTypesCount += coverageTypes[inx].size();
        }
        result = new String[featureTypesCount];
        for (inx = 0; inx < coveragesCount; ++inx) {
            for (int jnx = 0; jnx < coverageTypes[inx].size(); ++jnx) {
                result[index] = ((FeatureType)coverageTypes[inx].get(jnx)).getTypeName();
                ++index;
            }
        }
        return result;
    }

    public FeatureType getSchema(String typeName) {
        FeatureType result = null;
        Iterator coverageIter = this.coverages.iterator();
        boolean breakOut = false;
        block0: while (coverageIter.hasNext() && !breakOut) {
            Iterator featureTypesIter = ((VPFCoverage)coverageIter.next()).getFeatureTypes().iterator();
            while (featureTypesIter.hasNext()) {
                FeatureType temp = (FeatureType)featureTypesIter.next();
                if (!temp.getTypeName().equals(typeName)) continue;
                result = temp;
                breakOut = true;
                continue block0;
            }
        }
        return result;
    }

    protected FeatureReader getFeatureReader(String typeName) {
        VPFFeatureReader result = null;
        VPFFeatureType featureType = (VPFFeatureType)this.getSchema(typeName);
        ((VPFFile)featureType.getFileList().get(0)).reset();
        result = new VPFFeatureReader(featureType);
        return result;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        block4: {
            if (this.crs == null) {
                try {
                    String geoDatumCode;
                    String vpfTableName = new File(this.directory, "grt").toString();
                    VPFFile grtFile = VPFFileFactory.getInstance().getFile(vpfTableName);
                    Feature grt = grtFile.getRowFromId("id", 1);
                    String dataType = String.valueOf(grt.getAttribute("data_type"));
                    if ("GEO".equalsIgnoreCase(dataType) && "WGE".equalsIgnoreCase(geoDatumCode = String.valueOf(grt.getAttribute("geo_datum_code")))) {
                        this.crs = DefaultGeographicCRS.WGS84;
                    }
                }
                catch (Exception ex) {
                    if (this.loggedCRSException) break block4;
                    ex.printStackTrace();
                    this.loggedCRSException = true;
                }
            }
        }
        return this.crs;
    }

    static {
        try {
            DEFAULT_NAMESPACE = new URI("http://www.vpf.org/default");
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("programmer error making default uri");
        }
    }
}

