/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.file;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.geotools.data.vpf.VPFColumn;
import org.geotools.data.vpf.exc.VPFHeaderFormatException;
import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.io.TripletId;
import org.geotools.data.vpf.io.VPFInputStream;
import org.geotools.data.vpf.io.VariableIndexInputStream;
import org.geotools.data.vpf.io.VariableIndexRow;
import org.geotools.data.vpf.util.DataUtils;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.AnnotationFeatureType;

public class VPFFile
implements FeatureType,
FileConstants,
DataTypesDefinition {
    private static String ACCESS_MODE = "r";
    private char byteOrder = (char)76;
    private final List columns = new Vector();
    private String description = null;
    private final FeatureType featureType;
    private int headerLength = 0;
    private RandomAccessFile inputStream = null;
    private String narrativeTable = null;
    private final String pathName;
    private VPFInputStream variableIndex = null;

    public VPFFile(String cPathName) throws IOException, SchemaException {
        this.pathName = cPathName;
        this.inputStream = new RandomAccessFile(cPathName, ACCESS_MODE);
        this.readHeader();
        GeometryAttributeType gat = null;
        VPFColumn geometryColumn = null;
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            geometryColumn = (VPFColumn)iter.next();
            if (!geometryColumn.isGeometry()) continue;
            gat = geometryColumn.getGeometryAttributeType();
            break;
        }
        Vector<FeatureType> superTypes = new Vector<FeatureType>();
        if (this.pathName.endsWith("txt")) {
            superTypes.add(AnnotationFeatureType.ANNOTATION);
        }
        this.featureType = new DefaultFeatureType(cPathName, "VPF", (Collection)this.columns, superTypes, gat);
    }

    public Feature create(Object[] attributes) throws IllegalAttributeException {
        return this.featureType.create(attributes);
    }

    public Feature create(Object[] attributes, String featureID) throws IllegalAttributeException {
        return this.featureType.create(attributes, featureID);
    }

    public Feature duplicate(Feature feature) throws IllegalAttributeException {
        return this.featureType.duplicate(feature);
    }

    public int find(AttributeType type) {
        return this.featureType.find(type);
    }

    private int getAdjustedHeaderLength() {
        return this.headerLength + 4;
    }

    public FeatureType[] getAncestors() {
        return this.featureType.getAncestors();
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public AttributeType getAttributeType(int position) {
        return this.featureType.getAttributeType(position);
    }

    public AttributeType getAttributeType(String xPath) {
        return this.featureType.getAttributeType(xPath);
    }

    public AttributeType[] getAttributeTypes() {
        return this.featureType.getAttributeTypes();
    }

    public char getByteOrder() {
        return this.byteOrder;
    }

    public GeometryAttributeType getDefaultGeometry() {
        return this.featureType.getDefaultGeometry();
    }

    public String getDescription() {
        return this.description;
    }

    public String getDirectoryName() {
        String result = new String();
        int index = this.pathName.lastIndexOf(File.separator);
        if (index >= 0) {
            result = this.pathName.substring(0, index);
        }
        return result;
    }

    public String getFileName() {
        String result = this.pathName.substring(this.pathName.lastIndexOf(File.separator) + 1);
        return result;
    }

    public URI getNamespace() {
        return this.featureType.getNamespace();
    }

    public String getNarrativeTable() {
        return this.narrativeTable;
    }

    public String getPathName() {
        return this.pathName;
    }

    protected int getRecordSize() {
        int size = 0;
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            VPFColumn column = (VPFColumn)iter.next();
            int currentSize = column.getColumnSize();
            if (currentSize < 0) {
                return -1;
            }
            size += currentSize;
        }
        return size;
    }

    public Feature getRowFromId(String idName, int id) throws IllegalAttributeException {
        Feature result = null;
        try {
            String firstColumnName = ((VPFColumn)this.columns.get(0)).getName();
            if (idName.equals(firstColumnName)) {
                this.setPosition(id);
                result = this.readFeature();
                Number value = (Number)result.getAttribute(idName);
                if (value == null || value.intValue() != id) {
                    result = null;
                }
            }
            if (result == null) {
                Iterator joinedIter = this.readAllRows().iterator();
                result = this.getRowFromIterator(joinedIter, idName, id);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return result;
    }

    private Feature getRowFromIterator(Iterator iter, String idName, int id) {
        Feature result = null;
        int value = -1;
        while (iter.hasNext()) {
            Feature currentFeature = (Feature)iter.next();
            try {
                value = Integer.parseInt(currentFeature.getAttribute(idName).toString());
                if (id != value) continue;
                result = currentFeature;
                break;
            }
            catch (NumberFormatException exc) {
                exc.printStackTrace();
            }
        }
        return result;
    }

    public String getTypeName() {
        return this.featureType.getTypeName();
    }

    public boolean hasAttributeType(String xPath) {
        return this.featureType.hasAttributeType(xPath);
    }

    public boolean hasNext() {
        boolean result = false;
        try {
            int recordSize = this.getRecordSize();
            result = recordSize > 0 ? this.inputStream.length() >= this.inputStream.getFilePointer() + (long)recordSize : this.inputStream.length() >= this.inputStream.getFilePointer() + 1L;
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return result;
    }

    public boolean isAbstract() {
        return this.featureType.isAbstract();
    }

    public boolean isDescendedFrom(FeatureType type) {
        return this.featureType.isDescendedFrom(type);
    }

    public boolean isDescendedFrom(URI nsURI, String typeName) {
        return this.featureType.isDescendedFrom(nsURI, typeName);
    }

    public AbstractList readAllRows() throws IOException {
        LinkedList<Feature> list = new LinkedList<Feature>();
        try {
            this.setPosition(1L);
        }
        catch (IOException exc) {
            return list;
        }
        try {
            Feature row = this.readFeature();
            while (row != null) {
                ((AbstractList)list).add(row);
                if (this.hasNext()) {
                    row = this.readFeature();
                    continue;
                }
                row = null;
            }
        }
        catch (IllegalAttributeException exc1) {
            throw new IOException(exc1.getMessage());
        }
        return list;
    }

    protected char readChar() throws IOException {
        return (char)this.inputStream.read();
    }

    private VPFColumn readColumn() throws VPFHeaderFormatException, IOException, NumberFormatException {
        char ctrl = this.readChar();
        if (ctrl == ';') {
            return null;
        }
        String name = ctrl + this.readString("=");
        char type = this.readChar();
        ctrl = this.readChar();
        if (ctrl != ',') {
            throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
        }
        String elemStr = this.readString(new String() + ',').trim();
        if (elemStr.equals("*")) {
            elemStr = "-1";
        }
        int elements = Integer.parseInt(elemStr);
        char key = this.readChar();
        ctrl = this.readChar();
        if (ctrl != ',') {
            throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
        }
        String colDesc = this.readString(new String() + ',' + ':');
        String descTableName = this.readString(new String() + ',' + ':');
        String indexFile = this.readString(new String() + ',' + ':');
        String narrTable = this.readString(new String() + ',' + ':');
        return new VPFColumn(name, type, elements, key, colDesc, descTableName, indexFile, narrTable);
    }

    protected Object readGeometry(int instancesCount, int dimensionality, boolean readDoubles) throws IOException {
        Object result = null;
        Coordinate coordinate = null;
        CoordinateList coordinates = new CoordinateList();
        GeometryFactory factory = new GeometryFactory();
        for (int inx = 0; inx < instancesCount; ++inx) {
            switch (dimensionality) {
                case 2: {
                    coordinate = new Coordinate(readDoubles ? this.readDouble() : (double)this.readFloat(), readDoubles ? this.readDouble() : (double)this.readFloat());
                    break;
                }
                case 3: {
                    coordinate = new Coordinate(readDoubles ? this.readDouble() : (double)this.readFloat(), readDoubles ? this.readDouble() : (double)this.readFloat(), readDoubles ? this.readDouble() : (double)this.readFloat());
                    break;
                }
            }
            coordinates.add(coordinate);
        }
        if (this.pathName.endsWith("txt") && coordinates.size() > 2) {
            Object o = coordinates.remove(1);
            coordinates.add(o);
        }
        result = instancesCount == 1 ? factory.createPoint(coordinate) : factory.createLineString(DefaultCoordinateSequenceFactory.instance().create(coordinates.toCoordinateArray()));
        return result;
    }

    protected double readDouble() throws IOException {
        return DataUtils.decodeDouble(this.readNumber(8));
    }

    public Feature readFeature() throws IOException, IllegalAttributeException {
        Feature result = null;
        boolean textPrimitive = this.pathName.endsWith("txt");
        int size = this.columns.size();
        if (textPrimitive) {
            ++size;
        }
        Object[] values = new Object[size];
        try {
            for (int inx = 0; inx < this.columns.size(); ++inx) {
                VPFColumn column = (VPFColumn)this.columns.get(inx);
                values[inx] = column.getElementsNumber() < 0 ? this.readVariableSizeData(column.getTypeChar()) : this.readFixedSizeData(column.getTypeChar(), column.getElementsNumber());
            }
            if (textPrimitive) {
                values[size - 1] = "nam";
            }
            result = this.featureType.create(values);
        }
        catch (EOFException exp) {
            exp.printStackTrace();
        }
        return result;
    }

    protected Object readFixedSizeData(char dataType, int instancesCount) throws IOException {
        Object result = null;
        switch (dataType) {
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': {
                byte[] dataBytes = new byte[instancesCount * DataUtils.getDataTypeSize(dataType)];
                this.inputStream.readFully(dataBytes);
                result = DataUtils.decodeData(dataBytes, dataType);
                break;
            }
            case 'F': {
                result = new Float(this.readFloat());
                break;
            }
            case 'R': {
                result = new Double(this.readDouble());
                break;
            }
            case 'S': {
                result = new Short(this.readShort());
                break;
            }
            case 'I': {
                result = new Integer(this.readInteger());
                break;
            }
            case 'X': {
                result = "NULL";
                break;
            }
            case 'K': {
                result = this.readTripletId();
                break;
            }
            case 'C': {
                result = this.readGeometry(instancesCount, 2, false);
                break;
            }
            case 'B': {
                result = this.readGeometry(instancesCount, 2, true);
                break;
            }
            case 'Z': {
                result = this.readGeometry(instancesCount, 3, false);
                break;
            }
            case 'Y': {
                result = this.readGeometry(instancesCount, 3, true);
                break;
            }
        }
        return result;
    }

    protected float readFloat() throws IOException {
        return DataUtils.decodeFloat(this.readNumber(4));
    }

    protected void readHeader() throws VPFHeaderFormatException, IOException {
        byte[] fourBytes = new byte[4];
        this.inputStream.readFully(fourBytes);
        char ctrl = this.byteOrder = this.readChar();
        if (this.byteOrder == ';') {
            this.byteOrder = (char)76;
        } else {
            ctrl = this.readChar();
        }
        if (this.byteOrder == 'L') {
            fourBytes = DataUtils.toBigEndian(fourBytes);
        }
        this.headerLength = DataUtils.decodeInt(fourBytes);
        if (ctrl != ';') {
            throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
        }
        this.description = this.readString(new String() + ';');
        this.narrativeTable = this.readString(new String() + ';');
        VPFColumn column = this.readColumn();
        while (column != null) {
            this.columns.add(column);
            ctrl = this.readChar();
            if (ctrl != ':') {
                throw new VPFHeaderFormatException("Header format does not fit VPF file definition.");
            }
            column = this.readColumn();
        }
        if (this.getRecordSize() < 0) {
            this.variableIndex = new VariableIndexInputStream(this.getVariableIndexFileName(), this.getByteOrder());
        }
    }

    protected int readInteger() throws IOException {
        return DataUtils.decodeInt(this.readNumber(4));
    }

    protected byte[] readNumber(int cnt) throws IOException {
        byte[] dataBytes = new byte[cnt];
        this.inputStream.readFully(dataBytes);
        if (this.byteOrder == 'L') {
            dataBytes = DataUtils.toBigEndian(dataBytes);
        }
        return dataBytes;
    }

    protected short readShort() throws IOException {
        return DataUtils.decodeShort(this.readNumber(2));
    }

    protected String readString(String terminators) throws IOException {
        StringBuffer text = new StringBuffer();
        char ctrl = this.readChar();
        if (terminators.indexOf(ctrl) != -1) {
            if (ctrl == ':') {
                this.unread(1L);
            }
            return null;
        }
        while (terminators.indexOf(ctrl) == -1) {
            text.append(ctrl);
            ctrl = this.readChar();
        }
        if (text.toString().equals("-")) {
            return null;
        }
        return text.toString();
    }

    protected TripletId readTripletId() throws IOException {
        byte tripletDef = (byte)this.inputStream.read();
        int dataSize = TripletId.calculateDataSize(tripletDef);
        byte[] tripletData = new byte[dataSize + 1];
        tripletData[0] = tripletDef;
        if (dataSize > 0) {
            this.inputStream.readFully(tripletData, 1, dataSize);
        }
        return new TripletId(tripletData);
    }

    protected Object readVariableSizeData(char dataType) throws IOException {
        int instances = this.readInteger();
        return this.readFixedSizeData(dataType, instances);
    }

    public void reset() {
        try {
            this.setPosition(1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        this.inputStream.close();
        if (this.variableIndex != null) {
            this.variableIndex.close();
        }
    }

    protected void setPosition(long pos) throws IOException {
        if (this.getRecordSize() < 0) {
            VariableIndexRow varRow = (VariableIndexRow)this.variableIndex.readRow((int)pos);
            this.inputStream.seek(varRow.getOffset());
        } else {
            this.inputStream.seek((long)this.getAdjustedHeaderLength() + (pos - 1L) * (long)this.getRecordSize());
        }
    }

    public String toString() {
        return this.featureType.toString();
    }

    protected void unread(long bytes) throws IOException {
        this.inputStream.seek(this.inputStream.getFilePointer() - bytes);
    }

    private String getVariableIndexFileName() {
        String result = null;
        String fileName = this.getFileName();
        result = fileName.toLowerCase().equals("fcs") ? this.getDirectoryName().concat(File.separator).concat("fcz") : this.getDirectoryName().concat(File.separator).concat(fileName.substring(0, fileName.length() - 1) + "x");
        return result;
    }

    public int find(String attName) {
        return this.featureType.find(attName);
    }
}

