/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFeatureReader;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;

public class VPFFileStore
extends AbstractDataStore {
    private Map files = new HashMap();

    public String[] getTypeNames() {
        String[] result = new String[this.files.size()];
        int counter = 0;
        Iterator iter = this.files.keySet().iterator();
        while (iter.hasNext()) {
            VPFFile currentFile = (VPFFile)iter.next();
            result[counter] = currentFile.getTypeName();
        }
        return result;
    }

    public FeatureType getSchema(String pathName) throws IOException {
        VPFFile result = null;
        if (this.files.containsKey(pathName)) {
            result = (FeatureType)this.files.get(pathName);
        } else {
            try {
                result = this.findFile(pathName);
            }
            catch (SchemaException exc) {
                throw new IOException("Schema error in path: " + pathName + "\n" + exc.getMessage());
            }
            this.files.put(pathName, result);
        }
        return result;
    }

    protected FeatureReader getFeatureReader(String pathName) throws IOException {
        return new VPFFileFeatureReader((VPFFile)this.getSchema(pathName));
    }

    public void reset() {
        Iterator iter = this.files.values().iterator();
        VPFFile file = null;
        while (iter.hasNext()) {
            try {
                file = (VPFFile)iter.next();
                file.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        this.files.clear();
    }

    private VPFFile findFile(String pathName) throws IOException, SchemaException {
        if (new File(pathName).exists()) {
            return new VPFFile(pathName);
        }
        ArrayList<String> matches = new ArrayList<String>();
        matches.add("");
        StringTokenizer st = new StringTokenizer(pathName, File.separator);
        while (st.hasMoreTokens() && !matches.isEmpty()) {
            String curr = st.nextToken();
            String currUpper = curr.toUpperCase();
            String currLower = curr.toLowerCase();
            boolean useUpper = !curr.equals(currUpper);
            boolean useLower = !curr.equals(currLower);
            ArrayList<String> newMatches = new ArrayList<String>();
            Iterator it = matches.iterator();
            while (it.hasNext()) {
                String match = (String)it.next();
                String tmp = match + File.separator + curr;
                if (new File(tmp).exists()) {
                    newMatches.add(tmp);
                    continue;
                }
                if (useUpper && new File(tmp = match + File.separator + currUpper).exists()) {
                    newMatches.add(tmp);
                }
                if (!useLower || !new File(tmp = match + File.separator + currLower).exists()) continue;
                newMatches.add(tmp);
            }
            matches = newMatches;
        }
        if (matches.isEmpty()) {
            throw new FileNotFoundException("Could not find file: " + pathName);
        }
        return new VPFFile((String)matches.get(0));
    }
}

