/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.readers;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.IllegalAttributeException;

public class EntityNodeGeometryFactory
extends VPFGeometryFactory
implements FileConstants {
    public void createGeometry(VPFFeatureType featureType, Feature values) throws SQLException, IOException, IllegalAttributeException {
        Geometry result = null;
        int nodeId = ((Number)values.getAttribute("end_id")).intValue();
        String baseDirectory = featureType.getFeatureClass().getDirectoryName();
        String tileDirectory = baseDirectory;
        if (!new File(tileDirectory.concat(File.separator).concat("end")).exists()) {
            Short tileId = new Short(Short.parseShort(values.getAttribute("tile_id").toString()));
            tileDirectory = tileDirectory.concat(File.separator).concat(featureType.getFeatureClass().getCoverage().getLibrary().getTileMap().get(tileId).toString()).trim();
        }
        String nodeTableName = tileDirectory.concat(File.separator).concat("end");
        VPFFile nodeFile = VPFFileFactory.getInstance().getFile(nodeTableName);
        Feature row = nodeFile.getRowFromId("id", nodeId);
        result = (Geometry)row.getAttribute("coordinate");
        values.setDefaultGeometry(result);
    }
}

