/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.gtopo30;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class GT30Header {
    public static final String BYTEORDER = "BYTEORDER";
    public static final String LAYOUT = "LAYOUT";
    public static final String NROWS = "NROWS";
    public static final String NCOLS = "NCOLS";
    public static final String NBANDS = "NBANDS";
    public static final String NBITS = "NBITS";
    public static final String BANDROWBYTES = "BANDROWBYTES";
    public static final String TOTALROWBYTES = "TOTALROWBYTES";
    public static final String BANDGAPBYTES = "BANDGAPBYTES";
    public static final String NODATA = "NODATA";
    public static final String ULXMAP = "ULXMAP";
    public static final String ULYMAP = "ULYMAP";
    public static final String XDIM = "XDIM";
    public static final String YDIM = "YDIM";
    private static final double STD_CELL_SIZE = 0.00833333333333;
    private Map propertyMap;

    public GT30Header(URL headerURL) throws IOException {
        String path = headerURL.getFile();
        File header = new File(URLDecoder.decode(path, "UTF-8"));
        BufferedReader reader = new BufferedReader(new FileReader(header));
        this.propertyMap = this.initMap();
        this.parseHeaderFile(this.propertyMap, reader);
        if (!this.fullPropertySet(this.propertyMap)) {
            throw new IOException("Needed properties missing in GTOPO30 header file");
        }
        reader.close();
    }

    public Object getProperty(String property) {
        return this.propertyMap.get(property);
    }

    public String getByteOrder() {
        return (String)this.propertyMap.get(BYTEORDER);
    }

    public String getLayout() {
        return (String)this.propertyMap.get(LAYOUT);
    }

    public int getNRows() {
        return (Integer)this.propertyMap.get(NROWS);
    }

    public int getNCols() {
        return (Integer)this.propertyMap.get(NCOLS);
    }

    public int getNBands() {
        return (Integer)this.propertyMap.get(NBANDS);
    }

    public int getNBits() {
        return (Integer)this.propertyMap.get(NBITS);
    }

    public int getBandRowBytes() {
        return (Integer)this.propertyMap.get(BANDROWBYTES);
    }

    public int getRowBytes() {
        return (Integer)this.propertyMap.get(TOTALROWBYTES);
    }

    public int getBandGapBytes() {
        return (Integer)this.propertyMap.get(BANDGAPBYTES);
    }

    public int getNoData() {
        return (Integer)this.propertyMap.get(NODATA);
    }

    public double getULXMap() {
        return (Double)this.propertyMap.get(ULXMAP);
    }

    public double getULYMap() {
        return (Double)this.propertyMap.get(ULYMAP);
    }

    public double getXDim() {
        return (Double)this.propertyMap.get(XDIM);
    }

    public double getYDim() {
        return (Double)this.propertyMap.get(YDIM);
    }

    private Map initMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(BYTEORDER, "M");
        map.put(LAYOUT, "BIL");
        map.put(NROWS, null);
        map.put(NCOLS, null);
        map.put(NBANDS, null);
        map.put(NBITS, null);
        map.put(BANDROWBYTES, null);
        map.put(TOTALROWBYTES, null);
        map.put(BANDGAPBYTES, new Integer(0));
        map.put(NODATA, new Integer(0));
        map.put(ULXMAP, null);
        map.put(ULYMAP, null);
        map.put(XDIM, new Double(0.00833333333333));
        map.put(YDIM, new Double(0.00833333333333));
        return map;
    }

    private void parseHeaderFile(Map properties, BufferedReader reader) throws IOException {
        String currLine = reader.readLine();
        String key = null;
        String value = null;
        Class propClass = null;
        while (currLine != null) {
            int firstSpaceIndex = (currLine = currLine.trim()).indexOf(32);
            if (firstSpaceIndex == -1) {
                throw new IOException("Illegal line in GTOPO30 header file");
            }
            key = currLine.substring(0, firstSpaceIndex).toUpperCase();
            value = currLine.substring(firstSpaceIndex).trim();
            if (properties.containsKey(key)) {
                propClass = this.getPropertyClass(key);
                try {
                    if (propClass == (class$java$lang$String == null ? GT30Header.class$("java.lang.String") : class$java$lang$String)) {
                        properties.put(key, value);
                    } else if (propClass == (class$java$lang$Integer == null ? GT30Header.class$("java.lang.Integer") : class$java$lang$Integer)) {
                        properties.put(key, Integer.valueOf(value));
                    } else if (propClass == (class$java$lang$Double == null ? GT30Header.class$("java.lang.Double") : class$java$lang$Double)) {
                        properties.put(key, Double.valueOf(value));
                    }
                }
                catch (NumberFormatException nfe) {
                    IOException ex = new IOException();
                    ex.initCause(nfe);
                    throw ex;
                }
            }
            currLine = reader.readLine();
        }
        reader.close();
    }

    private boolean fullPropertySet(Map properties) {
        boolean full = true;
        Collection values = properties.values();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            full = false;
            break;
        }
        return full;
    }

    private Class getPropertyClass(String key) {
        Class propClass = null;
        propClass = key.equals(BYTEORDER) || key.equals(LAYOUT) ? String.class : (key.equals(ULXMAP) || key.equals(ULYMAP) || key.equals(XDIM) || key.equals(YDIM) ? Double.class : Integer.class);
        return propClass;
    }
}

