/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.GeoKeyEntry;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.GeoTiffIIOMetadataDecoder;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.PixelScale;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.TiePoint;

public final class GeoTiffException
extends IOException {
    private static final long serialVersionUID = 1008533682021487024L;
    private GeoTiffIIOMetadataDecoder metadata = null;
    private GeoKeyEntry[] geoKeys = null;

    public GeoTiffException(GeoTiffIIOMetadataDecoder metadata, String msg, Throwable t) {
        super(msg);
        int numGeoKeys;
        this.metadata = metadata;
        if (t != null) {
            this.initCause(t);
        }
        if ((numGeoKeys = metadata.getNumGeoKeys()) > 0) {
            this.geoKeys = new GeoKeyEntry[numGeoKeys];
            for (int i = 0; i < numGeoKeys; ++i) {
                this.geoKeys[i] = metadata.getGeoKeyRecordByIndex(i);
            }
        }
    }

    public AffineTransform getModelTransformation() {
        if (this.metadata != null) {
            return this.metadata.getModelTransformation();
        }
        return null;
    }

    public GeoKeyEntry[] getGeoKeys() {
        return this.geoKeys;
    }

    public String getMessage() {
        Throwable t;
        int i;
        StringWriter text = new StringWriter(1024);
        PrintWriter message = new PrintWriter(text);
        message.println("GEOTIFF Module Error Report");
        message.println(super.getMessage());
        message.print("ModelPixelScaleTag: ");
        if (this.metadata != null) {
            PixelScale modelPixelScales = this.metadata.getModelPixelScales();
            if (modelPixelScales != null) {
                message.println("[" + modelPixelScales.getScaleX() + "," + modelPixelScales.getScaleY() + "," + modelPixelScales.getScaleZ() + "]");
            } else {
                message.println("NOT AVAILABLE");
            }
        } else {
            message.println("NOT AVAILABLE");
        }
        message.print("ModelTiePointTag: ");
        if (this.metadata != null) {
            TiePoint[] modelTiePoints = this.metadata.getModelTiePoints();
            if (modelTiePoints != null) {
                int numTiePoints = modelTiePoints.length;
                message.println("(" + numTiePoints + " tie points)");
                for (i = 0; i < numTiePoints; ++i) {
                    message.print("TP #" + i + ": ");
                    message.print("[" + modelTiePoints[i].getValueAt(0));
                    message.print("," + modelTiePoints[i].getValueAt(1));
                    message.print("," + modelTiePoints[i].getValueAt(2));
                    message.print("] -> [" + modelTiePoints[i].getValueAt(3));
                    message.print("," + modelTiePoints[i].getValueAt(4));
                    message.println("," + modelTiePoints[i].getValueAt(5) + "]");
                }
            } else {
                message.println("NOT AVAILABLE");
            }
        } else {
            message.println("NOT AVAILABLE");
        }
        message.print("ModelTransformationTag: ");
        AffineTransform modelTransformation = this.getModelTransformation();
        if (modelTransformation != null) {
            message.println("[");
            message.print(" [" + modelTransformation.getScaleX());
            message.print("," + modelTransformation.getShearX());
            message.print("," + modelTransformation.getScaleY());
            message.print("," + modelTransformation.getShearY());
            message.print("," + modelTransformation.getTranslateX());
            message.print("," + modelTransformation.getTranslateY() + "]");
            message.println("]");
        } else {
            message.println("NOT AVAILABLE");
        }
        if (this.geoKeys != null) {
            int numTags = this.geoKeys.length;
            for (i = 0; i < numTags; ++i) {
                message.print("GeoKey #" + (i + 1) + ": ");
                message.println("Key = " + this.geoKeys[i].getKeyID() + ", Value = " + this.metadata.getGeoKey(this.geoKeys[i].getKeyID()));
            }
        }
        if ((t = this.getCause()) != null) {
            t.printStackTrace(message);
        }
        message.close();
        return text.toString();
    }
}

