/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.geotools.data.DataSourceException;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.GeoTiffIIOMetadataDecoder;
import org.geotools.image.imageio.GeoToolsWriteParams;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class GeoTiffFormat
extends AbstractGridFormat
implements Format {
    private static final TIFFImageReaderSpi spi = new TIFFImageReaderSpi();
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gce.geotiff");

    public GeoTiffFormat() {
        this.writeParameters = null;
        this.mInfo = new HashMap();
        this.mInfo.put("name", "GeoTIFF");
        this.mInfo.put("description", "Tagged Image File Format with Geographic information");
        this.mInfo.put("vendor", "Geotools");
        this.mInfo.put("version", "1.1");
        this.mInfo.put("docURL", "http://www.remotesensing.org:16080/websites/geotiff/geotiff.html");
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{AbstractGridFormat.GEOTOOLS_WRITE_PARAMS}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(Object o) {
        if (o == null) {
            return false;
        }
        ImageReader reader = null;
        ImageInputStream inputStream = null;
        try {
            block19: {
                boolean bl;
                if (o instanceof URL) {
                    URL url = (URL)o;
                    if (url.getProtocol().equalsIgnoreCase("file")) {
                        o = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
                    } else {
                        if (!url.getProtocol().equalsIgnoreCase("http")) {
                            if (!url.getProtocol().equalsIgnoreCase("ftp")) return false;
                        }
                        o = ((URL)o).openStream();
                    }
                }
                if ((inputStream = (ImageInputStream)(o instanceof ImageInputStream ? o : ImageIO.createImageInputStream(o))) == null) {
                    if (!LOGGER.isLoggable(Level.FINE)) return false;
                    LOGGER.fine("Unable to get an ImageInputStream");
                    return false;
                }
                inputStream.mark();
                if (!spi.canDecodeInput((Object)inputStream)) {
                    return false;
                }
                reader = spi.createReaderInstance();
                reader.setInput(inputStream);
                IIOMetadata metadata = reader.getImageMetadata(0);
                try {
                    block20: {
                        try {
                            GeoTiffIIOMetadataDecoder metadataAdapter = new GeoTiffIIOMetadataDecoder(metadata);
                            if (metadataAdapter.getGeoKeyRevision() == 1) break block19;
                            bl = false;
                            Object var8_10 = null;
                            if (reader == null) break block20;
                        }
                        catch (UnsupportedOperationException e) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                            boolean bl2 = false;
                            Object var8_12 = null;
                            if (reader != null) {
                                reader.dispose();
                            }
                            if (inputStream == null) return bl2;
                            inputStream.close();
                            return bl2;
                        }
                        reader.dispose();
                    }
                    if (inputStream == null) return bl;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    if (reader != null) {
                        reader.dispose();
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return bl;
            }
            Object var8_11 = null;
            if (reader != null) {
                reader.dispose();
            }
            if (inputStream == null) return true;
            inputStream.close();
            return true;
        }
        catch (IOException e) {
            if (!LOGGER.isLoggable(Level.FINE)) return false;
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public GridCoverageReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageReader getReader(Object source, Hints hints) {
        if (source instanceof URL) {
            URL url = (URL)source;
            try {
                String pathname = URLDecoder.decode(url.getFile(), "UTF-8");
                return new GeoTiffReader(new File(pathname), hints);
            }
            catch (UnsupportedEncodingException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
            catch (DataSourceException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
        }
        try {
            return new GeoTiffReader(source, null);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        try {
            return new GeoTiffWriter(destination, hints);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination) {
        try {
            return new GeoTiffWriter(destination);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return new GeoTiffWriteParams();
    }
}

