/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataSourceException;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffException;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.GeoTiffIIOMetadataDecoder;
import org.geotools.gce.geotiff.crs_adapters.GeoTiffMetadata2CRSAdapter;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.CRSUtilities;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public final class GeoTiffReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private Logger LOGGER = Logger.getLogger(GeoTiffReader.class.toString());
    private static final TIFFImageReaderSpi readerSPI = new TIFFImageReaderSpi();
    private GeoTiffIIOMetadataDecoder metadata;
    private GeoTiffMetadata2CRSAdapter gtcs;

    public GeoTiffReader(Object input) throws DataSourceException {
        this(input, new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
    }

    public GeoTiffReader(Object input, Hints uHints) throws DataSourceException {
        this.hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        if (uHints != null) {
            uHints.remove((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
            this.hints.add((RenderingHints)uHints);
        }
        this.coverageName = "geotiff_coverage";
        if (input == null) {
            IOException ex = new IOException("GeoTiffReader:No source set to read this coverage.");
            throw new DataSourceException((Throwable)ex);
        }
        try {
            this.source = input;
            if (input instanceof URL) {
                URL sourceURL = (URL)input;
                if (sourceURL.getProtocol().equalsIgnoreCase("http") || sourceURL.getProtocol().equalsIgnoreCase("ftp")) {
                    try {
                        this.source = sourceURL.openStream();
                    }
                    catch (IOException e) {
                        new RuntimeException(e);
                    }
                } else if (sourceURL.getProtocol().equalsIgnoreCase("file")) {
                    this.source = new File(URLDecoder.decode(sourceURL.getFile(), "UTF-8"));
                }
            }
            this.closeMe = true;
            if (this.source instanceof InputStream || this.source instanceof ImageInputStream) {
                this.closeMe = false;
            }
            this.inStream = ImageIO.createImageInputStream(this.source);
            if (this.inStream == null) {
                throw new IllegalArgumentException("No input stream for the provided source");
            }
            this.getHRInfo(this.hints);
            this.coverageName = this.source instanceof File ? ((File)this.source).getName() : "geotiff_coverage";
            int dotIndex = this.coverageName.lastIndexOf(46);
            if (dotIndex != -1 && dotIndex != this.coverageName.length()) {
                this.coverageName = this.coverageName.substring(0, dotIndex);
            }
            if (this.closeMe) {
                this.inStream.close();
            }
        }
        catch (IOException e) {
            throw new DataSourceException((Throwable)e);
        }
        catch (TransformException e) {
            throw new DataSourceException((Throwable)e);
        }
        catch (FactoryException e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    private void getHRInfo(Hints hints) throws IOException, FactoryException, GeoTiffException, TransformException, MismatchedDimensionException, DataSourceException {
        ImageReader reader = readerSPI.createReaderInstance();
        reader.setInput(this.inStream);
        IIOMetadata iioMetadata = reader.getImageMetadata(0);
        this.metadata = new GeoTiffIIOMetadataDecoder(iioMetadata);
        this.gtcs = (GeoTiffMetadata2CRSAdapter)GeoTiffMetadata2CRSAdapter.get(hints);
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            this.LOGGER.log(Level.WARNING, "Using forced coordinate reference system " + this.crs.toWKT());
        } else {
            this.crs = this.gtcs.createCoordinateSystem(this.metadata);
        }
        this.numOverviews = reader.getNumImages(true) - 1;
        int hrWidth = reader.getWidth(0);
        int hrHeight = reader.getHeight(0);
        Rectangle actualDim = new Rectangle(0, 0, hrWidth, hrHeight);
        this.originalGridRange = new GeneralGridRange(actualDim);
        this.raster2Model = this.gtcs.getRasterToModel(this.metadata);
        AffineTransform tempTransform = new AffineTransform((AffineTransform)this.raster2Model);
        tempTransform.translate(-0.5, -0.5);
        this.originalEnvelope = CRSUtilities.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)actualDim));
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.highestRes = this.getResolution(this.originalEnvelope, actualDim, this.crs);
        if (this.numOverviews > 1) {
            this.overViewResolutions = new double[this.numOverviews][2];
            for (int i = 0; i < this.numOverviews; ++i) {
                double[] res = this.getResolution(this.originalEnvelope, new Rectangle(0, 0, reader.getWidth(i), reader.getHeight(i)), this.crs);
                this.overViewResolutions[i][0] = res[0];
                this.overViewResolutions[i][1] = res[1];
            }
        } else {
            this.overViewResolutions = null;
        }
    }

    public Format getFormat() {
        return new GeoTiffFormat();
    }

    public GridCoverage read(GeneralParameterValue[] params) throws IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        if (params != null && params != null) {
            for (int i = 0; i < params.length; ++i) {
                Parameter param = (Parameter)params[i];
                if (!param.getDescriptor().getName().getCode().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) continue;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                requestedEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                dim = gg.getGridRange2D().getBounds();
            }
        }
        Integer imageChoice = new Integer(0);
        ImageReadParam readP = new ImageReadParam();
        try {
            imageChoice = this.setReadParams(readP, requestedEnvelope, dim);
        }
        catch (TransformException e) {
            new DataSourceException((Throwable)e);
        }
        Hints newHints = (Hints)this.hints.clone();
        ParameterBlock pbjRead = new ParameterBlock();
        pbjRead.add(ImageIO.createImageInputStream(this.source));
        pbjRead.add(imageChoice);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(Boolean.FALSE);
        pbjRead.add(null);
        pbjRead.add(null);
        pbjRead.add(readP);
        pbjRead.add(readerSPI.createReaderInstance());
        if (imageChoice == 0) {
            AffineTransform tempRaster2Model = new AffineTransform((AffineTransform)this.raster2Model);
            tempRaster2Model.concatenate(new AffineTransform(readP.getSourceXSubsampling(), 0.0f, 0.0f, readP.getSourceYSubsampling(), 0.0f, 0.0f));
            return this.createImageCoverage((PlanarImage)JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)newHints), (MathTransform)ProjectiveTransform.create((AffineTransform)tempRaster2Model));
        }
        return this.createImageCoverage((PlanarImage)JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)newHints));
    }

    public GeoTiffIIOMetadataDecoder getMetadata() {
        return this.metadata;
    }
}

