/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.coverage.grid.AbstractGridCoverageWriter;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffException;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.GeoTiffIIOMetadataEncoder;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.utils.GeoTiffConstants;
import org.geotools.gce.geotiff.crs_adapters.CRS2GeoTiffMetadataAdapter;
import org.geotools.image.imageio.GeoToolsWriteParams;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridRange;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class GeoTiffWriter
extends AbstractGridCoverageWriter
implements GridCoverageWriter {
    private static final TIFFImageWriterSpi tiffWriterFactory = new TIFFImageWriterSpi();

    public GeoTiffWriter(Object destination) throws IOException {
        this(destination, null);
    }

    public GeoTiffWriter(Object destination, Hints hints) throws IOException {
        this.destination = destination;
        if (destination instanceof File) {
            this.outStream = ImageIO.createImageOutputStream(destination);
        } else if (destination instanceof URL) {
            URL dest = (URL)destination;
            if (dest.getProtocol().equalsIgnoreCase("file")) {
                File destFile = new File(URLDecoder.decode(dest.getFile(), "UTF-8"));
                this.outStream = ImageIO.createImageOutputStream(destFile);
            }
        } else if (destination instanceof OutputStream) {
            this.outStream = ImageIO.createImageOutputStream((OutputStream)destination);
        } else if (destination instanceof ImageOutputStream) {
            this.outStream = (ImageOutputStream)destination;
        } else {
            throw new IllegalArgumentException("The provided destination canno be used!");
        }
        if (hints != null) {
            if (this.hints == null) {
                this.hints = new Hints(null);
            }
            hints.add((RenderingHints)hints);
        }
    }

    public Format getFormat() {
        return new GeoTiffFormat();
    }

    public void write(GridCoverage gc, GeneralParameterValue[] params) throws IllegalArgumentException, IOException, IndexOutOfBoundsException {
        CoordinateReferenceSystem crs;
        GeoTiffWriteParams gtParams = null;
        if (params != null && params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                Parameter param = (Parameter)params[i];
                if (!param.getDescriptor().getName().getCode().equals(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString())) continue;
                gtParams = (GeoToolsWriteParams)param.getValue();
            }
        }
        if (gtParams == null) {
            gtParams = new GeoTiffWriteParams();
        }
        if (!((crs = gc.getCoordinateReferenceSystem()) instanceof ProjectedCRS) && !(crs instanceof GeographicCRS)) {
            throw new GeoTiffException(null, "The supplied grid coverage uses an unsupported crs! You are allowed to use only projected and geographic coordinate reference systems", null);
        }
        CRS2GeoTiffMetadataAdapter adapter = (CRS2GeoTiffMetadataAdapter)CRS2GeoTiffMetadataAdapter.get(crs);
        GeoTiffIIOMetadataEncoder metadata = adapter.parseCoordinateReferenceSystem();
        GridGeometry gg = gc.getGridGeometry();
        GridRange range = gg.getGridRange();
        AffineTransform tr = (AffineTransform)gg.getGridToCRS();
        this.setGeoReference(crs, metadata, tr, range);
        this.writeImage(((GridCoverage2D)gc).geophysics(true).getRenderedImage(), this.outStream, metadata, gtParams);
    }

    private void setGeoReference(CoordinateReferenceSystem crs, GeoTiffIIOMetadataEncoder metadata, AffineTransform rasterToModel, GridRange range) throws IndexOutOfBoundsException, IOException {
        AffineTransform modifiedRasterToModel;
        int minx = range.getLower(0);
        int miny = range.getLower(1);
        if (minx != 0 || miny != 0) {
            modifiedRasterToModel = new AffineTransform(rasterToModel);
            modifiedRasterToModel.concatenate(AffineTransform.getTranslateInstance(minx, miny));
        } else {
            modifiedRasterToModel = rasterToModel;
        }
        metadata.addGeoShortParam(1025, 2);
        boolean lonFirst = XAffineTransform.getSwapXY((AffineTransform)rasterToModel) != -1;
        double rotation = XAffineTransform.getRotation((AffineTransform)rasterToModel);
        if (!(Double.isInfinite(rotation) || Double.isNaN(rotation) || Math.abs(rotation) > 1.0E-6)) {
            double tiePointLongitude = lonFirst ? rasterToModel.getTranslateX() : rasterToModel.getTranslateY();
            double tiePointLatitude = lonFirst ? rasterToModel.getTranslateY() : rasterToModel.getTranslateX();
            metadata.setModelTiePoint(0.0, 0.0, 0.0, tiePointLongitude, tiePointLatitude, 0.0);
            double scaleModelToRasterLongitude = lonFirst ? Math.abs(rasterToModel.getScaleX()) : Math.abs(rasterToModel.getShearY());
            double scaleModelToRasterLatitude = lonFirst ? Math.abs(rasterToModel.getScaleY()) : Math.abs(rasterToModel.getShearX());
            metadata.setModelPixelScale(scaleModelToRasterLongitude, scaleModelToRasterLatitude, 0.0);
        } else {
            metadata.setModelTransformation(modifiedRasterToModel);
        }
    }

    private boolean writeImage(RenderedImage image, ImageOutputStream outputStream, GeoTiffIIOMetadataEncoder geoTIFFMetadata, GeoToolsWriteParams gtParams) throws IOException {
        if (image == null || outputStream == null) {
            throw new IllegalArgumentException("some parameters are null");
        }
        ImageWriteParam params = gtParams.getAdaptee();
        ImageWriter writer = tiffWriterFactory.createWriterInstance();
        IIOMetadata metadata = GeoTiffWriter.createGeoTiffIIOMetadata(writer, ImageTypeSpecifier.createFromRenderedImage(image), geoTIFFMetadata, params);
        writer.setOutput(outputStream);
        writer.write(writer.getDefaultStreamMetadata(params), new IIOImage(image, null, metadata), params);
        outputStream.flush();
        if (!(this.destination instanceof ImageOutputStream)) {
            outputStream.close();
        }
        writer.dispose();
        return true;
    }

    public static final IIOMetadata createGeoTiffIIOMetadata(ImageWriter writer, ImageTypeSpecifier type, GeoTiffIIOMetadataEncoder geoTIFFMetadata, ImageWriteParam params) throws IIOException {
        IIOMetadata imageMetadata = writer.getDefaultImageMetadata(type, params);
        imageMetadata = writer.convertImageMetadata(imageMetadata, type, params);
        Element w3cElement = (Element)imageMetadata.getAsTree(GeoTiffConstants.GEOTIFF_IIO_METADATA_FORMAT_NAME);
        org.jdom.Element element = new DOMBuilder().build(w3cElement);
        geoTIFFMetadata.assignTo(element);
        Parent parent = element.getParent();
        parent.removeContent((Content)element);
        Document document = new Document(element);
        try {
            org.w3c.dom.Document w3cDoc = new DOMOutputter().output(document);
            TIFFImageMetadata iioMetadata = new TIFFImageMetadata(TIFFImageMetadata.parseIFD((Node)w3cDoc.getDocumentElement().getFirstChild()));
            imageMetadata = iioMetadata;
        }
        catch (JDOMException e) {
            throw new IIOException("Failed to set GeoTIFFWritingUtilities specific tags.", e);
        }
        catch (IIOInvalidTreeException e) {
            throw new IIOException("Failed to set GeoTIFFWritingUtilities specific tags.", e);
        }
        return imageMetadata;
    }
}

