/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff.crs_adapters;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffException;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.GeoTiffIIOMetadataDecoder;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.PixelScale;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.TiePoint;
import org.geotools.gce.geotiff.IIOMetadataAdpaters.utils.GeoTiffConstants;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.epsg.DefaultFactory;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.LRULinkedHashMap;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;

public final class GeoTiffMetadata2CRSAdapter {
    private static final Logger LOGGER;
    private static final String PM_Greenwich = "8901";
    private static final AffineTransform PixelIsArea2PixelIsPoint;
    private final DatumFactory datumObjFactory;
    private final CRSFactory crsFactory;
    private Hints hints;
    private static final MathTransformFactory mtFactory;
    public static final int DEFAULT_MAX = 100;
    private static final Map pool;
    private final FactoryGroup factories;
    private final CSFactory csFactory;
    private final DefaultFactory factory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GeoTiffMetadata2CRSAdapter(Hints hints) {
        this.hints = hints;
        this.factory = new DefaultFactory(hints);
        this.datumObjFactory = FactoryFinder.getDatumFactory((Hints)hints);
        this.crsFactory = FactoryFinder.getCRSFactory((Hints)hints);
        this.csFactory = FactoryFinder.getCSFactory((Hints)hints);
        Hints tempHints = hints != null ? (Hints)hints.clone() : new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        tempHints.put((Object)Hints.DATUM_AUTHORITY_FACTORY, (Object)this.factory);
        tempHints.put((Object)Hints.CS_FACTORY, (Object)this.csFactory);
        tempHints.put((Object)Hints.CRS_FACTORY, (Object)this.crsFactory);
        tempHints.put((Object)Hints.MATH_TRANSFORM_FACTORY, (Object)mtFactory);
        this.factories = new FactoryGroup(tempHints);
    }

    public CoordinateReferenceSystem createCoordinateSystem(GeoTiffIIOMetadataDecoder metadata) throws IOException, FactoryException {
        switch (this.getGeoKeyAsInt(1024, metadata)) {
            case 1: {
                return this.createProjectedCoordinateSystem(metadata);
            }
            case 2: {
                return this.createGeographicCoordinateSystem(metadata);
            }
        }
        throw new UnsupportedOperationException("GeoTiffMetadata2CRSAdapter::createCoordinateSystem:Only Geographic & Projected Systems are supported.  ");
    }

    private ProjectedCRS createProjectedCoordinateSystem(GeoTiffIIOMetadataDecoder metadata) throws IOException, FactoryException {
        Unit linearUnit;
        String tempCode = metadata.getGeoKey(3072);
        if (tempCode == null) {
            tempCode = "unnamed".intern();
        }
        StringBuffer projCode = new StringBuffer(tempCode.trim().intern());
        try {
            linearUnit = this.createUnit(3076, 3077, SI.METER, SI.METER, metadata);
        }
        catch (GeoTiffException e) {
            linearUnit = null;
        }
        if (tempCode.equalsIgnoreCase("unnamed") || tempCode.equals(GeoTiffConstants.GTUserDefinedGeoKey_String)) {
            return this.createUserDefinedPCS(metadata, linearUnit);
        }
        try {
            if (!tempCode.startsWith("EPSG") && !tempCode.startsWith("epsg")) {
                projCode.insert(0, "EPSG:");
            }
            ProjectedCRS pcrs = (ProjectedCRS)CRS.decode((String)projCode.toString(), (boolean)true);
            if (linearUnit == null || linearUnit.equals(pcrs.getCoordinateSystem().getAxis(0).getUnit())) {
                return pcrs;
            }
            return new DefaultProjectedCRS(DefaultEllipsoidalCS.getName((IdentifiedObject)pcrs, (Citation)new CitationImpl((CharSequence)"EPSG")), pcrs.getConversionFromBase().getMethod(), (GeographicCRS)pcrs.getBaseCRS(), pcrs.getConversionFromBase().getMathTransform(), (CartesianCS)this.createProjectedCS(linearUnit));
        }
        catch (FactoryException fe) {
            GeoTiffException ex = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
            throw ex;
        }
    }

    private GeographicCRS createGeographicCoordinateSystem(GeoTiffIIOMetadataDecoder metadata) throws IOException {
        GeographicCRS gcs = null;
        String tempCode = metadata.getGeoKey(2048);
        Unit angularUnit = null;
        try {
            angularUnit = this.createUnit(2054, 2055, SI.RADIAN, NonSI.DEGREE_ANGLE, metadata);
        }
        catch (GeoTiffException e) {
            angularUnit = null;
        }
        Unit linearUnit = null;
        try {
            linearUnit = this.createUnit(2052, 2053, SI.METER, SI.METER, metadata);
        }
        catch (GeoTiffException e) {
            linearUnit = null;
        }
        if (tempCode == null || tempCode.equals(GeoTiffConstants.GTUserDefinedGeoKey_String)) {
            gcs = this.createUserDefinedGCS(metadata, linearUnit, angularUnit);
        } else {
            try {
                StringBuffer geogCode = new StringBuffer(tempCode);
                if (!tempCode.startsWith("EPSG") && !tempCode.startsWith("epsg")) {
                    geogCode.insert(0, "EPSG:");
                }
                gcs = (GeographicCRS)CRS.decode((String)geogCode.toString(), (boolean)true);
                if (angularUnit != null && !angularUnit.equals(gcs.getCoordinateSystem().getAxis(0).getUnit())) {
                    gcs = new DefaultGeographicCRS(DefaultEllipsoidalCS.getName((IdentifiedObject)gcs, (Citation)new CitationImpl((CharSequence)"EPSG")), (GeodeticDatum)gcs.getDatum(), (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D.usingUnit(angularUnit));
                }
            }
            catch (FactoryException fe) {
                GeoTiffException ex = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
                throw ex;
            }
        }
        return gcs;
    }

    private int getGeoKeyAsInt(int key, GeoTiffIIOMetadataDecoder metadata) {
        try {
            return Integer.parseInt(metadata.getGeoKey(key));
        }
        catch (NumberFormatException ne) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, ne.getLocalizedMessage(), ne);
            }
            return Integer.MIN_VALUE;
        }
    }

    public MathTransform getRasterToModel(GeoTiffIIOMetadataDecoder metadata) throws GeoTiffException {
        boolean hasTiePoints = metadata.hasTiePoints();
        boolean hasPixelScales = metadata.hasPixelScales();
        boolean hasModelTransformation = metadata.hasModelTrasformation();
        int rasterType = this.getGeoKeyAsInt(1025, metadata);
        if (rasterType == 0) {
            rasterType = 1;
        }
        LinearTransform xform = null;
        if (hasTiePoints && hasPixelScales) {
            TiePoint[] tiePoints = metadata.getModelTiePoints();
            PixelScale pixScales = metadata.getModelPixelScales();
            GeneralMatrix gm = new GeneralMatrix(3);
            double scaleRaster2ModelLongitude = pixScales.getScaleX();
            double scaleRaster2ModelLatitude = -pixScales.getScaleY();
            double tiePointColumn = tiePoints[0].getValueAt(0) + (rasterType == 1 ? -0.5 : 0.0);
            double tiePointRow = tiePoints[0].getValueAt(1) + (rasterType == 1 ? -0.5 : 0.0);
            gm.setElement(0, 0, scaleRaster2ModelLongitude);
            gm.setElement(1, 1, scaleRaster2ModelLatitude);
            gm.setElement(0, 1, 0.0);
            gm.setElement(1, 0, 0.0);
            gm.setElement(0, 2, tiePoints[0].getValueAt(3) - scaleRaster2ModelLongitude * tiePointColumn);
            gm.setElement(1, 2, tiePoints[0].getValueAt(4) - scaleRaster2ModelLatitude * tiePointRow);
            xform = ProjectiveTransform.create((Matrix)gm);
        } else if (hasModelTransformation) {
            if (rasterType == 1) {
                xform = ProjectiveTransform.create((AffineTransform)metadata.getModelTransformation());
            } else {
                if (!$assertionsDisabled && rasterType != 2) {
                    throw new AssertionError();
                }
                AffineTransform tempTransform = new AffineTransform(metadata.getModelTransformation());
                tempTransform.concatenate(PixelIsArea2PixelIsPoint);
                xform = ProjectiveTransform.create((AffineTransform)tempTransform);
            }
        } else {
            throw new GeoTiffException(metadata, "Unknown Raster to Model configuration.", null);
        }
        return xform;
    }

    private double getGeoKeyAsDouble(int key, GeoTiffIIOMetadataDecoder metadata) {
        try {
            return Double.parseDouble(metadata.getGeoKey(key));
        }
        catch (NumberFormatException ne) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, ne.getLocalizedMessage(), ne);
            }
            return Double.NaN;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return Double.NaN;
        }
    }

    private ProjectedCRS createUserDefinedPCS(GeoTiffIIOMetadataDecoder metadata, Unit linearUnit) throws IOException, FactoryException {
        ParameterValueGroup parameters;
        String projectedCrsName = metadata.getGeoKey(3073);
        projectedCrsName = projectedCrsName == null ? "unnamed".intern() : GeoTiffMetadata2CRSAdapter.cleanName(projectedCrsName);
        String projCode = metadata.getGeoKey(3074);
        boolean projUserDefined = false;
        if (projCode == null || projCode.equals(GeoTiffConstants.GTUserDefinedGeoKey_String)) {
            projUserDefined = true;
        }
        Conversion projection = null;
        if (projUserDefined) {
            String projectionName = metadata.getGeoKey(3073);
            if (projectionName == null) {
                projectionName = "unnamed";
            }
            if ((parameters = this.createUserDefinedProjectionParameter(projectionName, metadata)) == null) {
                throw new GeoTiffException(metadata, "GeoTiffMetadata2CRSAdapter::createUserDefinedPCS:Projection is not supported.", null);
            }
        } else {
            parameters = null;
            projection = (Conversion)this.factory.createCoordinateOperation("EPSG:" + projCode);
        }
        GeographicCRS gcs = this.createGeographicCoordinateSystem(metadata);
        if (projUserDefined) {
            GeodeticDatum tempDatum = (GeodeticDatum)gcs.getDatum();
            DefaultEllipsoid tempEll = (DefaultEllipsoid)tempDatum.getEllipsoid();
            double inverseFlattening = tempEll.getInverseFlattening();
            double semiMajorAxis = tempEll.getSemiMajorAxis();
            parameters.parameter("semi_minor").setValue(semiMajorAxis * (1.0 - 1.0 / inverseFlattening));
            parameters.parameter("semi_major").setValue(semiMajorAxis);
        }
        if (projUserDefined) {
            if (linearUnit != null && linearUnit.equals(SI.METER)) {
                return this.factories.createProjectedCRS(Collections.singletonMap("name", projectedCrsName), gcs, null, parameters, (CartesianCS)DefaultCartesianCS.PROJECTED);
            }
            return this.factories.createProjectedCRS(Collections.singletonMap("name", projectedCrsName), gcs, null, parameters, (CartesianCS)DefaultCartesianCS.PROJECTED.usingUnit(linearUnit));
        }
        if (linearUnit != null && !linearUnit.equals(SI.METER)) {
            return this.factories.createProjectedCRS(Collections.singletonMap("name", projectedCrsName), gcs, projection, (CartesianCS)DefaultCartesianCS.PROJECTED.usingUnit(linearUnit));
        }
        return this.factories.createProjectedCRS(Collections.singletonMap("name", projectedCrsName), gcs, projection, (CartesianCS)DefaultCartesianCS.PROJECTED);
    }

    private static final String cleanName(String tiffName) {
        int index = tiffName.lastIndexOf(36);
        if (index != -1) {
            tiffName = tiffName.substring(index + 1);
        }
        if ((index = tiffName.lastIndexOf(10)) != -1) {
            tiffName = tiffName.substring(index + 1);
        }
        if ((index = tiffName.lastIndexOf(13)) != -1) {
            tiffName = tiffName.substring(index + 1);
        }
        return tiffName;
    }

    private DefaultCartesianCS createProjectedCS(Unit linearUnit) {
        if (linearUnit == null) {
            throw new NullPointerException("Error when trying to create a PCS using this linear UoM ");
        }
        if (!linearUnit.isCompatible(SI.METER)) {
            throw new IllegalArgumentException("Error when trying to create a PCS using this linear UoM " + linearUnit.toString());
        }
        return new DefaultCartesianCS(Vocabulary.formatInternational((int)196).toString(), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Vocabulary.formatInternational((int)35), "E", AxisDirection.EAST, linearUnit), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Vocabulary.formatInternational((int)113), "N", AxisDirection.NORTH, linearUnit));
    }

    private PrimeMeridian createPrimeMeridian(GeoTiffIIOMetadataDecoder metadata, Unit linearUnit) throws IOException {
        PrimeMeridian pm;
        block7: {
            String pmCode = metadata.getGeoKey(2051);
            pm = null;
            try {
                if (pmCode != null) {
                    if (pmCode.equals(GeoTiffConstants.GTUserDefinedGeoKey_String)) {
                        try {
                            String name = metadata.getGeoKey(2049);
                            String pmValue = metadata.getGeoKey(2061);
                            double pmNumeric = Double.parseDouble(pmValue);
                            if (pmNumeric == 0.0) {
                                return DefaultPrimeMeridian.GREENWICH;
                            }
                            HashMap<String, String> props = new HashMap<String, String>();
                            props.put("name", name != null ? name : "User Defined GEOTIFF Prime Meridian");
                            pm = this.datumObjFactory.createPrimeMeridian(props, pmNumeric, linearUnit);
                            break block7;
                        }
                        catch (NumberFormatException nfe) {
                            GeoTiffException io = new GeoTiffException(metadata, "Invalid user-defined prime meridian spec.", nfe);
                            throw io;
                        }
                    }
                    pm = this.factory.createPrimeMeridian(pmCode);
                    break block7;
                }
                pm = this.factory.createPrimeMeridian(PM_Greenwich);
            }
            catch (FactoryException fe) {
                GeoTiffException io = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
                throw io;
            }
        }
        return pm;
    }

    private GeodeticDatum createGeodeticDatum(Unit unit, GeoTiffIIOMetadataDecoder metadata) throws IOException {
        GeodeticDatum datum = null;
        String datumCode = metadata.getGeoKey(2050);
        if (datumCode == null) {
            throw new GeoTiffException(metadata, "GeoTiffMetadata2CRSAdapter::createGeodeticDatum(Unit unit):A user defined Geographic Coordinate system must include a predefined datum!", null);
        }
        if (datumCode.equals(GeoTiffConstants.GTUserDefinedGeoKey_String)) {
            String datumName;
            String string = datumName = metadata.getGeoKey(2049) != null ? metadata.getGeoKey(2049) : "unnamed";
            if (datumName.trim().equalsIgnoreCase("WGS84")) {
                return DefaultGeodeticDatum.WGS84;
            }
            Ellipsoid ellipsoid = this.createEllipsoid(unit, metadata);
            PrimeMeridian primeMeridian = this.createPrimeMeridian(metadata, unit);
            datum = new DefaultGeodeticDatum(datumName, ellipsoid, primeMeridian);
        } else {
            try {
                datum = (GeodeticDatum)this.factory.createDatum(datumCode);
            }
            catch (FactoryException fe) {
                GeoTiffException ex = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
                throw ex;
            }
            catch (ClassCastException cce) {
                GeoTiffException ex = new GeoTiffException(metadata, cce.getLocalizedMessage(), cce);
                throw ex;
            }
        }
        return datum;
    }

    private Ellipsoid createEllipsoid(Unit unit, GeoTiffIIOMetadataDecoder metadata) throws GeoTiffException {
        String ellipsoidKey = metadata.getGeoKey(2056);
        String temp = null;
        if (ellipsoidKey.equalsIgnoreCase(GeoTiffConstants.GTUserDefinedGeoKey_String)) {
            double inverseFlattening;
            String nameEllipsoid = metadata.getGeoKey(2049);
            if (nameEllipsoid == null) {
                nameEllipsoid = "unnamed";
            }
            if (nameEllipsoid.trim().equalsIgnoreCase("WGS84")) {
                return DefaultEllipsoid.WGS84;
            }
            temp = metadata.getGeoKey(2057);
            double semiMajorAxis = temp != null ? Double.parseDouble(temp) : Double.NaN;
            temp = metadata.getGeoKey(2059);
            if (temp != null) {
                inverseFlattening = temp != null ? Double.parseDouble(temp) : Double.NaN;
            } else {
                temp = metadata.getGeoKey(2058);
                double semiMinorAxis = temp != null ? Double.parseDouble(temp) : Double.NaN;
                inverseFlattening = semiMajorAxis / (semiMajorAxis - semiMinorAxis);
            }
            return DefaultEllipsoid.createFlattenedSphere((String)nameEllipsoid, (double)semiMajorAxis, (double)inverseFlattening, (Unit)unit);
        }
        try {
            return this.factory.createEllipsoid("EPSG:" + ellipsoidKey);
        }
        catch (FactoryException fe) {
            GeoTiffException ex = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
            throw ex;
        }
    }

    private GeographicCRS createUserDefinedGCS(GeoTiffIIOMetadataDecoder metadata, Unit linearUnit, Unit angularUnit) throws IOException {
        String name = metadata.getGeoKey(2049);
        if (name == null) {
            name = "unnamed";
        }
        GeodeticDatum datum = this.createGeodeticDatum(linearUnit, metadata);
        GeographicCRS gcs = null;
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("name", name);
            gcs = this.crsFactory.createGeographicCRS(props, datum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D.usingUnit(angularUnit));
        }
        catch (FactoryException fe) {
            GeoTiffException io = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
            throw io;
        }
        return gcs;
    }

    private ParameterValueGroup createUserDefinedProjectionParameter(String name, GeoTiffIIOMetadataDecoder metadata) throws IOException, FactoryException {
        String coordTrans = metadata.getGeoKey(3075);
        if (coordTrans == null || coordTrans.equalsIgnoreCase(GeoTiffConstants.GTUserDefinedGeoKey_String)) {
            throw new GeoTiffException(metadata, "GeoTiffMetadata2CRSAdapter::createUserDefinedProjectionParameter(String name):User defined projections must specify coordinate transformation code in ProjCoordTransGeoKey", null);
        }
        return this.setParametersForProjection(name, coordTrans, metadata);
    }

    private ParameterValueGroup setParametersForProjection(String name, String coordTransCode, GeoTiffIIOMetadataDecoder metadata) throws GeoTiffException {
        ParameterValueGroup parameters = null;
        try {
            int code = 0;
            if (coordTransCode != null) {
                code = Integer.parseInt(coordTransCode);
            }
            if (name == null) {
                name = "unnamed";
            }
            if (name.equalsIgnoreCase("transverse_mercator") || code == 1) {
                parameters = mtFactory.getDefaultParameters("transverse_mercator");
                parameters.parameter("central_meridian").setValue(this.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(this.getOriginLat(metadata));
                parameters.parameter("scale_factor").setValue(this.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("Equidistant_Cylindrical") || name.equalsIgnoreCase("Plate_Carree") || name.equalsIgnoreCase("Equidistant_Cylindrical") || code == 17) {
                parameters = mtFactory.getDefaultParameters("Equidistant_Cylindrical");
                parameters.parameter("latitude_of_origin").setValue(this.getOriginLat(metadata));
                parameters.parameter("central_meridian").setValue(this.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("mercator_1SP") || name.equalsIgnoreCase("Mercator_2SP") || code == 7) {
                parameters = mtFactory.getDefaultParameters("Mercator_1SP");
                parameters.parameter("central_meridian").setValue(this.getOriginLong(metadata));
                parameters.parameter("scale_factor").setValue(this.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("lambert_conformal_conic_1SP") || code == 9) {
                parameters = mtFactory.getDefaultParameters("lambert_conformal_conic_1SP");
                parameters.parameter("central_meridian").setValue(this.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(this.getOriginLat(metadata));
                parameters.parameter("scale_factor").setValue(this.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("lambert_conformal_conic_2SP") || name.equalsIgnoreCase("lambert_conformal_conic_2SP_Belgium") || code == 8) {
                parameters = mtFactory.getDefaultParameters("lambert_conformal_conic_2SP");
                parameters.parameter("central_meridian").setValue(this.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(this.getOriginLat(metadata));
                parameters.parameter("standard_parallel_1").setValue(this.getGeoKeyAsDouble(3078, metadata));
                parameters.parameter("standard_parallel_2").setValue(this.getGeoKeyAsDouble(3079, metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("Krovak")) {
                parameters = mtFactory.getDefaultParameters("Krovak");
                parameters.parameter("longitude_of_center").setValue(this.getOriginLong(metadata));
                parameters.parameter("latitude_of_center").setValue(this.getOriginLat(metadata));
                parameters.parameter("azimuth").setValue(this.getGeoKeyAsDouble(3078, metadata));
                parameters.parameter("pseudo_standard_parallel_1").setValue(this.getGeoKeyAsDouble(3079, metadata));
                parameters.parameter("scale_factor").setValue(this.getFalseEasting(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("stereographic") || code == 14) {
                parameters = mtFactory.getDefaultParameters("stereographic");
                parameters.parameter("central_meridian").setValue(this.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(this.getOriginLat(metadata));
                parameters.parameter("scale_factor").setValue(this.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("polar_stereographic") || code == 15) {
                parameters = mtFactory.getDefaultParameters("polar_stereographic");
                parameters.parameter("latitude_of_origin").setValue(this.getOriginLat(metadata));
                parameters.parameter("scale_factor").setValue(this.getGeoKeyAsDouble(3092, metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                parameters.parameter("central_meridian").setValue(this.getOriginLong(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("oblique_mercator") || name.equalsIgnoreCase("hotine_oblique_mercator") || code == 3) {
                parameters = mtFactory.getDefaultParameters("oblique_mercator");
                parameters.parameter("scale_factor").setValue(this.getScaleFactor(metadata));
                parameters.parameter("azimuth").setValue(this.getGeoKeyAsDouble(3094, metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                parameters.parameter("longitude_of_center").setValue(this.getOriginLong(metadata));
                parameters.parameter("latitude_of_center").setValue(this.getOriginLat(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("albers_Conic_Equal_Area") || code == 11) {
                parameters = mtFactory.getDefaultParameters("Albers_Conic_Equal_Area");
                parameters.parameter("standard_parallel_1").setValue(this.getGeoKeyAsDouble(3078, metadata));
                parameters.parameter("standard_parallel_2").setValue(this.getGeoKeyAsDouble(3079, metadata));
                parameters.parameter("latitude_of_center").setValue(this.getOriginLat(metadata));
                parameters.parameter("longitude_of_center").setValue(this.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("Orthographic") || code == 21) {
                parameters = mtFactory.getDefaultParameters("orthographic");
                parameters.parameter("latitude_of_origin").setValue(this.getOriginLat(metadata));
                parameters.parameter("longitude_of_origin").setValue(this.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                return parameters;
            }
            if (name.equalsIgnoreCase("New_Zealand_Map_Grid") || code == 26) {
                parameters = mtFactory.getDefaultParameters("New_Zealand_Map_Grid");
                parameters.parameter("semi_major").setValue(this.getOriginLat(metadata));
                parameters.parameter("semi_minor").setValue(this.getOriginLong(metadata));
                parameters.parameter("latitude_of_origin").setValue(this.getOriginLat(metadata));
                parameters.parameter("central_meridian").setValue(this.getOriginLong(metadata));
                parameters.parameter("false_easting").setValue(this.getFalseEasting(metadata));
                parameters.parameter("false_northing").setValue(this.getFalseNorthing(metadata));
                return parameters;
            }
        }
        catch (NoSuchIdentifierException e) {
            throw new GeoTiffException(metadata, e.getLocalizedMessage(), e);
        }
        return parameters;
    }

    private double getScaleFactor(GeoTiffIIOMetadataDecoder metadata) {
        String scale = metadata.getGeoKey(3093);
        if (scale == null) {
            scale = metadata.getGeoKey(3092);
        }
        if (scale == null) {
            return 0.0;
        }
        return Double.parseDouble(scale);
    }

    private double getFalseEasting(GeoTiffIIOMetadataDecoder metadata) {
        String easting = metadata.getGeoKey(3082);
        if (easting == null) {
            easting = metadata.getGeoKey(3086);
        }
        if (easting == null) {
            return 0.0;
        }
        return Double.parseDouble(easting);
    }

    private double getFalseNorthing(GeoTiffIIOMetadataDecoder metadata) {
        String northing = metadata.getGeoKey(3083);
        if (northing == null) {
            northing = metadata.getGeoKey(3087);
        }
        if (northing == null) {
            return 0.0;
        }
        return Double.parseDouble(northing);
    }

    private double getOriginLong(GeoTiffIIOMetadataDecoder metadata) {
        String origin = metadata.getGeoKey(3088);
        if (origin == null) {
            origin = metadata.getGeoKey(3080);
        }
        if (origin == null) {
            origin = metadata.getGeoKey(3084);
        }
        if (origin == null) {
            origin = metadata.getGeoKey(3083);
        }
        if (origin == null) {
            return 0.0;
        }
        return Double.parseDouble(origin);
    }

    private double getOriginLat(GeoTiffIIOMetadataDecoder metadata) {
        String origin = metadata.getGeoKey(3089);
        if (origin == null) {
            origin = metadata.getGeoKey(3081);
        }
        if (origin == null) {
            origin = metadata.getGeoKey(3085);
        }
        if (origin == null) {
            return 0.0;
        }
        return Double.parseDouble(origin);
    }

    private Unit createUnit(int key, int userDefinedKey, Unit base, Unit def, GeoTiffIIOMetadataDecoder metadata) throws IOException {
        String unitCode = metadata.getGeoKey(key);
        if (unitCode == null) {
            return def;
        }
        if (unitCode.equals(GeoTiffConstants.GTUserDefinedGeoKey_String)) {
            try {
                String unitSize = metadata.getGeoKey(userDefinedKey);
                if (unitSize == null) {
                    throw new GeoTiffException(metadata, "GeoTiffMetadata2CRSAdapter::createUnit:Must define unit length when using a user " + "defined unit", null);
                }
                double sz = Double.parseDouble(unitSize);
                return base.multiply(sz);
            }
            catch (NumberFormatException nfe) {
                GeoTiffException ioe = new GeoTiffException(metadata, nfe.getLocalizedMessage(), nfe);
                throw ioe;
            }
        }
        try {
            return this.factory.createUnit(unitCode);
        }
        catch (FactoryException fe) {
            GeoTiffException io = new GeoTiffException(metadata, fe.getLocalizedMessage(), fe);
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object key) {
        Map map = pool;
        synchronized (map) {
            Object object = pool.get(key);
            if (object == null) {
                object = new GeoTiffMetadata2CRSAdapter((Hints)key);
                GeoTiffMetadata2CRSAdapter.put(key, object);
                return object;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(Object key, Object object) {
        Map map = pool;
        synchronized (map) {
            pool.put(key, object);
        }
    }

    public Hints getHints() {
        return this.hints;
    }

    static {
        $assertionsDisabled = !GeoTiffMetadata2CRSAdapter.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("org.geotools.gce.geotiff.crs_adapters");
        PixelIsArea2PixelIsPoint = AffineTransform.getTranslateInstance(0.5, 0.5);
        mtFactory = new DefaultMathTransformFactory();
        pool = Collections.synchronizedMap(new LRULinkedHashMap(50, 0.75f, true, 100));
    }
}

