/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.PrjFileReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.gce.imagepyramid.ImagePyramidReader;
import org.geotools.image.imageio.GeoToolsWriteParams;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImagePyramidFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gce.imagepyramid");
    public static final DefaultParameterDescriptor OUTPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("OutputTransparentColor", Color.class, null, null);
    public static final DefaultParameterDescriptor FADING = new DefaultParameterDescriptor("Fading", Boolean.class, null, (Object)Boolean.FALSE);
    public static final DefaultParameterDescriptor INPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("InputTransparentColor", Color.class, null, null);
    public static final DefaultParameterDescriptor INPUT_IMAGE_THRESHOLD_VALUE = new DefaultParameterDescriptor("InputImageThresholdValue", Double.class, null, (Object)new Double(Double.NaN));

    public ImagePyramidFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImagePyramid");
        info.put("description", "Image pyramidal plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, INPUT_IMAGE_THRESHOLD_VALUE, OUTPUT_TRANSPARENT_COLOR}));
        this.writeParameters = null;
    }

    public GridCoverageReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin is a read only plugin!");
    }

    public boolean accepts(Object source) {
        try {
            String[] pair;
            PrjFileReader crsReader;
            File sourceFile;
            if (source instanceof File) {
                sourceFile = (File)source;
            } else if (source instanceof URL) {
                URL sourceURL = (URL)source;
                if (sourceURL.getProtocol() != "file") {
                    return false;
                }
                String temp = URLDecoder.decode(sourceURL.getFile(), "UTF8");
                sourceFile = new File(temp);
            } else if (source instanceof String) {
                sourceFile = new File((String)source);
                if (!sourceFile.exists()) {
                    return false;
                }
            } else {
                return false;
            }
            String fileName = sourceFile.getAbsolutePath();
            int index = fileName.lastIndexOf(46);
            if (index != -1) {
                fileName = fileName.substring(0, index);
            }
            try {
                crsReader = new PrjFileReader((ReadableByteChannel)new RandomAccessFile(fileName + ".prj", "r").getChannel());
            }
            catch (FactoryException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                throw new DataSourceException((Throwable)e);
            }
            CoordinateReferenceSystem tempcrs = crsReader.getCoodinateSystem();
            if (tempcrs == null) {
                tempcrs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.FINE, "Unable to find a CRS for this coverage, using a default one: " + tempcrs.toWKT());
            }
            Properties properties = new Properties();
            try {
                properties.load(new BufferedInputStream(new FileInputStream(sourceFile)));
            }
            catch (Exception e) {
                return false;
            }
            String envelope = properties.getProperty("Envelope2D");
            if (envelope == null) {
                return false;
            }
            String[] pairs = envelope.split(" ");
            double[][] cornersV = new double[2][2];
            for (int i = 0; i < 2; ++i) {
                pair = pairs[i].split(",");
                cornersV[i][0] = Double.parseDouble(pair[0]);
                cornersV[i][1] = Double.parseDouble(pair[1]);
            }
            int numOverviews = Integer.parseInt(properties.getProperty("LevelsNum")) - 1;
            String levels = properties.getProperty("Levels");
            pairs = levels.split(" ");
            double[][] overViewResolutions = numOverviews > 1 ? new double[numOverviews][2] : (double[][])null;
            pair = pairs[0].split(",");
            double[] highestRes = new double[]{Double.parseDouble(pair[0]), Double.parseDouble(pair[1])};
            for (int i = 1; i < numOverviews + 1; ++i) {
                pair = pairs[i].split(",");
                overViewResolutions[i - 1][0] = Double.parseDouble(pair[0]);
                overViewResolutions[i - 1][1] = Double.parseDouble(pair[1]);
            }
            return properties.getProperty("Name") != null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return false;
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return false;
        }
    }

    public GridCoverageReader getReader(Object source, Hints hints) {
        try {
            return new ImagePyramidReader(source, hints);
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("impossible to get a reader for the provided source. The error is " + e.getLocalizedMessage());
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("impossible to get a reader for the provided source. The error is " + e.getLocalizedMessage());
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }
}

