/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataSourceException;
import org.geotools.data.PrjFileReader;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagepyramid.ImagePyramidFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.resources.CRSUtilities;
import org.geotools.util.SoftValueHashMap;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public final class ImagePyramidReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER;
    private File sourceFile;
    private String[] levelsDirs;
    private Map readers;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImagePyramidReader(Object source, Hints uHints) throws IOException {
        PrjFileReader crsReader;
        this.hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        if (uHints != null) {
            uHints.remove((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
            this.hints.add((RenderingHints)uHints);
        }
        if (source == null) {
            IOException ex = new IOException("ImagePyramidReader:No source set to read this coverage.");
            throw new DataSourceException((Throwable)ex);
        }
        this.source = source;
        if (source instanceof File) {
            this.sourceFile = (File)source;
        } else if (source instanceof URL) {
            URL tempURL = (URL)source;
            if (!tempURL.getProtocol().equalsIgnoreCase("file")) throw new IllegalArgumentException("This plugin accepts only File, URL and String pointing to a valid properties file");
            this.sourceFile = new File(URLDecoder.decode(tempURL.getFile(), "UTF-8"));
        } else {
            if (!(source instanceof String)) throw new IllegalArgumentException("This plugin accepts only File, URL and String pointing to a file");
            File tempFile = new File((String)source);
            if (!tempFile.exists()) throw new IllegalArgumentException("This plugin accepts only File, URL and String pointing to a file");
            this.sourceFile = tempFile;
        }
        String fileName = this.sourceFile.getAbsolutePath();
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            fileName = fileName.substring(0, index);
        }
        try {
            crsReader = new PrjFileReader((ReadableByteChannel)new RandomAccessFile(fileName + ".prj", "r").getChannel());
        }
        catch (FactoryException e) {
            throw new DataSourceException((Throwable)e);
        }
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            LOGGER.log(Level.WARNING, "Using forced coordinate reference system " + this.crs.toWKT());
        } else {
            CoordinateReferenceSystem tempcrs = crsReader.getCoodinateSystem();
            if (tempcrs == null) {
                this.crs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.WARNING, "Unable to find a CRS for this coverage, using a default one: " + this.crs.toWKT());
            } else {
                this.crs = tempcrs;
            }
        }
        if (!($assertionsDisabled || this.sourceFile.exists() && this.sourceFile.isFile())) {
            throw new AssertionError();
        }
        this.parseMainFile(this.sourceFile);
    }

    private void parseMainFile(File sourceFile) throws IOException, FileNotFoundException {
        String[] pair;
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(sourceFile)));
        String envelope = properties.getProperty("Envelope2D");
        String[] pairs = envelope.split(" ");
        double[][] cornersV = new double[2][2];
        for (int i = 0; i < 2; ++i) {
            pair = pairs[i].split(",");
            cornersV[i][0] = Double.parseDouble(pair[0]);
            cornersV[i][1] = Double.parseDouble(pair[1]);
        }
        this.originalEnvelope = new GeneralEnvelope(cornersV[0], cornersV[1]);
        this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        this.numOverviews = Integer.parseInt(properties.getProperty("LevelsNum")) - 1;
        this.levelsDirs = properties.getProperty("LevelsDirs").split(" ");
        int readersCacheSize = (this.numOverviews + 1) / 3;
        this.readers = Collections.synchronizedMap(new SoftValueHashMap(readersCacheSize == 0 ? this.numOverviews + 1 : readersCacheSize));
        String levels = properties.getProperty("Levels");
        pairs = levels.split(" ");
        this.overViewResolutions = this.numOverviews > 1 ? new double[this.numOverviews][2] : (double[][])null;
        pair = pairs[0].split(",");
        this.highestRes = new double[2];
        this.highestRes[0] = Double.parseDouble(pair[0]);
        this.highestRes[1] = Double.parseDouble(pair[1]);
        for (int i = 1; i < this.numOverviews + 1; ++i) {
            pair = pairs[i].split(",");
            this.overViewResolutions[i - 1][0] = Double.parseDouble(pair[0]);
            this.overViewResolutions[i - 1][1] = Double.parseDouble(pair[1]);
        }
        this.coverageName = properties.getProperty("Name");
        this.originalGridRange = new GeneralGridRange(new Rectangle((int)Math.round(this.originalEnvelope.getLength(0) / this.highestRes[0]), (int)Math.round(this.originalEnvelope.getLength(1) / this.highestRes[1])));
    }

    public ImagePyramidReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImagePyramidFormat();
    }

    public GridCoverage read(GeneralParameterValue[] params) throws IOException {
        Parameter param = null;
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        if (params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                param = (Parameter)params[i];
                if (!param.getDescriptor().getName().getCode().equals(ImagePyramidFormat.READ_GRIDGEOMETRY2D.getName().toString())) continue;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                requestedEnvelope = (GeneralEnvelope)gg.getEnvelope();
                dim = gg.getGridRange2D().getBounds();
            }
        }
        return this.loadTiles(requestedEnvelope, dim, params);
    }

    private GridCoverage loadTiles(GeneralEnvelope requestedEnvelope, Rectangle dim, GeneralParameterValue[] params) throws IOException {
        if (requestedEnvelope != null) {
            if (!CRS.equalsIgnoreMetadata((Object)requestedEnvelope.getCoordinateReferenceSystem(), (Object)this.crs)) {
                try {
                    requestedEnvelope = CRSUtilities.transform((MathTransform)operationFactory.createOperation(requestedEnvelope.getCoordinateReferenceSystem(), this.crs).getMathTransform(), (Envelope)requestedEnvelope);
                    requestedEnvelope.setCoordinateReferenceSystem(this.crs);
                }
                catch (TransformException e) {
                    throw new DataSourceException("Unable to create a coverage for this source", (Throwable)e);
                }
                catch (FactoryException e) {
                    throw new DataSourceException("Unable to create a coverage for this source", (Throwable)e);
                }
            }
            if (!requestedEnvelope.intersects((Envelope)this.originalEnvelope, true)) {
                return null;
            }
            requestedEnvelope.intersect((Envelope)this.originalEnvelope);
        } else {
            requestedEnvelope = new GeneralEnvelope((Envelope)this.originalEnvelope);
        }
        requestedEnvelope.setCoordinateReferenceSystem(this.crs);
        try {
            return this.loadRequestedTiles(requestedEnvelope, dim, params);
        }
        catch (DataSourceException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (TransformException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GridCoverage loadRequestedTiles(GeneralEnvelope requestedEnvelope, Rectangle dim, GeneralParameterValue[] params) throws TransformException, IOException {
        ImageReadParam readP = new ImageReadParam();
        Integer imageChoice = dim != null ? this.setReadParams(readP, requestedEnvelope, dim) : new Integer(0);
        ImageMosaicReader reader = null;
        Map map = this.readers;
        synchronized (map) {
            Object o = this.readers.get(imageChoice);
            if (o == null) {
                String levelDirName = this.levelsDirs[imageChoice];
                File parentDir = new File(this.sourceFile.getParentFile(), levelDirName);
                if (!parentDir.exists() || !parentDir.isDirectory()) throw new DataSourceException("Impossible to read the needed resolution level!");
                File shpFile = new File(parentDir, this.coverageName + ".shp");
                reader = new ImageMosaicReader((Object)shpFile.toURL());
                this.readers.put(imageChoice, reader);
            } else {
                reader = (ImageMosaicReader)o;
            }
            return reader.read(params);
        }
    }

    public void dispose() {
        super.dispose();
        this.readers.clear();
    }

    static {
        $assertionsDisabled = !ImagePyramidReader.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger(ImagePyramidReader.class.toString());
    }
}

