/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.pool.ArcSDEConnectionConfig;
import org.geotools.arcsde.pool.ArcSDEConnectionPool;
import org.geotools.arcsde.pool.ArcSDEConnectionPoolFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;

public class ArcSDEDataStoreFactory
implements DataStoreFactorySpi {
    protected static final Logger LOGGER = Logger.getLogger(ArcSDEDataStoreFactory.class.getPackage().getName());
    private static final String FACTORY_DESCRIPTION = "ESRI(tm) ArcSDE 8.x and 9.x";
    private static DataStoreFactorySpi.Param[] paramMetadata = new DataStoreFactorySpi.Param[10];
    private static final ArcSDEConnectionPoolFactory poolFactory;

    public DataStore createNewDataStore(Map map) {
        throw new UnsupportedOperationException("ArcSDE DataStore does not supports the creation of new databases. This should be done through database's specific tools");
    }

    public DataStore createDataStore(Map params) throws IOException {
        ArcSDEDataStore sdeDStore = null;
        ArcSDEConnectionConfig config = new ArcSDEConnectionConfig(params);
        ArcSDEConnectionPool connPool = poolFactory.createPool(config);
        sdeDStore = new ArcSDEDataStore(connPool, config.getNamespaceUri());
        return sdeDStore;
    }

    public String getDisplayName() {
        return "ArcSDE";
    }

    public String getDescription() {
        return FACTORY_DESCRIPTION;
    }

    public boolean canProcess(Map params) {
        LOGGER.info("Checking whether " + this.getClass() + " can process this map");
        boolean canProcess = true;
        try {
            new ArcSDEConnectionConfig(params);
        }
        catch (NullPointerException ex) {
            canProcess = false;
        }
        catch (IllegalArgumentException ex) {
            canProcess = false;
        }
        return canProcess;
    }

    public boolean isAvailable() {
        try {
            LOGGER.finer(SeConnection.class.getName() + " is in place.");
            LOGGER.finer(PeCoordinateSystem.class.getName() + " is in place.");
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "ArcSDE Java API seems to not be on your classpath. Please verify that all needed jars are. ArcSDE data stores will not be available.", t);
            return false;
        }
        return true;
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return paramMetadata;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    static {
        ArcSDEDataStoreFactory.paramMetadata[0] = new DataStoreFactorySpi.Param("namespace", String.class, "namespace associated to this data store", false);
        ArcSDEDataStoreFactory.paramMetadata[1] = new DataStoreFactorySpi.Param("dbtype", String.class, "fixed value. Must be \"arcsde\"", true, (Object)"arcsde");
        ArcSDEDataStoreFactory.paramMetadata[2] = new DataStoreFactorySpi.Param("server", String.class, "sever name where the ArcSDE gateway is running", true);
        ArcSDEDataStoreFactory.paramMetadata[3] = new DataStoreFactorySpi.Param("port", Integer.class, "port number in wich the ArcSDE server is listening for connections.Generally it's 5151", true, (Object)new Integer(5151));
        ArcSDEDataStoreFactory.paramMetadata[4] = new DataStoreFactorySpi.Param("instance", String.class, "the specific database to connect to. Only applicable to certain databases. Value ignored if not applicable.", false);
        ArcSDEDataStoreFactory.paramMetadata[5] = new DataStoreFactorySpi.Param("user", String.class, "name of a valid database user account.", true);
        ArcSDEDataStoreFactory.paramMetadata[6] = new DataStoreFactorySpi.Param("password", String.class, "the database user's password.", true);
        ArcSDEDataStoreFactory.paramMetadata[7] = new DataStoreFactorySpi.Param("pool.minConnections", Integer.class, "Minimun number of open connections", false, (Object)new Integer(2));
        ArcSDEDataStoreFactory.paramMetadata[8] = new DataStoreFactorySpi.Param("pool.maxConnections", Integer.class, "Maximun number of open connections (will not work if < 2)", false, (Object)new Integer(2));
        ArcSDEDataStoreFactory.paramMetadata[9] = new DataStoreFactorySpi.Param("pool.timeOut", Integer.class, "Milliseconds to wait for an available connection before failing to connect", false, (Object)new Integer(1000));
        poolFactory = ArcSDEConnectionPoolFactory.getInstance();
    }
}

