/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.gce.ArcSDERasterFormat;
import org.geotools.data.coverage.grid.GridFormatFactorySpi;
import org.opengis.coverage.grid.Format;

public class ArcSDERasterFormatFactory
implements GridFormatFactorySpi {
    protected static final Logger LOGGER = Logger.getLogger(ArcSDERasterFormatFactory.class.getPackage().getName());
    private static final String FACTORY_DESCRIPTION = "ESRI(tm) ArcSDE 9.x Raster Support via GridCoverageExchange Interface";

    public boolean isAvailable() {
        LOGGER.fine("Checking availability of ArcSDE Jars.");
        try {
            LOGGER.fine(SeConnection.class.getName() + " is in place.");
            LOGGER.fine(PeCoordinateSystem.class.getName() + " is in place.");
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "ArcSDE Java API seems to not be on your classpath. Please verify that all needed jars are. ArcSDE data stores will not be available.", t);
            return false;
        }
        return true;
    }

    public Format createFormat() {
        return new ArcSDERasterFormat();
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

