/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeInstance;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRelease;
import com.esri.sde.sdk.client.SeTable;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEAttributeType;
import org.geotools.arcsde.data.GeometryBuilder;
import org.geotools.arcsde.pool.ArcSDEConnectionConfig;
import org.geotools.arcsde.pool.ArcSDEConnectionPool;
import org.geotools.arcsde.pool.ArcSDEPooledConnection;
import org.geotools.arcsde.pool.UnavailableArcSDEConnectionException;
import org.geotools.data.DataSourceException;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.filter.Filter;
import org.geotools.referencing.FactoryFinder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ArcSDEAdapter {
    private static final Logger LOGGER = Logger.getLogger(ArcSDEAdapter.class.getPackage().getName());
    private static final Map sde2JavaTypes = new HashMap();
    private static final Map java2SDETypes = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int guessShapeTypes(GeometryAttributeType attribute) {
        if (attribute == null) {
            throw new NullPointerException("a GeometryAttributeType must be provided, got null");
        }
        Class geometryClass = attribute.getType();
        int shapeTypes = 0;
        if (attribute.isNillable()) {
            shapeTypes |= SeLayer.SE_NIL_TYPE_MASK;
        }
        if (GeometryCollection.class.isAssignableFrom(geometryClass)) {
            shapeTypes |= SeLayer.SE_MULTIPART_TYPE_MASK;
            if (geometryClass == MultiPoint.class) {
                shapeTypes |= SeLayer.SE_POINT_TYPE_MASK;
                return shapeTypes;
            } else if (geometryClass == MultiLineString.class) {
                shapeTypes |= SeLayer.SE_LINE_TYPE_MASK;
                return shapeTypes;
            } else {
                if (geometryClass != MultiPolygon.class) throw new IllegalArgumentException("no SDE geometry mapping for " + geometryClass);
                shapeTypes |= SeLayer.SE_AREA_TYPE_MASK;
            }
            return shapeTypes;
        } else if (geometryClass == Point.class) {
            shapeTypes |= SeLayer.SE_POINT_TYPE_MASK;
            return shapeTypes;
        } else if (geometryClass == LineString.class) {
            shapeTypes |= SeLayer.SE_LINE_TYPE_MASK;
            return shapeTypes;
        } else if (geometryClass == Polygon.class) {
            shapeTypes |= SeLayer.SE_AREA_TYPE_MASK;
            return shapeTypes;
        } else {
            if (geometryClass != Geometry.class) throw new IllegalArgumentException("no SDE geometry mapping for " + geometryClass);
            LOGGER.info("Creating SeShape types for all types of geometries.");
            shapeTypes |= SeLayer.SE_MULTIPART_TYPE_MASK | SeLayer.SE_POINT_TYPE_MASK | SeLayer.SE_LINE_TYPE_MASK | SeLayer.SE_AREA_TYPE_MASK;
        }
        return shapeTypes;
    }

    public static SeColumnDefinition createSeColumnDefinition(AttributeType type) throws SeException {
        SeColumnDefinition colDef = null;
        String colName = type.getName();
        boolean nillable = type.isNillable();
        SdeTypeDef def = ArcSDEAdapter.getSdeType(type.getType());
        int sdeColType = def.colDefType;
        int fieldLength = def.size;
        int fieldScale = def.scale;
        colDef = new SeColumnDefinition(colName, sdeColType, fieldLength, fieldScale, nillable);
        return colDef;
    }

    private static SdeTypeDef getSdeType(Class attClass) throws IllegalArgumentException {
        SdeTypeDef sdeType = (SdeTypeDef)java2SDETypes.get(attClass);
        if (sdeType == null) {
            throw new IllegalArgumentException("No SDE type mapping for " + attClass.getName());
        }
        return sdeType;
    }

    public static FeatureType fetchSchema(ArcSDEConnectionPool connPool, String typeName, URI namespace) throws IOException {
        SeLayer sdeLayer = connPool.getSdeLayer(typeName);
        SeTable sdeTable = connPool.getSdeTable(typeName);
        int majorVersion = 8;
        try {
            majorVersion = ArcSDEAdapter.getMajorVersion(connPool);
        }
        catch (SeException e) {
            throw new DataSourceException(e.getMessage(), (Throwable)e);
        }
        AttributeType[] types = ArcSDEAdapter.createAttributeTypes(connPool, sdeLayer, sdeTable, majorVersion);
        FeatureType type = null;
        try {
            type = types[types.length - 1] instanceof GeometryAttributeType ? FeatureTypeFactory.newFeatureType((AttributeType[])types, (String)sdeLayer.getQualifiedName(), (URI)namespace, (boolean)false, null, (AttributeType)types[types.length - 1]) : FeatureTypeFactory.newFeatureType((AttributeType[])types, (String)sdeLayer.getQualifiedName(), (URI)namespace);
        }
        catch (SeException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
        catch (SchemaException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
        catch (FactoryConfigurationError ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
        return type;
    }

    private static int getMajorVersion(ArcSDEConnectionPool connPool) throws SeException {
        ArcSDEConnectionConfig config = connPool.getConfig();
        SeInstance instanceInfo = new SeInstance(config.getServerName(), config.getPortNumber().intValue());
        SeInstance.SeInstanceStatus status = instanceInfo.getStatus();
        SeRelease sdeRelease = status.getSeRelease();
        return sdeRelease.getMajor();
    }

    private static AttributeType[] createAttributeTypes(ArcSDEConnectionPool connPool, SeLayer sdeLayer, SeTable table, int majorVersion) throws DataSourceException {
        SeColumnDefinition[] seColumns = null;
        String rowIdColumnName = null;
        String shapeFIDColumnname = null;
        ArcSDEPooledConnection conn = null;
        try {
            seColumns = table.describe();
            conn = connPool.getConnection();
            SeRegistration reg = new SeRegistration((SeConnection)conn, table.getQualifiedName());
            rowIdColumnName = reg.getRowIdColumnName();
            if (rowIdColumnName != null && !rowIdColumnName.trim().equals("")) {
                LOGGER.warning("Figured Row-ID Column named '" + rowIdColumnName + "' for table " + table.getQualifiedName());
            } else {
                shapeFIDColumnname = sdeLayer.getShapeAttributeName(SeLayer.SE_SHAPE_ATTRIBUTE_FID);
                LOGGER.warning("No Row-ID Column registered on table '" + table.getQualifiedName() + "', using SE_SHAPE_ATTRIBUTE_FID value '" + shapeFIDColumnname + "'");
            }
        }
        catch (SeException ex) {
            LOGGER.log(Level.WARNING, ex.getSeError().getErrDesc(), ex);
            if (LOGGER.isLoggable(Level.FINE)) {
                ex.printStackTrace();
            }
            throw new DataSourceException("Error obtaining table schema from " + table.getQualifiedName());
        }
        catch (UnavailableArcSDEConnectionException uce) {
            LOGGER.log(Level.SEVERE, "Unable to get connection while attempting to determine SDE RowID Column for table " + table.getName());
            throw new DataSourceException("Error obtaining table schema from " + table.getQualifiedName());
        }
        finally {
            conn.close();
        }
        int nCols = seColumns.length;
        AttributeType[] attTypes = shapeFIDColumnname == null ? new AttributeType[nCols] : new AttributeType[nCols + 1];
        ArcSDEAttributeType attribute = null;
        Class typeClass = null;
        for (int i = 0; i < nCols; ++i) {
            boolean isNilable = true;
            Geometry defValue = null;
            Integer sdeType = new Integer(seColumns[i].getType());
            int fieldLen = seColumns[i].getSize();
            if (sdeType == SeColumnDefinition.TYPE_SHAPE) {
                CoordinateReferenceSystem crs = null;
                crs = ArcSDEAdapter.parseCRS(sdeLayer);
                int seShapeType = sdeLayer.getShapeTypes();
                if (majorVersion >= 9) {
                    typeClass = ArcSDEAdapter.getGeometryType9(seShapeType);
                    LOGGER.fine("Using arcsde 9 methods");
                } else {
                    typeClass = ArcSDEAdapter.getGeometryType(seShapeType);
                }
                isNilable = (seShapeType & SeLayer.SE_NIL_TYPE_MASK) == SeLayer.SE_NIL_TYPE_MASK;
                defValue = GeometryBuilder.defaultValueFor(typeClass);
                attribute = new GeometricAttributeType(seColumns[i].getName(), typeClass, isNilable, 1, 1, (Object)defValue, crs, Filter.NONE);
            } else {
                if (sdeType == SeColumnDefinition.TYPE_RASTER) {
                    throw new DataSourceException("Raster columns are not supported yet");
                }
                typeClass = (Class)sde2JavaTypes.get(sdeType);
                if (typeClass == null) {
                    throw new DataSourceException("Column " + seColumns[i].getName() + " in layer " + sdeLayer.getName() + " has unknown column type " + seColumns[i].getType() + ".  Please report this to the GeoTools ArcSDE developer team so that we can add support for this column type.");
                }
                attribute = new ArcSDEAttributeType(AttributeTypeFactory.newAttributeType((String)seColumns[i].getName(), (Class)typeClass, (boolean)isNilable, (int)fieldLen, defValue));
                if (attribute.getName().equalsIgnoreCase(rowIdColumnName)) {
                    attribute.setFeatureIDAttribute(true);
                } else {
                    attribute.setFeatureIDAttribute(false);
                }
            }
            attTypes[i] = attribute;
        }
        if (shapeFIDColumnname != null) {
            ArcSDEAttributeType shapeFIDAttributeType = new ArcSDEAttributeType(AttributeTypeFactory.newAttributeType((String)shapeFIDColumnname, (Class)Integer.class, (boolean)true, (int)10, null));
            shapeFIDAttributeType.setFeatureIDAttribute(true);
            attTypes[nCols] = shapeFIDAttributeType;
        }
        return attTypes;
    }

    private static CoordinateReferenceSystem parseCRS(SeLayer sdeLayer) throws DataSourceException {
        CoordinateReferenceSystem crs = null;
        SeCoordinateReference seCRS = sdeLayer.getCoordRef();
        String WKT = seCRS.getProjectionDescription();
        LOGGER.info("About to parse CRS for layer " + sdeLayer.getName() + ": " + WKT);
        try {
            LOGGER.info("Se CRS envelope: " + seCRS.getXYEnvelope());
        }
        catch (SeException e1) {
            // empty catch block
        }
        if ("UNKNOWN".equalsIgnoreCase(WKT)) {
            LOGGER.warning("ArcSDE layer " + sdeLayer.getName() + " does not provides a Coordinate Reference System");
        } else {
            try {
                CRSFactory crsFactory = FactoryFinder.getCRSFactory(null);
                crs = crsFactory.createFromWKT(WKT);
                LOGGER.fine("ArcSDE CRS correctly parsed from layer " + sdeLayer.getName());
            }
            catch (FactoryException e) {
                String msg = "CRS factory does not knows how to parse the CRS for layer " + sdeLayer.getName() + ": " + WKT;
                LOGGER.log(Level.CONFIG, msg, e);
            }
        }
        return crs;
    }

    public static String getRowIdColumn(FeatureType schema) {
        String rowIdColumnName = null;
        AttributeType[] attTypes = schema.getAttributeTypes();
        for (int i = 0; i < attTypes.length; ++i) {
            if (!(attTypes[i] instanceof ArcSDEAttributeType) || !((ArcSDEAttributeType)attTypes[i]).isFeatureIDAttribute()) continue;
            rowIdColumnName = attTypes[i].getName();
            return rowIdColumnName;
        }
        return rowIdColumnName;
    }

    public static Class getGeometryType(int seShapeType) {
        Class clazz = Geometry.class;
        int MULTIPART_MASK = SeLayer.SE_MULTIPART_TYPE_MASK;
        int POINT_MASK = SeLayer.SE_POINT_TYPE_MASK;
        int SIMPLE_LINE_MASK = SeLayer.SE_SIMPLE_LINE_TYPE_MASK;
        int LINESTRING_MASK = SeLayer.SE_LINE_TYPE_MASK;
        int AREA_MASK = SeLayer.SE_AREA_TYPE_MASK;
        if (seShapeType != SeLayer.TYPE_NIL) {
            if (seShapeType == SeLayer.TYPE_MULTI_MASK) {
                clazz = GeometryCollection.class;
            } else if (seShapeType == SeLayer.TYPE_LINE || seShapeType == SeLayer.TYPE_SIMPLE_LINE) {
                clazz = LineString.class;
            } else if (seShapeType == SeLayer.TYPE_MULTI_LINE || seShapeType == SeLayer.TYPE_MULTI_SIMPLE_LINE) {
                clazz = MultiLineString.class;
            } else if (seShapeType == SeLayer.TYPE_MULTI_POINT) {
                clazz = MultiPoint.class;
            } else if (seShapeType == SeLayer.TYPE_MULTI_POLYGON) {
                clazz = MultiPolygon.class;
            } else if (seShapeType == SeLayer.TYPE_POINT) {
                clazz = Point.class;
            } else if (seShapeType == SeLayer.TYPE_POLYGON) {
                clazz = Polygon.class;
            } else {
                int isCollection = (seShapeType & MULTIPART_MASK) == MULTIPART_MASK ? 1 : 0;
                int isPoint = (seShapeType & POINT_MASK) == POINT_MASK ? 1 : 0;
                int isLineString = (seShapeType & SIMPLE_LINE_MASK) == SIMPLE_LINE_MASK || (seShapeType & LINESTRING_MASK) == LINESTRING_MASK ? 1 : 0;
                int isPolygon = (seShapeType & AREA_MASK) == AREA_MASK ? 1 : 0;
                boolean isError = false;
                if (isPoint + isLineString + isPolygon > 1) {
                    Class clazz2 = clazz = Geometry.class;
                    if (4 < isCollection + isPoint + isLineString + isPolygon) {
                        LOGGER.warning("Be careful!! we're mapping an ArcSDE Shape type to the generic Geometry class, but the shape type does not really allows all geometry types!: isCollection=" + isCollection + ", isPoint=" + isPoint + ", isLineString=" + isLineString + ", isPolygon=" + isPolygon);
                    } else {
                        LOGGER.info("safely mapping SeShapeType to abstract Geometry");
                    }
                } else if (isCollection == 1) {
                    if (isPoint == 1) {
                        clazz = MultiPoint.class;
                    } else if (isLineString == 1) {
                        clazz = MultiLineString.class;
                    } else if (isPolygon == 1) {
                        clazz = MultiPolygon.class;
                    } else {
                        isError = true;
                    }
                } else if (isPoint == 1) {
                    clazz = Point.class;
                } else if (isLineString == 1) {
                    clazz = LineString.class;
                } else if (isPolygon == 1) {
                    clazz = Polygon.class;
                } else {
                    isError = true;
                }
                if (isError) {
                    throw new IllegalArgumentException("Cannot map the shape type to a Geometry class: isCollection=" + isCollection + ", isPoint=" + isPoint + ", isLineString=" + isLineString + ", isPolygon=" + isPolygon);
                }
            }
        }
        return clazz;
    }

    public static Class getGeometryType9(int seShapeType) {
        Class clazz = Geometry.class;
        int MULTIPART_MASK = SeLayer.SE_MULTIPART_TYPE_MASK;
        int POINT_MASK = SeLayer.SE_POINT_TYPE_MASK;
        int SIMPLE_LINE_MASK = SeLayer.SE_SIMPLE_LINE_TYPE_MASK;
        int LINESTRING_MASK = SeLayer.SE_LINE_TYPE_MASK;
        int AREA_MASK = SeLayer.SE_AREA_TYPE_MASK;
        if (seShapeType != SeLayer.TYPE_NIL) {
            int isCollection = (seShapeType & MULTIPART_MASK) == MULTIPART_MASK ? 1 : 0;
            int isPoint = (seShapeType & POINT_MASK) == POINT_MASK ? 1 : 0;
            int isLineString = (seShapeType & SIMPLE_LINE_MASK) == SIMPLE_LINE_MASK || (seShapeType & LINESTRING_MASK) == LINESTRING_MASK ? 1 : 0;
            int isPolygon = (seShapeType & AREA_MASK) == AREA_MASK ? 1 : 0;
            boolean isError = false;
            if (isPoint + isLineString + isPolygon > 1) {
                Class clazz2 = clazz = Geometry.class;
                if (4 < isCollection + isPoint + isLineString + isPolygon) {
                    LOGGER.warning("Be careful!! we're mapping an ArcSDE Shape type to the generic Geometry class, but the shape type does not really allows all geometry types!: isCollection=" + isCollection + ", isPoint=" + isPoint + ", isLineString=" + isLineString + ", isPolygon=" + isPolygon);
                } else {
                    LOGGER.info("safely mapping SeShapeType to abstract Geometry");
                }
            } else if (isCollection == 1) {
                if (isPoint == 1) {
                    clazz = MultiPoint.class;
                } else if (isLineString == 1) {
                    clazz = MultiLineString.class;
                } else if (isPolygon == 1) {
                    clazz = MultiPolygon.class;
                } else {
                    isError = true;
                }
            } else if (isPoint == 1) {
                clazz = Point.class;
            } else if (isLineString == 1) {
                clazz = LineString.class;
            } else if (isPolygon == 1) {
                clazz = Polygon.class;
            } else {
                isError = true;
            }
            if (isError) {
                throw new IllegalArgumentException("Cannot map the shape type to a Geometry class: isCollection=" + isCollection + ", isPoint=" + isPoint + ", isLineString=" + isLineString + ", isPolygon=" + isPolygon);
            }
        }
        return clazz;
    }

    public static long getNumericFid(String fid) throws IllegalArgumentException {
        int dotIndex = fid.lastIndexOf(46);
        try {
            return Long.decode(fid.substring(++dotIndex));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("FeatureID " + fid + " does not seems as a valid ArcSDE FID");
        }
    }

    public static long[] getNumericFids(String[] stringFids) throws IllegalArgumentException {
        int nfids = stringFids.length;
        long[] fids = new long[nfids];
        for (int i = 0; i < nfids; ++i) {
            fids[i] = ArcSDEAdapter.getNumericFid(stringFids[i]);
        }
        return fids;
    }

    static {
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_STRING), String.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_INT16), Short.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_INT32), Integer.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_INT64), Long.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_FLOAT32), Float.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_FLOAT64), Double.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_DATE), Date.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_NSTRING), String.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_SMALLINT), Short.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_INTEGER), Integer.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_FLOAT), Float.class);
        sde2JavaTypes.put(new Integer(SeColumnDefinition.TYPE_DOUBLE), Double.class);
        java2SDETypes.put(String.class, new SdeTypeDef(SeColumnDefinition.TYPE_STRING, 255, 0));
        java2SDETypes.put(Short.class, new SdeTypeDef(SeColumnDefinition.TYPE_SMALLINT, 4, 0));
        java2SDETypes.put(Integer.class, new SdeTypeDef(SeColumnDefinition.TYPE_INTEGER, 10, 0));
        java2SDETypes.put(Float.class, new SdeTypeDef(SeColumnDefinition.TYPE_FLOAT, 5, 2));
        java2SDETypes.put(Double.class, new SdeTypeDef(SeColumnDefinition.TYPE_DOUBLE, 15, 4));
        java2SDETypes.put(Date.class, new SdeTypeDef(SeColumnDefinition.TYPE_DATE, 1, 0));
        java2SDETypes.put(Long.class, new SdeTypeDef(SeColumnDefinition.TYPE_INTEGER, 10, 0));
        java2SDETypes.put([B.class, new SdeTypeDef(SeColumnDefinition.TYPE_BLOB, 1, 0));
        java2SDETypes.put(Number.class, new SdeTypeDef(SeColumnDefinition.TYPE_DOUBLE, 15, 4));
    }

    private static class SdeTypeDef {
        final int colDefType;
        final int size;
        final int scale;

        public SdeTypeDef(int colDefType, int size, int scale) {
            this.colDefType = colDefType;
            this.size = size;
            this.scale = scale;
        }

        public String toString() {
            return "SdeTypeDef[colDefType=" + this.colDefType + ", size=" + this.size + ", scale=" + this.scale + "]";
        }
    }
}

