/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeShape;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.arcsde.data.ArcSDEQuery;
import org.geotools.arcsde.data.GeometryBuilder;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.type.GeometricAttributeType;

class ArcSDEAttributeReader
implements AttributeReader {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data");
    private ArcSDEQuery query;
    private FeatureType schema;
    private Object[] currentValues;
    private long currentFid = -1L;
    private GeometryBuilder geometryBuilder;
    private StringBuffer fidPrefix;
    private int fidPrefixLen;
    private boolean hasNextAlreadyCalled = false;
    private String featureIDAttributeName;

    public ArcSDEAttributeReader(ArcSDEQuery query) throws IOException {
        this.query = query;
        this.schema = query.getSchema();
        this.currentValues = new Object[this.schema.getAttributeCount()];
        this.featureIDAttributeName = ArcSDEAdapter.getRowIdColumn(this.schema);
        this.fidPrefix = new StringBuffer(this.schema.getTypeName()).append(".");
        this.fidPrefixLen = this.fidPrefix.length();
        GeometryAttributeType geomType = this.schema.getDefaultGeometry();
        if (geomType != null) {
            Class geometryClass = geomType.getType();
            this.geometryBuilder = GeometryBuilder.builderFor(geometryClass);
        }
    }

    public int getAttributeCount() {
        return this.schema.getAttributeCount();
    }

    public AttributeType getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        return this.schema.getAttributeType(index);
    }

    public void close() throws IOException {
        this.query.close();
    }

    public boolean hasNext() throws IOException {
        if (!this.hasNextAlreadyCalled) {
            try {
                SeRow currentRow = this.query.fetch();
                this.hasNextAlreadyCalled = true;
                if (currentRow == null) {
                    this.query.close();
                    this.currentValues = null;
                } else {
                    int attCount = this.schema.getAttributeCount();
                    int columns = currentRow.getColumns().length;
                    for (int i = 0; i < columns; ++i) {
                        Object value = currentRow.getObject(i);
                        if (this.featureIDAttributeName != null && this.schema.getAttributeType(i).getName().equalsIgnoreCase(this.featureIDAttributeName)) {
                            if (value == null) {
                                throw new DataSourceException("Unable to reliably determine an FID column for this table, so we defaulted to using the '" + this.featureIDAttributeName + "' column.  But it was null, leaving us no FID for this feature.");
                            }
                            this.currentFid = Long.parseLong(value.toString());
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("Fetched fid " + this.currentFid + " from column " + this.featureIDAttributeName);
                            }
                        }
                        if (this.schema.getAttributeType(i) instanceof GeometricAttributeType) {
                            SeShape shape = (SeShape)value;
                            this.currentValues[i] = value = this.geometryBuilder.construct(shape);
                            continue;
                        }
                        this.currentValues[i] = value;
                    }
                }
            }
            catch (SeException ex) {
                this.currentValues = null;
                this.hasNextAlreadyCalled = true;
                this.query.close();
                LOGGER.log(Level.SEVERE, ex.getSeError().getErrDesc(), ex);
                throw new DataSourceException("Fetching row:" + ex.getSeError().getErrDesc(), (Throwable)ex);
            }
            catch (DataSourceException dse) {
                this.currentValues = null;
                this.hasNextAlreadyCalled = true;
                this.query.close();
                LOGGER.log(Level.SEVERE, dse.getLocalizedMessage(), dse);
                throw dse;
            }
        }
        return this.currentValues != null;
    }

    public void next() throws IOException {
        if (this.currentValues == null) {
            throw new DataSourceException("There are no more rows");
        }
        this.hasNextAlreadyCalled = false;
    }

    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        return this.currentValues[index];
    }

    public Object[] readAll() {
        return this.currentValues;
    }

    public String readFID() throws IOException {
        if (this.currentFid == -1L) {
            throw new DataSourceException("The feature id was not fetched");
        }
        this.fidPrefix.setLength(this.fidPrefixLen);
        this.fidPrefix.append(this.currentFid);
        return this.fidPrefix.toString();
    }
}

