/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeTable;
import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.arcsde.data.ArcSDEAttributeReader;
import org.geotools.arcsde.data.ArcSDEFeatureWriter;
import org.geotools.arcsde.data.ArcSDEQuery;
import org.geotools.arcsde.data.ArcTransactionState;
import org.geotools.arcsde.pool.ArcSDEConnectionPool;
import org.geotools.arcsde.pool.ArcSDEPooledConnection;
import org.geotools.arcsde.pool.UnavailableArcSDEConnectionException;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultFeatureReader;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ArcSDEDataStore
extends AbstractDataStore {
    private static final Logger LOGGER = Logger.getLogger(ArcSDEDataStore.class.getPackage().getName());
    private ArcSDEConnectionPool connectionPool;
    private URI namespace;
    private Map schemasCache = new HashMap();
    private Object mutex = new Object();

    public ArcSDEDataStore(ArcSDEConnectionPool connectionPool) {
        super(true);
        this.connectionPool = connectionPool;
    }

    public ArcSDEDataStore(ArcSDEConnectionPool connectionPool, URI nsUri) {
        super(true);
        if (connectionPool == null) {
            throw new NullPointerException("connectionPool");
        }
        this.connectionPool = connectionPool;
        this.namespace = nsUri;
    }

    public ArcSDEConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public String[] getTypeNames() throws IOException {
        List layerNames = this.connectionPool.getAvailableLayerNames();
        return layerNames.toArray(new String[layerNames.size()]);
    }

    public synchronized FeatureType getSchema(String typeName) throws IOException {
        FeatureType schema;
        if (typeName == null) {
            throw new NullPointerException("typeName is null");
        }
        ArcSDEPooledConnection conn = null;
        if (typeName.indexOf(46) == -1) {
            try {
                conn = this.getConnectionPool().getConnection();
                LOGGER.warning("A non qualified type name was given, qualifying it...");
                typeName = conn.getDatabaseName() != null && conn.getDatabaseName().length() != 0 ? conn.getDatabaseName() + "." + conn.getUser() + "." + typeName : conn.getUser() + "." + typeName;
                LOGGER.info("full qualified name is " + typeName);
            }
            catch (DataSourceException e) {
                throw e;
            }
            catch (UnavailableArcSDEConnectionException e) {
                throw new DataSourceException("A non qualified type name (" + typeName + ") was passed and a connection to retrieve the user name " + " is not available.", (Throwable)e);
            }
            catch (SeException e) {
                throw new DataSourceException("error obtaining the user name from a connection", (Throwable)e);
            }
            finally {
                conn.close();
            }
        }
        if ((schema = (FeatureType)this.schemasCache.get(typeName)) == null) {
            schema = ArcSDEAdapter.fetchSchema(this.getConnectionPool(), typeName, this.namespace);
            this.schemasCache.put(typeName, schema);
        }
        return schema;
    }

    public void createSchema(FeatureType schema) throws IOException, IllegalArgumentException {
        this.createSchema(schema, "DEFAULTS");
    }

    public void createSchema(FeatureType featureType, String configKeyword) throws IOException, IllegalArgumentException {
        if (featureType == null) {
            throw new NullPointerException("You have to provide a FeatureType instance");
        }
        if (featureType.getDefaultGeometry() == null) {
            throw new IllegalArgumentException("FeatureType must have at least a geometry attribute");
        }
        String nonQualifiedTypeName = featureType.getTypeName();
        if (nonQualifiedTypeName.indexOf(46) != -1) {
            throw new IllegalArgumentException("Please do not use type names that contains '.' (dots)");
        }
        ArcSDEPooledConnection connection = null;
        SeTable table = null;
        SeLayer layer = null;
        boolean tableCreated = false;
        Object error = null;
        try {
            try {
                connection = this.connectionPool.getConnection();
                String qualifiedName = null;
                if (nonQualifiedTypeName.indexOf(46) == -1) {
                    qualifiedName = connection.getUser() + "." + featureType.getTypeName();
                    LOGGER.fine("new full qualified type name: " + qualifiedName);
                } else {
                    qualifiedName = nonQualifiedTypeName;
                    LOGGER.fine("full qualified type name provided by user: " + qualifiedName);
                }
                layer = new SeLayer((SeConnection)connection);
                layer.setTableName(qualifiedName);
                if (configKeyword != null) {
                    layer.setCreationKeyword(configKeyword);
                } else {
                    layer.setCreationKeyword("DEFAULTS");
                }
                String HACK_COL_NAME = "gt_workaround_col_";
                table = this.createSeTable(connection, qualifiedName, "gt_workaround_col_", configKeyword);
                tableCreated = true;
                AttributeType[] atts = featureType.getAttributeTypes();
                for (int currAttIndex = 0; currAttIndex < atts.length; ++currAttIndex) {
                    AttributeType currAtt = atts[currAttIndex];
                    if (currAtt instanceof GeometryAttributeType) {
                        GeometryAttributeType geometryAtt = (GeometryAttributeType)currAtt;
                        this.createSeLayer(layer, qualifiedName, geometryAtt);
                        continue;
                    }
                    LOGGER.info("Creating column definition for " + currAtt);
                    SeColumnDefinition newCol = ArcSDEAdapter.createSeColumnDefinition(currAtt);
                    newCol = new SeColumnDefinition(newCol.getName(), newCol.getType(), newCol.getSize(), newCol.getScale(), true);
                    LOGGER.fine("Adding column " + newCol.getName() + " to the actual table.");
                    table.addColumn(newCol);
                }
                LOGGER.fine("deleting the 'workaround' column...");
                table.dropColumn("gt_workaround_col_");
                SeRegistration reg = new SeRegistration((SeConnection)connection, table.getName());
                String rowIdColumnName = ArcSDEAdapter.getRowIdColumn(featureType);
                if (rowIdColumnName != null) {
                    LOGGER.fine("setting rowIdColumnName to " + rowIdColumnName + " in table " + reg.getTableName());
                    reg.setRowIdColumnName(rowIdColumnName);
                    reg.setRowIdColumnType(SeRegistration.SE_REGISTRATION_ROW_ID_COLUMN_TYPE_SDE);
                    reg.alter();
                    reg = null;
                }
                LOGGER.info("Schema correctly created: " + featureType);
            }
            catch (SeException e) {
                LOGGER.log(Level.WARNING, e.getSeError().getErrDesc(), e);
                throw new DataSourceException(e.getMessage(), (Throwable)e);
            }
            catch (DataSourceException dse) {
                LOGGER.log(Level.WARNING, dse.getMessage(), dse);
                throw dse;
            }
            catch (UnavailableArcSDEConnectionException uce) {
                LOGGER.log(Level.WARNING, uce.getMessage(), uce);
                throw new DataSourceException(uce.getMessage(), (Throwable)uce);
            }
            Object var16_19 = null;
            if (error == null || tableCreated) {
                // empty if block
            }
            connection.close();
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (error == null || tableCreated) {
                // empty if block
            }
            connection.close();
            throw throwable;
        }
    }

    private SeTable createSeTable(ArcSDEPooledConnection connection, String qualifiedName, String hackColName, String configKeyword) throws SeException {
        String keyword = configKeyword == null ? "DEFAULTS" : configKeyword;
        SeColumnDefinition[] tmpCol = new SeColumnDefinition[]{new SeColumnDefinition(hackColName, SeColumnDefinition.TYPE_SMALLINT, 4, 0, true)};
        SeTable table = new SeTable((SeConnection)connection, qualifiedName);
        try {
            LOGGER.warning("Remove the line 'table.delete()' for production use!!!");
            table.delete();
        }
        catch (SeException e) {
            // empty catch block
        }
        LOGGER.info("creating table " + qualifiedName);
        table.create(tmpCol, configKeyword);
        LOGGER.info("table " + qualifiedName + " created...");
        return table;
    }

    private void createSeLayer(SeLayer layer, String qualifiedName, GeometryAttributeType geometryAtt) throws SeException {
        String spatialColName = geometryAtt.getName();
        LOGGER.info("setting spatial column name: " + spatialColName);
        layer.setSpatialColumnName(spatialColName);
        int seShapeTypes = ArcSDEAdapter.guessShapeTypes(geometryAtt);
        layer.setShapeTypes(seShapeTypes);
        layer.setGridSizes(1100, 0, 0);
        layer.setDescription("Created with GeoTools");
        CoordinateReferenceSystem crs = geometryAtt.getCoordinateSystem();
        SeCoordinateReference coordref = ArcSDEDataStore.getGenericCoordRef();
        String WKT = null;
        if (crs == null) {
            LOGGER.warning("Creating feature type " + qualifiedName + ": the geometry attribute does not supply a coordinate reference system");
        } else {
            LOGGER.info("Creating the SeCoordRef object for CRS " + crs);
            WKT = crs.toWKT();
            coordref.setCoordSysByDescription(WKT);
        }
        SeExtent validCoordRange = null;
        validCoordRange = WKT != null && WKT.indexOf("GEOGCS") != -1 ? new SeExtent(-180.0, -90.0, 180.0, 90.0) : coordref.getXYEnvelope();
        layer.setExtent(validCoordRange);
        LOGGER.info("Applying CRS " + coordref.getCoordSysDescription());
        layer.setCoordRef(coordref);
        LOGGER.info("CRS applyed to the new layer.");
        int estInitFeatCount = 4;
        int estAvgPointsPerFeature = 4;
        LOGGER.info("Creating the layer...");
        layer.create(estInitFeatCount, estAvgPointsPerFeature);
        LOGGER.info("ArcSDE layer created.");
    }

    private static SeCoordinateReference getGenericCoordRef() throws SeException {
        SeCoordinateReference seCRS = new SeCoordinateReference();
        int shift = 600000;
        SeExtent validRange = new SeExtent((double)(-shift), (double)(-shift), (double)shift, (double)shift);
        seCRS.setXYByEnvelope(validRange);
        LOGGER.info("CRS: " + seCRS.getXYEnvelope());
        return seCRS;
    }

    protected FeatureReader getFeatureReader(String typeName) throws IOException {
        return this.getFeatureReader(typeName, Query.ALL);
    }

    protected FeatureReader getFeatureReader(String typeName, Query query) throws IOException {
        ArcSDEQuery sdeQuery = null;
        DefaultFeatureReader reader = null;
        try {
            FeatureType schema = this.getSchema(typeName);
            sdeQuery = ArcSDEQuery.createQuery(this, schema, query);
            sdeQuery.execute();
            ArcSDEAttributeReader attReader = new ArcSDEAttributeReader(sdeQuery);
            final FeatureType resultingSchema = sdeQuery.getSchema();
            reader = new DefaultFeatureReader(attReader, resultingSchema){

                protected Feature readFeature(AttributeReader atts) throws IllegalAttributeException, IOException {
                    ArcSDEAttributeReader sdeAtts = (ArcSDEAttributeReader)atts;
                    Object[] currAtts = sdeAtts.readAll();
                    System.arraycopy(currAtts, 0, this.attributes, 0, currAtts.length);
                    return resultingSchema.create(this.attributes, sdeAtts.readFID());
                }
            };
        }
        catch (SchemaException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            throw new DataSourceException("Types do not match: " + ex.getMessage(), (Throwable)ex);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception t) {
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
            if (LOGGER.isLoggable(Level.FINE)) {
                t.printStackTrace();
            }
            if (sdeQuery != null) {
                sdeQuery.close();
            }
            throw new DataSourceException("Problem with feature reader: " + t.getMessage(), (Throwable)t);
        }
        return reader;
    }

    public FeatureReader getFeatureReader(Query query, Transaction transaction) throws IOException {
        String typeName = query.getTypeName();
        return this.getFeatureReader(typeName, query);
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        try {
            ArcSDEQuery.FilterSet filters = ArcSDEQuery.createFilters(this, typeName, filter);
            Filter result = filters.getUnsupportedFilter();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Supported filters: " + filters.getSqlFilter() + " --- " + filters.getGeometryFilter());
                LOGGER.fine("Unsupported filter: " + result.toString());
            }
            return result;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureWriter getFeatureWriter(String typeName) throws IOException {
        SeLayer layer;
        ArcSDEPooledConnection conn;
        try {
            conn = this.connectionPool.getConnection();
        }
        catch (UnavailableArcSDEConnectionException e) {
            throw new DataSourceException((Throwable)e);
        }
        try {
            layer = this.connectionPool.getSdeLayer(conn, typeName);
        }
        finally {
            conn.close();
        }
        return new ArcSDEFeatureWriter(this, null, layer);
    }

    public FeatureWriter getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        FeatureWriter featureWriter = super.getFeatureWriter(typeName, transaction);
        return featureWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        FeatureType featureType = this.getSchema(typeName);
        AttributeType[] attributes = featureType.getAttributeTypes();
        String[] names = new String[attributes.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = attributes[i].getName();
        }
        DefaultQuery query = new DefaultQuery(typeName, filter, 100, names, "handle");
        ArrayList<Feature> list = new ArrayList<Feature>();
        FeatureReader featureReader = this.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        while (featureReader.hasNext()) {
            try {
                list.add(featureReader.next());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                break;
            }
        }
        ArcTransactionState state = null;
        if (Transaction.AUTO_COMMIT != transaction) {
            ArcSDEDataStore arcSDEDataStore = this;
            synchronized (arcSDEDataStore) {
                Transaction.State s = transaction.getState((Object)this);
                if (!(s instanceof ArcTransactionState)) {
                    if (s != null) {
                        transaction.removeState((Object)this);
                    }
                    state = new ArcTransactionState(this);
                    transaction.putState((Object)this, (Transaction.State)state);
                } else {
                    state = (ArcTransactionState)s;
                }
            }
        }
        SeLayer layer = this.connectionPool.getSdeLayer(typeName);
        ArcSDEFeatureWriter writer = new ArcSDEFeatureWriter(this, state, layer, list);
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        ArcTransactionState state = null;
        if (Transaction.AUTO_COMMIT != transaction) {
            ArcSDEDataStore arcSDEDataStore = this;
            synchronized (arcSDEDataStore) {
                state = (ArcTransactionState)transaction.getState((Object)this);
                if (state == null) {
                    state = new ArcTransactionState(this);
                    transaction.putState((Object)this, (Transaction.State)state);
                }
            }
        }
        SeLayer layer = this.connectionPool.getSdeLayer(typeName);
        ArcSDEFeatureWriter writer = new ArcSDEFeatureWriter(this, state, layer);
        return writer;
    }

    protected int getCount(Query query) throws IOException {
        LOGGER.info("getCount");
        int count = ArcSDEQuery.calculateResultCount(this, query);
        LOGGER.info("count: " + count);
        return count;
    }

    protected Envelope getBounds(Query query) throws IOException {
        Envelope ev;
        LOGGER.info("getBounds");
        if (query.getFilter() == null || query.getFilter().equals(Filter.NONE)) {
            LOGGER.fine("getting bounds of entire layer.  Using optimized SDE call.");
            SeLayer thisLayer = this.connectionPool.getSdeLayer(query.getTypeName());
            SeExtent extent = thisLayer.getExtent();
            ev = new Envelope(extent.getMinX(), extent.getMaxX(), extent.getMinY(), extent.getMaxY());
        } else {
            ev = ArcSDEQuery.calculateQueryExtent(this, query);
        }
        LOGGER.info("bounds: " + ev);
        return ev;
    }
}

