/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeDelete;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeInsert;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeUpdate;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.data.ArcTransactionState;
import org.geotools.arcsde.data.GeometryBuilder;
import org.geotools.arcsde.pool.ArcSDEPooledConnection;
import org.geotools.arcsde.pool.UnavailableArcSDEConnectionException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureWriter;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

class ArcSDEFeatureWriter
implements FeatureWriter {
    private static final Logger LOGGER = Logger.getLogger(ArcSDEFeatureWriter.class.getPackage().getName());
    private ArcSDEDataStore dataStore;
    private ArcTransactionState transactionState;
    private SeLayer layer;
    private SeColumnDefinition[] columnDefinitions;
    private List features;
    private int currentIndex;
    private boolean notInserted;
    private String[] columns;
    private Integer[] mutableAttributeIndexes;
    private String rowIDColumnName;

    public ArcSDEFeatureWriter(ArcSDEDataStore store, ArcTransactionState state, SeLayer layer, List features) throws DataSourceException {
        this.transactionState = state;
        this.features = features != null ? features : new ArrayList();
        this.dataStore = store;
        this.layer = layer;
        this.currentIndex = -1;
        try {
            this.rowIDColumnName = ArcSDEAdapter.getRowIdColumn(this.dataStore.getSchema(layer.getQualifiedName()));
        }
        catch (SeException se) {
            LOGGER.log(Level.SEVERE, "", se);
            throw new DataSourceException((Throwable)se);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "", ioe);
            throw new DataSourceException((Throwable)ioe);
        }
    }

    public ArcSDEFeatureWriter(ArcSDEDataStore store, ArcTransactionState state, SeLayer layer) throws DataSourceException {
        this(store, state, layer, null);
    }

    public FeatureType getFeatureType() {
        try {
            return ArcSDEAdapter.fetchSchema(this.dataStore.getConnectionPool(), this.layer.getQualifiedName(), this.dataStore.getNamespace());
        }
        catch (SeException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public synchronized Feature next() throws IOException {
        Feature feature;
        if (!this.hasNext()) {
            DefaultFeatureType featureType = (DefaultFeatureType)this.getFeatureType();
            Object[] attributes = new Object[featureType.getAttributeCount()];
            try {
                feature = featureType.create(attributes);
            }
            catch (IllegalAttributeException iae) {
                LOGGER.log(Level.WARNING, iae.getMessage(), iae);
                throw new IOException(iae.getMessage());
            }
            this.features.add(feature);
            ++this.currentIndex;
            this.notInserted = true;
        } else {
            feature = (Feature)this.features.get(++this.currentIndex);
        }
        return feature;
    }

    public synchronized void remove() throws IOException {
        if (this.features == null || this.currentIndex >= this.features.size()) {
            throw new IOException("No current feature available.");
        }
        if (this.notInserted) {
            this.features.remove(this.currentIndex--);
            this.notInserted = false;
        } else {
            Feature feature = (Feature)this.features.get(this.currentIndex);
            ArcSDEPooledConnection connection = null;
            try {
                connection = this.getConnection();
                SeDelete seDelete = new SeDelete((SeConnection)connection);
                long featureId = ArcSDEAdapter.getNumericFid(feature.getID());
                SeObjectId objectID = new SeObjectId(featureId);
                seDelete.byId(this.layer.getQualifiedName(), objectID);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw new IOException(e.getMessage());
            }
            finally {
                this.releaseConnection(connection);
            }
        }
    }

    public synchronized void write() throws IOException {
        if (this.features == null || this.features.size() == 0) {
            throw new IOException("No feature to be written.");
        }
        ArcSDEPooledConnection connection = null;
        try {
            Feature feature = (Feature)this.features.get(this.currentIndex);
            FeatureType featureType = feature.getFeatureType();
            AttributeType[] attributeTypes = featureType.getAttributeTypes();
            connection = this.getConnection();
            if (this.notInserted) {
                SeInsert insert = new SeInsert((SeConnection)connection);
                String[] cols = this.getColumns(attributeTypes, connection);
                insert.intoTable(this.layer.getQualifiedName(), cols);
                insert.setWriteMode(true);
                SeRow row = insert.getRowToSet();
                for (int i = 0; i < cols.length; ++i) {
                    this.setRowValue(row, i, feature.getAttribute(this.mutableAttributeIndexes[i].intValue()));
                }
                insert.execute();
                insert.close();
            } else {
                SeUpdate update = new SeUpdate((SeConnection)connection);
                String[] cols = this.getColumns(attributeTypes, connection);
                String featureId = feature.getID().substring(feature.getID().lastIndexOf(46) + 1, feature.getID().length());
                update.toTable(this.layer.getQualifiedName(), cols, this.rowIDColumnName + " = " + featureId);
                update.setWriteMode(true);
                SeRow row = update.getRowToSet();
                for (int i = 0; i < cols.length; ++i) {
                    Object value = feature.getAttribute(this.mutableAttributeIndexes[i].intValue());
                    this.setRowValue(row, i, value);
                }
                update.execute();
                update.close();
            }
            this.releaseConnection(connection);
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                if (LOGGER.isLoggable(Level.FINE)) {
                    e.printStackTrace();
                }
                throw new DataSourceException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(connection);
                throw throwable;
            }
        }
    }

    public boolean hasNext() throws IOException {
        int size = this.features.size();
        return this.features != null && size > 0 && this.currentIndex + 1 < size;
    }

    public void close() throws IOException {
        this.dataStore = null;
        this.layer = null;
        this.features = null;
        this.currentIndex = 0;
    }

    private synchronized String[] getColumns(AttributeType[] attributeTypes, SeConnection connection) throws SeException {
        if (this.columnDefinitions == null) {
            SeTable table = new SeTable(connection, this.layer.getQualifiedName());
            this.columnDefinitions = table.describe();
            ArrayList<String> columnList = new ArrayList<String>();
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int i = 0; i < attributeTypes.length; ++i) {
                if (attributeTypes[i].getName().equals(this.layer.getShapeAttributeName(SeLayer.SE_SHAPE_ATTRIBUTE_FID)) || this.columnDefinitions[i].getRowIdType() == 1) continue;
                columnList.add(attributeTypes[i].getName().toUpperCase());
                indexes.add(new Integer(i));
            }
            this.columns = new String[columnList.size()];
            this.mutableAttributeIndexes = new Integer[indexes.size()];
            columnList.toArray(this.columns);
            indexes.toArray(this.mutableAttributeIndexes);
        }
        return this.columns;
    }

    private void setRowValue(SeRow row, int index, Object value) throws SeException, IOException {
        SeColumnDefinition seColumnDefinition = null;
        seColumnDefinition = row.getColumnDef(index);
        int colType = seColumnDefinition.getType();
        if (colType == SeColumnDefinition.TYPE_INTEGER) {
            if (value != null) {
                row.setInteger(index, new Integer(value.toString()));
            } else {
                row.setInteger(index, null);
            }
        } else if (colType == SeColumnDefinition.TYPE_SMALLINT) {
            if (value != null) {
                row.setShort(index, new Short(value.toString()));
            } else {
                row.setShort(index, null);
            }
        } else if (colType == SeColumnDefinition.TYPE_FLOAT) {
            if (value != null) {
                row.setFloat(index, new Float(value.toString()));
            } else {
                row.setFloat(index, null);
            }
        } else if (colType == SeColumnDefinition.TYPE_DOUBLE) {
            if (value != null) {
                row.setDouble(index, new Double(value.toString()));
            } else {
                row.setDouble(index, null);
            }
        } else if (colType == SeColumnDefinition.TYPE_STRING) {
            if (value != null) {
                row.setString(index, value.toString());
            } else {
                row.setString(index, null);
            }
        } else if (colType == SeColumnDefinition.TYPE_DATE) {
            if (value != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)value);
                row.setTime(index, calendar);
            } else {
                row.setTime(index, null);
            }
        } else if (colType == SeColumnDefinition.TYPE_SHAPE) {
            if (value != null) {
                try {
                    GeometryBuilder geometryBuilder = GeometryBuilder.builderFor(value.getClass());
                    SeCoordinateReference coordRef = this.layer.getCoordRef();
                    Geometry geom = (Geometry)value;
                    SeShape shape = geometryBuilder.constructShape(geom, coordRef);
                    row.setShape(index, shape);
                }
                catch (Exception e) {
                    String msg = e instanceof SeException ? ((SeException)((Object)e)).getSeError().getErrDesc() : e.getMessage();
                    LOGGER.log(Level.WARNING, msg, e);
                    throw new DataSourceException(msg, (Throwable)e);
                }
            } else {
                row.setShape(index, null);
            }
        }
    }

    private synchronized ArcSDEPooledConnection getConnection() throws DataSourceException, UnavailableArcSDEConnectionException {
        if (this.transactionState != null) {
            return this.transactionState.getConnection();
        }
        return this.dataStore.getConnectionPool().getConnection();
    }

    private synchronized void releaseConnection(ArcSDEPooledConnection connection) {
        if (this.transactionState == null) {
            connection.close();
        }
    }
}

