/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeFilter;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeTable;
import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.arcsde.data.ArcSDEAttributeType;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.filter.GeometryEncoderException;
import org.geotools.arcsde.filter.GeometryEncoderSDE;
import org.geotools.arcsde.filter.SQLEncoderSDE;
import org.geotools.arcsde.pool.ArcSDEConnectionPool;
import org.geotools.arcsde.pool.ArcSDEPooledConnection;
import org.geotools.arcsde.pool.UnavailableArcSDEConnectionException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLUnpacker;

class ArcSDEQuery {
    private static final Logger LOGGER = Logger.getLogger(ArcSDEQuery.class.getPackage().getName());
    ArcSDEConnectionPool connectionPool;
    ArcSDEPooledConnection connection = null;
    private FeatureType schema;
    private SeQuery query;
    private FilterSet filters;
    private int resultCount = -1;
    private Envelope resultEnvelope;

    private ArcSDEQuery(ArcSDEConnectionPool pool, FeatureType schema, FilterSet filterSet) throws DataSourceException {
        this.schema = schema;
        this.connectionPool = pool;
        this.filters = filterSet;
    }

    public static ArcSDEQuery createQuery(ArcSDEDataStore store, Query query) throws IOException {
        return ArcSDEQuery.createQuery(store, store.getSchema(query.getTypeName()), query);
    }

    public static ArcSDEQuery createQuery(ArcSDEDataStore store, FeatureType schema, Query query) throws IOException {
        if (store == null || schema == null || query == null) {
            throw new NullPointerException("store=" + (Object)((Object)store) + ", schema=" + schema + ", query=" + query);
        }
        Filter filter = query.getFilter();
        if (filter == Filter.ALL) {
            return null;
        }
        LOGGER.fine("Creating new ArcSDEQuery");
        ArcSDEQuery sdeQuery = null;
        String typeName = schema.getTypeName();
        ArcSDEConnectionPool pool = store.getConnectionPool();
        String[] queryColumns = query.getPropertyNames();
        queryColumns = ArcSDEQuery.getQueryColumns(pool, typeName, queryColumns, schema);
        FeatureType querySchema = null;
        try {
            querySchema = DataUtilities.createSubType((FeatureType)schema, (String[])queryColumns);
        }
        catch (SchemaException ex) {
            throw new DataSourceException("Some requested attributes do not match the table schema: " + ex.getMessage(), (Throwable)ex);
        }
        FilterSet filterSet = ArcSDEQuery.createFilters(store, typeName, filter);
        sdeQuery = new ArcSDEQuery(pool, querySchema, filterSet);
        return sdeQuery;
    }

    private static String[] getQueryColumns(ArcSDEConnectionPool pool, String typeName, String[] queryColumns, FeatureType schema) throws DataSourceException {
        int i;
        if (queryColumns == null || queryColumns.length == 0) {
            SeTable table = pool.getSdeTable(typeName);
            SeColumnDefinition[] sdeCols = null;
            try {
                sdeCols = table.describe();
            }
            catch (SeException ex) {
                throw new DataSourceException(ex.getMessage(), (Throwable)ex);
            }
            queryColumns = new String[sdeCols.length];
            for (int i2 = 0; i2 < sdeCols.length; ++i2) {
                queryColumns[i2] = sdeCols[i2].getName();
            }
        }
        boolean hasFIDColumn = false;
        for (i = 0; i < queryColumns.length; ++i) {
            AttributeType type = schema.getAttributeType(schema.find(queryColumns[i]));
            if (!(type instanceof ArcSDEAttributeType) || !((ArcSDEAttributeType)type).isFeatureIDAttribute()) continue;
            hasFIDColumn = true;
            break;
        }
        if (!hasFIDColumn) {
            LOGGER.info("No FID attribute was contained in your query.  Appending the discovered one to the list of columns to be fetched.");
            for (i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeType type = schema.getAttributeType(i);
                if (!(type instanceof ArcSDEAttributeType) || !((ArcSDEAttributeType)type).isFeatureIDAttribute()) continue;
                String[] newQCols = new String[queryColumns.length + 1];
                System.arraycopy(queryColumns, 0, newQCols, 0, queryColumns.length);
                newQCols[queryColumns.length] = type.getName();
                LOGGER.fine("Appendend " + newQCols[queryColumns.length] + " to column list.");
                queryColumns = newQCols;
                break;
            }
        }
        return queryColumns;
    }

    public static FilterSet createFilters(ArcSDEDataStore store, String typeName, Filter filter) throws NoSuchElementException, IOException {
        SeLayer sdeLayer = store.getConnectionPool().getSdeLayer(typeName);
        FilterSet filters = new FilterSet(sdeLayer, filter, store.getSchema(typeName));
        return filters;
    }

    private SeQuery getSeQuery() throws SeException, IOException {
        if (this.query == null) {
            ArcSDEPooledConnection conn = this.getConnection();
            try {
                String[] propsToQuery = this.getPropertiesToFetch();
                this.query = this.createSeQueryForFetch(conn, propsToQuery);
            }
            catch (DataSourceException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (SeException e) {
                throw e;
            }
        }
        return this.query;
    }

    private SeQuery createSeQueryForFetch(ArcSDEPooledConnection connection, String[] propertyNames) throws SeException, DataSourceException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("constructing new sql query with connection: " + (Object)((Object)connection) + ", propnames: " + Arrays.asList(propertyNames) + " sqlConstruct where clause: '" + this.filters.getSeSqlConstruct().getWhere());
        }
        SeQuery query = new SeQuery((SeConnection)connection, propertyNames, this.filters.getSeSqlConstruct());
        SeFilter[] spatialConstraints = this.filters.getSpatialFilters();
        query.prepareQuery();
        if (spatialConstraints.length > 0) {
            boolean setReturnGeometryMasks = false;
            query.setSpatialConstraints(SeQuery.SE_OPTIMIZE, false, spatialConstraints);
        }
        return query;
    }

    private SeQuery createSeQueryForQueryInfo(ArcSDEPooledConnection connection, String[] propertyNames) throws SeException, DataSourceException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("constructing new sql query with connection: " + (Object)((Object)connection) + ", propnames: " + Arrays.asList(propertyNames) + " sqlConstruct: " + this.filters.getSeSqlConstruct());
        }
        SeQuery query = new SeQuery((SeConnection)connection, propertyNames, this.filters.getSeSqlConstruct());
        SeFilter[] spatialConstraints = this.filters.getSpatialFilters();
        if (spatialConstraints.length > 0) {
            boolean setReturnGeometryMasks = true;
            query.setSpatialConstraints(SeQuery.SE_OPTIMIZE, true, spatialConstraints);
        }
        return query;
    }

    private String[] getPropertiesToFetch() throws IOException {
        String[] attNames = new String[this.schema.getAttributeCount()];
        for (int i = 0; i < this.schema.getAttributeCount(); ++i) {
            attNames[i] = this.schema.getAttributeType(i).getName();
        }
        return attNames;
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public FilterSet getFilters() {
        return this.filters;
    }

    public static int calculateResultCount(ArcSDEDataStore ds, Query query) throws IOException {
        return ArcSDEQuery.createQuery(ds, query).calculateResultCount();
    }

    public static Envelope calculateQueryExtent(ArcSDEDataStore ds, Query query) throws IOException {
        return ArcSDEQuery.createQuery(ds, query).calculateQueryExtent();
    }

    public int calculateResultCount() throws IOException {
        LOGGER.fine("about to calculate result count");
        if (this.resultCount == -1) {
            String aFieldName = "*";
            String[] columns = new String[]{aFieldName};
            SeQuery countQuery = null;
            try {
                countQuery = this.createSeQueryForQueryInfo(this.getConnection(), columns);
                SeQueryInfo qInfo = new SeQueryInfo();
                qInfo.setConstruct(this.filters.getSeSqlConstruct());
                SeTable.SeTableStats tableStats = countQuery.calculateTableStatistics(aFieldName, SeTable.SeTableStats.SE_COUNT_STATS, qInfo, 0);
                this.resultCount = tableStats.getCount();
                this.close(countQuery);
                this.releaseConnection();
            }
            catch (SeException e) {
                try {
                    throw new DataSourceException("Calculating result count: " + e.getSeError().getErrDesc(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.close(countQuery);
                    this.releaseConnection();
                    throw throwable;
                }
            }
        }
        return this.resultCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Envelope calculateQueryExtent() throws IOException {
        Envelope envelope = null;
        SeQuery extentQuery = null;
        LOGGER.fine("Building a new SeQuery to consult it's resulting envelope");
        try {
            SeExtent extent = null;
            SeLayer layer = this.connectionPool.getSdeLayer(this.schema.getTypeName());
            String[] spatialCol = new String[]{layer.getSpatialColumn()};
            extentQuery = this.createSeQueryForQueryInfo(this.getConnection(), spatialCol);
            SeQueryInfo sdeQueryInfo = new SeQueryInfo();
            sdeQueryInfo.setColumns(spatialCol);
            sdeQueryInfo.setConstruct(this.filters.getSeSqlConstruct());
            extent = extentQuery.calculateLayerExtent(sdeQueryInfo);
            envelope = new Envelope(extent.getMinX(), extent.getMaxX(), extent.getMinY(), extent.getMaxY());
            LOGGER.info("got extent: " + extent + ", built envelope: " + envelope);
            this.close(extentQuery);
            this.releaseConnection();
        }
        catch (SeException ex) {
            try {
                SeSqlConstruct sqlCons = this.filters.getSeSqlConstruct();
                String sql = sqlCons == null ? null : sqlCons.getWhere();
                LOGGER.log(Level.SEVERE, "***********************\n" + ex.getSeError().getErrDesc() + "\nfilter: " + this.filters.getGeometryFilter() + "\nSQL: " + sql, ex);
                ex.printStackTrace();
                this.close(extentQuery);
                this.releaseConnection();
            }
            catch (Throwable throwable) {
                this.close(extentQuery);
                this.releaseConnection();
                throw throwable;
            }
        }
        return envelope;
    }

    private void releaseConnection() {
        if (this.connectionPool != null && this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    private ArcSDEPooledConnection getConnection() throws DataSourceException {
        if (this.connection == null) {
            try {
                if (this.connectionPool == null) {
                    throw new IllegalStateException("query is closed");
                }
                this.connection = this.connectionPool.getConnection();
            }
            catch (UnavailableArcSDEConnectionException e) {
                throw new DataSourceException("Can't obtain a connection: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.connection;
    }

    private void close(SeQuery query) {
        if (query == null) {
            return;
        }
        try {
            query.close();
        }
        catch (SeException e) {
            LOGGER.warning("Closing query: " + e.getSeError().getErrDesc());
        }
    }

    public void close() {
        this.close(this.query);
        this.query = null;
        this.releaseConnection();
        if (this.connectionPool != null) {
            this.connectionPool = null;
        }
    }

    public void execute() throws IOException {
        try {
            this.getSeQuery().execute();
        }
        catch (SeException e) {
            throw new DataSourceException(e.getSeError().getErrDesc(), (Throwable)e);
        }
    }

    public void flushBufferedWrites() throws IOException {
        try {
            this.getSeQuery().flushBufferedWrites();
        }
        catch (SeException e) {
            throw new DataSourceException(e.getSeError().getErrDesc(), (Throwable)e);
        }
    }

    public void cancel(boolean reset) throws IOException {
        try {
            this.getSeQuery().cancel(reset);
        }
        catch (SeException e) {
            throw new DataSourceException(e.getSeError().getErrDesc(), (Throwable)e);
        }
    }

    public void setRowLocking(int lockActions) throws IOException {
        try {
            this.getSeQuery().setRowLocking(lockActions);
        }
        catch (SeException e) {
            throw new DataSourceException(e.getSeError().getErrDesc(), (Throwable)e);
        }
    }

    public void prepareQuery() throws IOException {
        try {
            this.getSeQuery().prepareQuery();
        }
        catch (SeException e) {
            throw new DataSourceException(e.getSeError().getErrDesc(), (Throwable)e);
        }
    }

    public SeRow fetch() throws IOException {
        try {
            return this.getSeQuery().fetch();
        }
        catch (SeException e) {
            throw new DataSourceException(e.getSeError().getErrDesc(), (Throwable)e);
        }
    }

    public void setSpatialConstraints(SeFilter[] filters) throws IOException {
        try {
            this.getSeQuery().setSpatialConstraints(SeQuery.SE_OPTIMIZE, false, filters);
        }
        catch (SeException e) {
            throw new DataSourceException(e.getSeError().getErrDesc(), (Throwable)e);
        }
    }

    public String toString() {
        return "Schema: " + this.schema.getTypeName() + ", query: " + this.query;
    }

    public static class FilterSet {
        private SeLayer sdeLayer;
        private Filter sourceFilter;
        private Filter sqlFilter;
        private Filter geometryFilter;
        private Filter unsupportedFilter;
        private SeFilter[] sdeSpatialFilters;
        private SeSqlConstruct sdeSqlConstruct;
        private FeatureType schema;

        public FilterSet(SeLayer sdeLayer, Filter sourceFilter, FeatureType schema) {
            this.sdeLayer = sdeLayer;
            this.sourceFilter = sourceFilter;
            this.schema = schema;
            this.createGeotoolsFilters();
        }

        private void createGeotoolsFilters() {
            SQLEncoderSDE sqlEncoder = new SQLEncoderSDE(this.sdeLayer);
            SQLUnpacker unpacker = new SQLUnpacker(sqlEncoder.getCapabilities());
            unpacker.unPackAND(this.sourceFilter);
            this.sqlFilter = unpacker.getSupported();
            if (LOGGER.isLoggable(Level.FINE) && this.sqlFilter != null) {
                LOGGER.fine("SQL portion of SDE Query: '" + this.sqlFilter + "'");
            }
            Filter remainingFilter = unpacker.getUnSupported();
            unpacker = new SQLUnpacker(GeometryEncoderSDE.getCapabilities());
            unpacker.unPackAND(remainingFilter);
            this.geometryFilter = unpacker.getSupported();
            if (LOGGER.isLoggable(Level.FINE) && this.geometryFilter != null) {
                LOGGER.fine("Spatial-Filter portion of SDE Query: '" + this.geometryFilter + "'");
            }
            this.unsupportedFilter = unpacker.getUnSupported();
            if (LOGGER.isLoggable(Level.FINE) && this.unsupportedFilter != null) {
                LOGGER.fine("Unsupported (and therefore ignored) portion of SDE Query: '" + this.unsupportedFilter + "'");
            }
        }

        public SeSqlConstruct getSeSqlConstruct() throws DataSourceException {
            if (this.sdeSqlConstruct == null) {
                try {
                    String layerName = this.sdeLayer.getQualifiedName();
                    this.sdeSqlConstruct = new SeSqlConstruct(layerName);
                }
                catch (SeException e) {
                    throw new DataSourceException("Can't create SQL construct: " + e.getSeError().getErrDesc(), (Throwable)e);
                }
                Filter sqlFilter = this.getSqlFilter();
                if (!Filter.NONE.equals(sqlFilter)) {
                    String whereClause = null;
                    AttributeType[] queryColumns = this.schema.getAttributeTypes();
                    String rowIdColumn = ArcSDEAdapter.getRowIdColumn(this.schema);
                    if (rowIdColumn == null) {
                        rowIdColumn = this.sdeLayer.getSpatialColumn();
                    }
                    SQLEncoderSDE sqlEncoder = new SQLEncoderSDE(this.sdeLayer, rowIdColumn);
                    try {
                        whereClause = sqlEncoder.encode(sqlFilter);
                    }
                    catch (SQLEncoderException sqle) {
                        String message = "Geometry encoder error: " + sqle.getMessage();
                        throw new DataSourceException(message, (Throwable)sqle);
                    }
                    this.sdeSqlConstruct.setWhere(whereClause);
                }
            }
            return this.sdeSqlConstruct;
        }

        public SeFilter[] getSpatialFilters() throws DataSourceException {
            if (this.sdeSpatialFilters == null) {
                GeometryEncoderSDE geometryEncoder = new GeometryEncoderSDE(this.sdeLayer);
                try {
                    geometryEncoder.encode(this.getGeometryFilter());
                }
                catch (GeometryEncoderException e) {
                    throw new DataSourceException("Error parsing geometry filters: " + e.getMessage(), (Throwable)e);
                }
                this.sdeSpatialFilters = geometryEncoder.getSpatialFilters();
            }
            return this.sdeSpatialFilters;
        }

        public Filter getSqlFilter() {
            return this.sqlFilter == null ? Filter.NONE : this.sqlFilter;
        }

        public Filter getGeometryFilter() {
            return this.geometryFilter == null ? Filter.NONE : this.geometryFilter;
        }

        public Filter getUnsupportedFilter() {
            return this.unsupportedFilter == null ? Filter.NONE : this.unsupportedFilter;
        }
    }
}

