/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.pool.ArcSDEPooledConnection;
import org.geotools.data.Transaction;

class ArcTransactionState
implements Transaction.State {
    private static final Logger LOGGER = Logger.getLogger(ArcTransactionState.class.getPackage().getName());
    private ArcSDEPooledConnection connection;
    private ArcSDEDataStore dataStore;

    public ArcTransactionState(ArcSDEDataStore store) {
        this.dataStore = store;
    }

    public void commit() throws IOException {
        try {
            if (this.connection != null) {
                this.connection.commitTransaction();
            }
        }
        catch (SeException se) {
            LOGGER.log(Level.WARNING, se.getMessage(), se);
            throw new IOException(se.getMessage());
        }
    }

    public void rollback() throws IOException {
        try {
            if (this.connection != null) {
                this.connection.rollbackTransaction();
            }
        }
        catch (SeException se) {
            LOGGER.log(Level.WARNING, se.getMessage(), se);
            throw new IOException(se.getMessage());
        }
    }

    public void addAuthorization(String authId) {
    }

    public void setTransaction(Transaction transaction) {
        if (transaction == null && this.connection != null) {
            this.connection.close();
        } else if (transaction != null) {
            try {
                this.connection = this.dataStore.getConnectionPool().getConnection();
                this.connection.setTransactionAutoCommit(0);
                this.connection.startTransaction();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                throw new RuntimeException(e.getMessage());
            }
        } else {
            throw new RuntimeException("Unexpected state.");
        }
    }

    ArcSDEPooledConnection getConnection() {
        return this.connection;
    }
}

