/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SDEPoint;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeShape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.arcsde.data.GeometryBuildingException;
import org.geotools.data.DataSourceException;

public abstract class GeometryBuilder {
    private static final Logger LOGGER = Logger.getLogger(GeometryBuilder.class.getPackage().getName());
    private static final Map builders = new HashMap();
    private static final Map nullGeometries = new HashMap();
    protected GeometryFactory factory = new GeometryFactory();

    private GeometryBuilder() {
    }

    public Geometry construct(SeShape shape) throws SeException, DataSourceException {
        if (shape == null || shape.isNil()) {
            return this.getEmpty();
        }
        return this.newGeometry(shape.getAllCoords());
    }

    public SeShape constructShape(Geometry geometry, SeCoordinateReference seSrs) throws GeometryBuildingException {
        SeShape shape = null;
        try {
            shape = new SeShape(seSrs);
        }
        catch (SeException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            throw new GeometryBuildingException(ex.getSeError().getErrDesc() + ": " + geometry, ex);
        }
        if (geometry.isEmpty()) {
            return shape;
        }
        GeometryCollection gcol = null;
        if (geometry instanceof GeometryCollection) {
            gcol = (GeometryCollection)geometry;
        } else {
            Geometry[] geoms = new Geometry[]{geometry};
            gcol = new GeometryFactory().createGeometryCollection(geoms);
        }
        ArrayList<SDEPoint> allPoints = new ArrayList<SDEPoint>();
        int numParts = gcol.getNumGeometries();
        int[] partOffsets = new int[numParts];
        for (int currGeom = 0; currGeom < numParts; ++currGeom) {
            partOffsets[currGeom] = allPoints.size();
            Geometry geom = gcol.getGeometryN(currGeom);
            Coordinate[] coords = geom.getCoordinates();
            for (int i = 0; i < coords.length; ++i) {
                Coordinate c = coords[i];
                allPoints.add(new SDEPoint(c.x, c.y));
            }
        }
        SDEPoint[] points = new SDEPoint[allPoints.size()];
        allPoints.toArray(points);
        try {
            if (geometry instanceof Point || gcol instanceof MultiPoint) {
                shape.generatePoint(points.length, points);
            } else if (geometry instanceof LineString || geometry instanceof MultiLineString) {
                shape.generateLine(points.length, numParts, partOffsets, points);
            } else {
                shape.generatePolygon(points.length, numParts, partOffsets, points);
            }
        }
        catch (SeException e) {
            LOGGER.warning(e.getSeError().getErrDesc() + ":\nGEOM=" + geometry + "\nShape=" + shape + "\nCRS: " + seSrs);
            throw new GeometryBuildingException(e.getSeError().getErrDesc(), e);
        }
        return shape;
    }

    private double[][][] geometryToSdeCoords(Geometry jtsGeom) {
        int numSubParts = 1;
        GeometryCollection gcol = null;
        if (jtsGeom instanceof MultiPolygon) {
            gcol = (GeometryCollection)jtsGeom;
        } else {
            Geometry[] geoms = new Geometry[]{jtsGeom};
            gcol = new GeometryFactory().createGeometryCollection(geoms);
        }
        int numParts = gcol.getNumGeometries();
        double[][][] sdeCoords = new double[numParts][0][0];
        for (int i = 0; i < numParts; ++i) {
            Geometry geom = gcol.getGeometryN(i);
            numSubParts = geom instanceof Polygon ? ((Polygon)geom).getNumInteriorRing() + 1 : (geom instanceof GeometryCollection ? ((GeometryCollection)geom).getNumGeometries() : 1);
            sdeCoords[i] = new double[numSubParts][0];
            Coordinate[] partCoords = null;
            for (int j = 0; j < numSubParts; ++j) {
                partCoords = geom instanceof Polygon ? (j == 0 ? ((Polygon)geom).getExteriorRing().getCoordinates() : ((Polygon)geom).getInteriorRingN(j - 1).getCoordinates()) : (geom instanceof GeometryCollection ? ((GeometryCollection)geom).getGeometryN(j).getCoordinates() : geom.getCoordinates());
                sdeCoords[i][j] = this.toSdeCoords(partCoords);
            }
        }
        return sdeCoords;
    }

    private double[] toSdeCoords(Coordinate[] coords) {
        int nCoords = coords.length;
        double[] sdeCoords = new double[2 * nCoords];
        int i = 0;
        int j = 1;
        while (i < nCoords) {
            Coordinate c = coords[i];
            sdeCoords[j - 1] = c.x;
            sdeCoords[j] = c.y;
            ++i;
            j += 2;
        }
        return sdeCoords;
    }

    protected abstract Geometry newGeometry(double[][][] var1) throws DataSourceException;

    protected Geometry getEmpty() {
        throw new UnsupportedOperationException("this method sholdn't be called directly, it's intended pourpose is to be implemented by subclasses so they provide propper  null Geometries");
    }

    protected Coordinate[] toCoords(double[] coordList) {
        int nCoords = coordList.length / 2;
        Coordinate[] coords = new Coordinate[nCoords];
        int i = 0;
        int j = 0;
        while (i < nCoords) {
            coords[i] = new Coordinate(coordList[j], coordList[++j]);
            ++i;
            ++j;
        }
        return coords;
    }

    protected SDEPoint[] toPointsArray(Coordinate[] coords) {
        int nCoords = coords.length;
        SDEPoint[] points = new SDEPoint[nCoords];
        for (int i = 0; i < nCoords; ++i) {
            Coordinate c = coords[i];
            points[i] = new SDEPoint(c.x, c.y);
        }
        return points;
    }

    public static GeometryBuilder builderFor(Class jtsGeometryClass) throws IllegalArgumentException {
        GeometryBuilder builder = (GeometryBuilder)builders.get(jtsGeometryClass);
        if (builder == null) {
            String msg = "no geometry builder is defined to construct " + jtsGeometryClass + " instances.";
            throw new IllegalArgumentException(msg);
        }
        return builder;
    }

    public static Geometry defaultValueFor(Class geoClass) {
        if (geoClass == null) {
            throw new NullPointerException("got null geometry class");
        }
        Geometry emptyGeom = (Geometry)nullGeometries.get(geoClass);
        return emptyGeom;
    }

    static {
        builders.put(Geometry.class, GenericGeometryBuilder.getInstance());
        builders.put(Point.class, PointBuilder.getInstance());
        builders.put(MultiPoint.class, MultiPointBuilder.getInstance());
        builders.put(LineString.class, LineStringBuilder.getInstance());
        builders.put(MultiLineString.class, MultiLineStringBuilder.getInstance());
        builders.put(Polygon.class, PolygonBuilder.getInstance());
        builders.put(MultiPolygon.class, MultiPolygonBuilder.getInstance());
        nullGeometries.put(Geometry.class, new GenericGeometryBuilder().getEmpty());
        nullGeometries.put(Point.class, new PointBuilder().getEmpty());
        nullGeometries.put(MultiPoint.class, new MultiPointBuilder().getEmpty());
        nullGeometries.put(LineString.class, new LineStringBuilder().getEmpty());
        nullGeometries.put(MultiLineString.class, new MultiLineStringBuilder().getEmpty());
        nullGeometries.put(Polygon.class, new PolygonBuilder().getEmpty());
        nullGeometries.put(MultiPolygon.class, new MultiPolygonBuilder().getEmpty());
    }

    private static class MultiPolygonBuilder
    extends PolygonBuilder {
        private static Geometry EMPTY;
        private static final GeometryBuilder instance;

        private MultiPolygonBuilder() {
        }

        public static GeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createMultiPolygon(null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords) throws DataSourceException {
            Polygon[] polys = null;
            int numPolys = coords.length;
            polys = new Polygon[numPolys];
            for (int i = 0; i < numPolys; ++i) {
                try {
                    polys[i] = this.buildPolygon(coords[i]);
                    continue;
                }
                catch (Exception ex) {
                    throw new DataSourceException(ex.getMessage(), (Throwable)ex);
                }
            }
            MultiPolygon multiPoly = this.factory.createMultiPolygon(polys);
            return multiPoly;
        }

        private Polygon buildPolygon(double[][] parts) {
            Polygon p = null;
            double[] linearCoordArray = parts[0];
            int nHoles = parts.length - 1;
            LinearRing shell = this.factory.createLinearRing(this.toCoords(linearCoordArray));
            LinearRing[] holes = new LinearRing[nHoles];
            if (nHoles > 0) {
                for (int i = 0; i < nHoles; ++i) {
                    linearCoordArray = parts[i + 1];
                    holes[i] = this.factory.createLinearRing(this.toCoords(linearCoordArray));
                }
            }
            p = this.factory.createPolygon(shell, holes);
            return p;
        }

        static {
            instance = new MultiPolygonBuilder();
        }
    }

    private static class PolygonBuilder
    extends GeometryBuilder {
        private static Geometry EMPTY;
        private static final GeometryBuilder instance;

        private PolygonBuilder() {
        }

        public static GeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createPolygon(null, null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords) throws DataSourceException {
            return this.buildPolygon(coords);
        }

        protected Polygon buildPolygon(double[][][] parts) {
            Polygon p = null;
            double[] linearCoordArray = parts[0][0];
            int nHoles = parts.length - 1;
            LinearRing shell = this.factory.createLinearRing(this.toCoords(linearCoordArray));
            LinearRing[] holes = new LinearRing[nHoles];
            if (nHoles > 0) {
                for (int i = 0; i < nHoles; ++i) {
                    linearCoordArray = parts[i + 1][0];
                    holes[i] = this.factory.createLinearRing(this.toCoords(linearCoordArray));
                }
            }
            p = this.factory.createPolygon(shell, holes);
            return p;
        }

        static {
            instance = new PolygonBuilder();
        }
    }

    private static class MultiLineStringBuilder
    extends LineStringBuilder {
        private static Geometry EMPTY;
        private static final GeometryBuilder instance;

        private MultiLineStringBuilder() {
        }

        public static GeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createMultiLineString(null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords) throws DataSourceException {
            MultiLineString mls = null;
            LineString[] lineStrings = null;
            int nLines = coords.length;
            lineStrings = new LineString[nLines];
            for (int i = 0; i < nLines; ++i) {
                lineStrings[i] = this.constructLineString(coords[i][0]);
            }
            mls = this.factory.createMultiLineString(lineStrings);
            return mls;
        }

        static {
            instance = new MultiLineStringBuilder();
        }
    }

    private static class LineStringBuilder
    extends GeometryBuilder {
        private static Geometry EMPTY;
        private static int numParts;
        private static int[] partOffsets;
        private static final GeometryBuilder instance;

        private LineStringBuilder() {
        }

        public static GeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createLineString((Coordinate[])null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords) throws DataSourceException {
            return this.constructLineString(coords[0][0]);
        }

        protected LineString constructLineString(double[] linearCoords) throws DataSourceException {
            LineString ls = null;
            Coordinate[] coords = this.toCoords(linearCoords);
            ls = this.factory.createLineString(coords);
            return ls;
        }

        static {
            numParts = 1;
            partOffsets = new int[]{0};
            instance = new LineStringBuilder();
        }
    }

    private static class MultiPointBuilder
    extends GeometryBuilder {
        private static Geometry EMPTY;
        private static final GeometryBuilder instance;

        private MultiPointBuilder() {
        }

        public static GeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createMultiPoint((Point[])null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords) throws DataSourceException {
            int nPoints = coords.length;
            Coordinate[] points = new Coordinate[nPoints];
            for (int i = 0; i < nPoints; ++i) {
                double x = coords[i][0][0];
                double y = coords[i][0][1];
                points[i] = new Coordinate(x, y);
            }
            return this.factory.createMultiPoint(points);
        }

        static {
            instance = new MultiPointBuilder();
        }
    }

    private static class PointBuilder
    extends GeometryBuilder {
        private static Geometry EMPTY;
        private static final GeometryBuilder instance;

        private PointBuilder() {
        }

        public static GeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createPoint((Coordinate)null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords) throws DataSourceException {
            return this.factory.createPoint(new Coordinate(coords[0][0][0], coords[0][0][1]));
        }

        static {
            instance = new PointBuilder();
        }
    }

    private static class GenericGeometryBuilder
    extends GeometryBuilder {
        private static final GeometryBuilder instance = new GenericGeometryBuilder();

        private GenericGeometryBuilder() {
        }

        public static GeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            return new PointBuilder().getEmpty();
        }

        public Geometry construct(SeShape shape) throws SeException, DataSourceException {
            int seShapeType = shape.getType();
            Class realGeomClass = ArcSDEAdapter.getGeometryType(seShapeType);
            GeometryBuilder realBuilder = GenericGeometryBuilder.builderFor(realGeomClass);
            return realBuilder.construct(shape);
        }

        protected Geometry newGeometry(double[][][] coords) throws DataSourceException {
            throw new UnsupportedOperationException("This method should not be called for this builder. It should be mapped to the one capable of constructing the actual geometry type");
        }
    }
}

