/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.filter;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeFilter;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeShapeFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.arcsde.data.GeometryBuilder;
import org.geotools.arcsde.data.GeometryBuildingException;
import org.geotools.arcsde.filter.GeometryEncoderException;
import org.geotools.data.DataSourceException;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;

public class GeometryEncoderSDE
implements FilterVisitor {
    private static Logger log = Logger.getLogger("org.geotools.filter");
    private static FilterCapabilities capabilities = new FilterCapabilities();
    private List sdeSpatialFilters = null;
    private SeLayer sdeLayer;

    public GeometryEncoderSDE() {
    }

    public GeometryEncoderSDE(SeLayer layer) {
        this.sdeLayer = layer;
    }

    public void setLayer(SeLayer layer) {
        this.sdeLayer = layer;
    }

    public static FilterCapabilities getCapabilities() {
        return capabilities;
    }

    public SeFilter[] getSpatialFilters() {
        SeFilter[] filters = new SeFilter[this.sdeSpatialFilters.size()];
        return this.sdeSpatialFilters.toArray(filters);
    }

    private String getLayerName() throws SeException {
        if (this.sdeLayer == null) {
            throw new IllegalStateException("SDE layer has not been set");
        }
        return this.sdeLayer.getQualifiedName();
    }

    public void encode(Filter filter) throws GeometryEncoderException {
        this.sdeSpatialFilters = new ArrayList();
        if (Filter.NONE.equals(filter)) {
            return;
        }
        if (!capabilities.fullySupports(filter)) {
            throw new GeometryEncoderException("Filter type not supported");
        }
        filter.accept((FilterVisitor)this);
    }

    public void visit(GeometryFilter filter) {
        try {
            switch (filter.getFilterType()) {
                case 4: {
                    this.addSpatialFilter(filter, SeFilter.METHOD_ENVP, true);
                    break;
                }
                case 11: {
                    this.addSpatialFilter(filter, SeFilter.METHOD_PC, true);
                    break;
                }
                case 9: {
                    this.addSpatialFilter(filter, SeFilter.METHOD_LCROSS_OR_CP, true);
                    break;
                }
                case 6: {
                    this.addSpatialFilter(filter, SeFilter.METHOD_II_OR_ET, false);
                    break;
                }
                case 5: {
                    this.addSpatialFilter(filter, SeFilter.METHOD_IDENTICAL, true);
                    break;
                }
                case 7: {
                    this.addSpatialFilter(filter, SeFilter.METHOD_II_OR_ET, true);
                    break;
                }
                case 12: {
                    this.addSpatialFilter(filter, SeFilter.METHOD_II, true);
                    this.addSpatialFilter(filter, SeFilter.METHOD_PC, false);
                    this.addSpatialFilter(filter, SeFilter.METHOD_SC, false);
                    break;
                }
                case 10: {
                    this.addSpatialFilter(filter, SeFilter.METHOD_SC, true);
                    break;
                }
                default: {
                    String msg = "unsupported filter type";
                    log.warning(msg);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error building SeFilter", e);
        }
    }

    public void visit(FidFilter filter) {
    }

    /*
     * WARNING - void declaration
     */
    private void addSpatialFilter(GeometryFilter filter, int sdeMethod, boolean truth) throws SeException, DataSourceException, GeometryBuildingException {
        SeShape filterShape;
        void var5_8;
        LiteralExpression geomExpr;
        Expression left = filter.getLeftGeometry();
        Expression right = filter.getRightGeometry();
        if ((left instanceof AttributeExpression || left == null) && right instanceof LiteralExpression) {
            AttributeExpression attExpr = (AttributeExpression)left;
            geomExpr = (LiteralExpression)right;
        } else if ((right instanceof AttributeExpression || right == null) && left instanceof LiteralExpression) {
            AttributeExpression attExpr = (AttributeExpression)right;
            geomExpr = (LiteralExpression)left;
        } else {
            String err = "SDE currently supports one geometry and one attribute expr.  You gave: " + left + ", " + right;
            throw new DataSourceException(err);
        }
        String spatialCol = this.sdeLayer.getSpatialColumn();
        Geometry geom = (Geometry)var5_8.getLiteral();
        GeometryBuilder gb = GeometryBuilder.builderFor(Polygon.class);
        SeExtent seExtent = this.sdeLayer.getExtent();
        SeShape extent = new SeShape(this.sdeLayer.getCoordRef());
        extent.generateRectangle(seExtent);
        Geometry layerEnv = gb.construct(extent);
        geom = geom.intersection(layerEnv);
        if (geom.getClass() == GeometryCollection.class) {
            filterShape = new SeShape(this.sdeLayer.getCoordRef());
        } else {
            gb = GeometryBuilder.builderFor(geom.getClass());
            filterShape = gb.constructShape(geom, this.sdeLayer.getCoordRef());
        }
        SeShapeFilter shapeFilter = new SeShapeFilter(this.getLayerName(), this.sdeLayer.getSpatialColumn(), filterShape, sdeMethod, truth);
        this.sdeSpatialFilters.add(shapeFilter);
    }

    public void visit(Filter filter) {
    }

    public void visit(BetweenFilter filter) {
    }

    public void visit(CompareFilter filter) {
    }

    public void visit(LikeFilter filter) {
    }

    public void visit(LogicFilter filter) {
        log.finer("exporting LogicFilter");
    }

    public void visit(NullFilter filter) {
    }

    public void visit(AttributeExpression expression) {
    }

    public void visit(Expression expression) {
    }

    public void visit(LiteralExpression expression) {
    }

    public void visit(MathExpression expression) {
    }

    public void visit(FunctionExpression expression) {
    }

    static {
        capabilities.addType((short)4);
        capabilities.addType((short)11);
        capabilities.addType((short)9);
        capabilities.addType((short)6);
        capabilities.addType((short)5);
        capabilities.addType((short)7);
        capabilities.addType((short)12);
        capabilities.addType((short)10);
    }
}

