/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.filter;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeLayer;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;

public class SQLEncoderSDE
extends SQLEncoder
implements FilterVisitor {
    private static Logger LOGGER = Logger.getLogger("org.geotools.filter");
    private SeLayer sdeLayer;
    private String rowIdColumn;

    public SQLEncoderSDE() {
    }

    public SQLEncoderSDE(SeLayer layer) {
        this(layer, layer.getSpatialColumn());
    }

    public SQLEncoderSDE(SeLayer layer, String rowIdColumn) {
        this.sdeLayer = layer;
        this.rowIdColumn = rowIdColumn;
    }

    public void visit(AttributeExpression expression) throws RuntimeException {
        try {
            this.out.write(this.sdeLayer.getQualifiedName());
            this.out.write(46);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing attribute exp", ioe);
        }
        catch (SeException see) {
            throw new RuntimeException("SDE problems writing attribute exp", see);
        }
        super.visit(expression);
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addType(0x3800000L);
        capabilities.addType(0x3F0000L);
        capabilities.addType(8192L);
        capabilities.addType(4096L);
        capabilities.addType(0x400000L);
        capabilities.addType(0x40000000L);
        capabilities.addType(Integer.MIN_VALUE);
        capabilities.addType(2048L);
        return capabilities;
    }

    public void setLayer(SeLayer layer) {
        this.sdeLayer = layer;
    }

    public void encode(Writer out, Filter filter) throws SQLEncoderException {
        if (!this.getCapabilities().fullySupports(filter)) {
            throw new SQLEncoderException("Filter type not supported");
        }
        this.out = out;
        filter.accept((FilterVisitor)this);
    }

    public void visit(FidFilter filter) {
        long[] fids = ArcSDEAdapter.getNumericFids(filter.getFids());
        int nFids = fids.length;
        if (nFids == 0) {
            return;
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.rowIdColumn + " IN(");
            for (int i = 0; i < nFids; ++i) {
                sb.append(fids[i]);
                if (i < nFids - 1) {
                    sb.append(", ");
                }
                if (i != 999) continue;
                sb.deleteCharAt(sb.length() - 1);
                sb.deleteCharAt(sb.length() - 1);
                sb.append(") OR " + this.rowIdColumn + " IN(");
            }
            sb.append(')');
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("added fid filter: " + sb.toString());
            }
            this.out.write(sb.toString());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

