/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import com.esri.sde.sdk.client.SDEPoint;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeRasterAttr;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.geotools.arcsde.gce.ArcSDEPyramidLevel;
import org.geotools.arcsde.gce.RasterQueryInfo;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ArcSDEPyramid {
    ArrayList pyramidList;
    int tileWidth;
    int tileHeight;

    public ArcSDEPyramid(SeRasterAttr rasterAttributes, CoordinateReferenceSystem crs) throws DataSourceException {
        try {
            int numLevels = rasterAttributes.getMaxLevel() + 1;
            this.pyramidList = new ArrayList(numLevels);
            this.tileWidth = rasterAttributes.getTileWidth();
            this.tileHeight = rasterAttributes.getTileHeight();
            for (int i = 0; i < numLevels; ++i) {
                if (i == 1 && rasterAttributes.skipLevelOne()) continue;
                ReferencedEnvelope levelExtent = new ReferencedEnvelope(crs);
                SeExtent slExtent = rasterAttributes.getExtentByLevel(i);
                levelExtent.expandToInclude(slExtent.getMinX(), slExtent.getMinY());
                levelExtent.expandToInclude(slExtent.getMaxX(), slExtent.getMaxY());
                int imageWidth = rasterAttributes.getImageWidthByLevel(i);
                int imageHeight = rasterAttributes.getImageHeightByLevel(i);
                Dimension size = new Dimension(imageWidth, imageHeight);
                this.addPyramidLevel(i, rasterAttributes.getExtentByLevel(i), crs, rasterAttributes.getImageOffsetByLevel(i), rasterAttributes.getTilesPerRowByLevel(i), rasterAttributes.getTilesPerColByLevel(i), size);
            }
        }
        catch (SeException se) {
            throw new DataSourceException((Throwable)se);
        }
    }

    public Dimension getTileDimension() {
        return new Dimension(this.tileWidth, this.tileHeight);
    }

    public ArcSDEPyramidLevel getPyramidLevel(int level) {
        return (ArcSDEPyramidLevel)this.pyramidList.get(level);
    }

    public int getNumLevels() {
        return this.pyramidList.size();
    }

    public int pickOptimalRasterLevel(ReferencedEnvelope requestEnvelope, Rectangle pixelDimensions) throws DataSourceException {
        double reqXRes = requestEnvelope.getWidth() / (double)pixelDimensions.width;
        double reqYRes = requestEnvelope.getHeight() / (double)pixelDimensions.height;
        ArcSDEPyramidLevel[] pyramidInfo = this.pyramidList.toArray(new ArcSDEPyramidLevel[this.pyramidList.size()]);
        int targetLevel = 0;
        int i = 0;
        while (i < pyramidInfo.length && reqXRes >= pyramidInfo[i].getXRes() && reqYRes >= pyramidInfo[i].getYRes()) {
            targetLevel = i++;
        }
        return targetLevel;
    }

    public RasterQueryInfo fitExtentToRasterPixelGrid(ReferencedEnvelope reqEnv, int rasterLvl) {
        RasterQueryInfo ret = new RasterQueryInfo();
        ArcSDEPyramidLevel pLevel = this.getPyramidLevel(rasterLvl);
        double delta = reqEnv.getMinX() - pLevel.getEnvelope().getMinX();
        int xMinPixel = (int)Math.floor(delta / pLevel.getXRes());
        delta = reqEnv.getMaxX() - pLevel.getEnvelope().getMinX();
        int xMaxPixel = (int)Math.ceil(delta / pLevel.getXRes());
        delta = pLevel.getEnvelope().getMaxY() - reqEnv.getMaxY();
        int yMinPixel = (int)Math.floor(delta / pLevel.getYRes());
        delta = pLevel.getEnvelope().getMaxY() - reqEnv.getMinY();
        int yMaxPixel = (int)Math.ceil(delta / pLevel.getYRes());
        int widthPixel = xMaxPixel - xMinPixel;
        int heightPixel = yMaxPixel - yMinPixel;
        double xMinGeo = pLevel.getEnvelope().getMinX() + pLevel.getXRes() * (double)xMinPixel;
        double yMinGeo = pLevel.getEnvelope().getMaxY() - pLevel.getYRes() * (double)(yMinPixel + heightPixel);
        double widthGeo = pLevel.getXRes() * (double)widthPixel;
        double heightGeo = pLevel.getYRes() * (double)heightPixel;
        ret.envelope = new ReferencedEnvelope(xMinGeo, xMinGeo + widthGeo, yMinGeo, yMinGeo + heightGeo, reqEnv.getCoordinateReferenceSystem());
        ret.image = new Rectangle(xMinPixel, yMinPixel, widthPixel, heightPixel);
        return ret;
    }

    public void addPyramidLevel(int level, SeExtent extent, CoordinateReferenceSystem crs, SDEPoint offset, int xTiles, int yTiles, Dimension imageSize) {
        this.pyramidList.add(level, new ArcSDEPyramidLevel(level, extent, crs, offset, xTiles, yTiles, imageSize));
        Collections.sort(this.pyramidList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ArcSDEPyramidLevel p0 = (ArcSDEPyramidLevel)arg0;
                ArcSDEPyramidLevel p1 = (ArcSDEPyramidLevel)arg1;
                return p0.getLevel() - p1.getLevel();
            }
        });
    }

    public ArcSDEPyramid(int tileWidth, int tileHeight, int numLayers) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.pyramidList = new ArrayList(numLayers);
    }
}

