/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import com.esri.sde.sdk.client.SDEPoint;
import com.esri.sde.sdk.client.SeExtent;
import java.awt.Dimension;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ArcSDEPyramidLevel {
    private int pyramidLevel;
    private int xOffset;
    private int yOffset;
    private int xTiles;
    private int yTiles;
    private double xRes;
    private double yRes;
    private ReferencedEnvelope envelope;
    public Dimension size;

    public ArcSDEPyramidLevel(int level, SeExtent extent, CoordinateReferenceSystem crs, SDEPoint offset, int xTiles, int yTiles, Dimension size) {
        this.pyramidLevel = level;
        this.xRes = (extent.getMaxX() - extent.getMinX()) / (double)size.width;
        this.yRes = (extent.getMaxY() - extent.getMinY()) / (double)size.height;
        this.envelope = new ReferencedEnvelope(extent.getMinX(), extent.getMaxX(), extent.getMinY(), extent.getMaxY(), crs);
        if (offset != null) {
            this.xOffset = (int)offset.getX();
            this.yOffset = (int)offset.getY();
        }
        this.xTiles = xTiles;
        this.yTiles = yTiles;
        this.size = size;
    }

    public int getLevel() {
        return this.pyramidLevel;
    }

    public double getXRes() {
        return this.xRes;
    }

    public double getYRes() {
        return this.yRes;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public int getNumTilesWide() {
        return this.xTiles;
    }

    public int getNumTilesHigh() {
        return this.yTiles;
    }

    public ReferencedEnvelope getEnvelope() {
        return new ReferencedEnvelope(this.envelope);
    }

    public String toString() {
        return "[level: " + this.pyramidLevel + "  xRes: " + this.xRes + "  yRes: " + this.yRes + "  xOffset: " + this.xOffset + "  yOffset: " + this.yOffset + "  extent: " + this.envelope + "  tilesWide: " + this.xTiles + "  tilesHigh: " + this.yTiles + "]";
    }
}

