/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.gce.ArcSDERasterGridCoverage2DReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.image.imageio.GeoToolsWriteParams;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public class ArcSDERasterFormat
extends AbstractGridFormat
implements Format {
    protected static final Logger LOGGER = Logger.getLogger(ArcSDERasterFormat.class.getPackage().getName());

    public ArcSDERasterFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ArcSDE Raster");
        info.put("description", "ArcSDE Raster Format");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "0.1-alpha");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
    }

    public GridCoverageReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageReader getReader(Object source, Hints hints) {
        try {
            return new ArcSDERasterGridCoverage2DReader(source, hints);
        }
        catch (DataSourceException dse) {
            LOGGER.log(Level.SEVERE, "Unable to creata ArcSDERasterReader for " + source + ".", dse);
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean accepts(Object input) {
        StringBuffer url;
        if (input instanceof File) {
            url = new StringBuffer(((File)input).getPath());
        } else if (input instanceof String) {
            url = new StringBuffer((String)input);
        } else {
            return false;
        }
        try {
            void var2_2;
            ArcSDERasterGridCoverage2DReader.sdeURLToConnectionConfig((StringBuffer)var2_2);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getName() {
        return (String)this.mInfo.get("name");
    }

    public String getDescription() {
        return (String)this.mInfo.get("description");
    }

    public String getVendor() {
        return (String)this.mInfo.get("vendor");
    }

    public String getDocURL() {
        return (String)this.mInfo.get("docURL");
    }

    public String getVersion() {
        return (String)this.mInfo.get("version");
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("ArcSDE Rasters are read only for now.");
    }
}

