/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeRaster;
import com.esri.sde.sdk.client.SeRasterAttr;
import com.esri.sde.sdk.client.SeRasterBand;
import com.esri.sde.sdk.client.SeRasterColumn;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.pe.PeFactory;
import com.esri.sde.sdk.pe.PeProjectedCS;
import com.esri.sde.sdk.pe.PeProjectionException;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import org.geotools.arcsde.gce.ArcSDEPyramid;
import org.geotools.arcsde.gce.ArcSDEPyramidLevel;
import org.geotools.arcsde.gce.ArcSDERasterFormat;
import org.geotools.arcsde.gce.RasterQueryInfo;
import org.geotools.arcsde.gce.band.ArcSDERasterBandCopier;
import org.geotools.arcsde.gce.imageio.ArcSDERasterImageReadParam;
import org.geotools.arcsde.gce.imageio.ArcSDERasterReader;
import org.geotools.arcsde.gce.imageio.ArcSDERasterReaderSpi;
import org.geotools.arcsde.pool.ArcSDEConnectionConfig;
import org.geotools.arcsde.pool.ArcSDEConnectionPool;
import org.geotools.arcsde.pool.ArcSDEConnectionPoolFactory;
import org.geotools.arcsde.pool.ArcSDEPooledConnection;
import org.geotools.arcsde.pool.UnavailableArcSDEConnectionException;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataSourceException;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.util.NumberRange;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.spatialschema.geometry.Envelope;

public final class ArcSDERasterGridCoverage2DReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = Logger.getLogger(ArcSDERasterGridCoverage2DReader.class.getPackage().getName());
    private ArcSDEConnectionPool connectionPool = null;
    private String rasterTable = null;
    private String[] rasterColumns;
    private SeRasterAttr rasterAttributes = null;
    private int epsgCode = -1;
    private ArcSDEPyramid pyramidInfo;
    private int tileWidth;
    private int tileHeight;
    private ArcSDERasterReader imageIOReader;
    private HashMap bandInfo;
    private GridSampleDimension[] gridBands;
    private int bufferedImageType;
    private Point _levelZeroPRP;

    public ArcSDERasterGridCoverage2DReader(Object input) throws DataSourceException {
        this(input, null);
    }

    public ArcSDERasterGridCoverage2DReader(Object input, Hints hints) throws DataSourceException {
        if (hints != null) {
            this.hints.add((RenderingHints)hints);
        }
        this.setupConnectionPool(input);
        this.calculateCoordinateReferenceSystem();
        this.pyramidInfo = new ArcSDEPyramid(this.rasterAttributes, this.crs);
        if (this._levelZeroPRP != null) {
            this._levelZeroPRP = new Point(this._levelZeroPRP.x * this.pyramidInfo.tileWidth, this._levelZeroPRP.y * this.pyramidInfo.tileHeight);
        }
        this.calculateBandDependentInfo();
        this.setupCoverageMetadata();
        this.setupImageIOReader();
        LOGGER.info("ArcSDE raster " + this.coverageName + " based on table " + this.rasterTable + " has been configured.");
    }

    public Format getFormat() {
        return new ArcSDERasterFormat();
    }

    public GridCoverage read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        GeneralEnvelope readEnvelope = null;
        Rectangle requestedDim = null;
        if (params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                Parameter param = (Parameter)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    readEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                    requestedDim = gg.getGridRange2D().getBounds();
                    continue;
                }
                LOGGER.warning("discarding parameter with name " + name);
            }
        }
        if (readEnvelope == null || requestedDim == null) {
            throw new IllegalArgumentException("You must call ArcSDERasterReader.read() with a GPV[] including a Parameter for READ_GRIDGEOMETRY2D.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ArcSDE raster image requested: [" + readEnvelope + ", " + requestedDim + "]");
        }
        return this.createCoverage(readEnvelope, requestedDim, null);
    }

    private GridCoverage createCoverage(GeneralEnvelope requestedEnvelope, Rectangle requestedDim, Integer forcedLevel) throws IOException {
        ArcSDEPooledConnection scon = null;
        try {
            LOGGER.info("Creating coverage out of request: imagesize -- " + requestedDim + "  envelope -- " + requestedEnvelope);
            ReferencedEnvelope reqEnv = new ReferencedEnvelope((Envelope)requestedEnvelope, requestedEnvelope.getCoordinateReferenceSystem());
            int level = 0;
            level = forcedLevel != null ? forcedLevel.intValue() : this.pyramidInfo.pickOptimalRasterLevel(reqEnv, requestedDim);
            ArcSDEPyramidLevel optimalLevel = this.pyramidInfo.getPyramidLevel(level);
            BufferedImage outputImage = null;
            ReferencedEnvelope outputImageEnvelope = null;
            if (!optimalLevel.getEnvelope().intersects((com.vividsolutions.jts.geom.Envelope)reqEnv)) {
                outputImage = this.createInitialBufferedImage(requestedDim.width, requestedDim.height);
                outputImageEnvelope = new ReferencedEnvelope(reqEnv);
            } else {
                RasterQueryInfo rasterGridInfo = this.pyramidInfo.fitExtentToRasterPixelGrid(reqEnv, level);
                scon = this.connectionPool.getConnection();
                ArcSDERasterImageReadParam rParam = new ArcSDERasterImageReadParam();
                rParam.setConnection(scon);
                outputImage = this.createInitialBufferedImage(rasterGridInfo.image.width, rasterGridInfo.image.height);
                rParam.setDestination(outputImage);
                int minImageX = Math.max(rasterGridInfo.image.x, 0);
                int maxImageX = Math.min(rasterGridInfo.image.x + rasterGridInfo.image.width, this.pyramidInfo.getPyramidLevel((int)level).size.width);
                int minImageY = Math.max(rasterGridInfo.image.y, 0);
                int maxImageY = Math.min(rasterGridInfo.image.y + rasterGridInfo.image.height, this.pyramidInfo.getPyramidLevel((int)level).size.height);
                Rectangle sourceRegion = new Rectangle(minImageX, minImageY, maxImageX - minImageX, maxImageY - minImageY);
                if (level == 0 && this._levelZeroPRP != null) {
                    if (maxImageY > this._levelZeroPRP.y && minImageY < this._levelZeroPRP.y || maxImageX > this._levelZeroPRP.x && minImageX < this._levelZeroPRP.x) {
                        LOGGER.warning("Using pyramid level 1 to render this request, as the data is unavailable at a negatively indexed tile.");
                        GridCoverage gridCoverage = this.createCoverage(requestedEnvelope, requestedDim, new Integer(1));
                        return gridCoverage;
                    }
                    if (maxImageY > this._levelZeroPRP.y && maxImageX > this._levelZeroPRP.x) {
                        sourceRegion.translate(this._levelZeroPRP.x * -1, this._levelZeroPRP.y * -1);
                    } else {
                        LOGGER.warning("Using pyramid level 1 to render this request, as the data is unavailable at a negatively indexed tile.");
                        GridCoverage gridCoverage = this.createCoverage(requestedEnvelope, requestedDim, new Integer(1));
                        return gridCoverage;
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Expanded request to cover source region [" + sourceRegion + "] in level " + level + ".  Spatial extent of this source region is " + rasterGridInfo.envelope);
                }
                rParam.setSourceRegion(sourceRegion);
                if (rasterGridInfo.image.x < 0 || rasterGridInfo.image.y < 0) {
                    Point destOffset = new Point(0, 0);
                    if (rasterGridInfo.image.x < 0) {
                        destOffset.x = rasterGridInfo.image.x * -1;
                    }
                    if (rasterGridInfo.image.y < 0) {
                        destOffset.y = rasterGridInfo.image.y * -1;
                    }
                    rParam.setDestination(outputImage.getSubimage(destOffset.x, destOffset.y, outputImage.getWidth() - destOffset.x, outputImage.getHeight() - destOffset.y));
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("source region is offset by " + destOffset + " into the " + outputImage.getWidth() + "x" + outputImage.getHeight() + " output image.");
                    }
                }
                outputImageEnvelope = new ReferencedEnvelope(rasterGridInfo.envelope);
                SeRasterBand[] seBands = this.rasterAttributes.getBands();
                int[] bands = new int[Math.min(3, seBands.length)];
                HashMap<Integer, Integer> bandMapper = new HashMap<Integer, Integer>();
                for (int i = 0; i < bands.length; ++i) {
                    bands[i] = i + 1;
                    bandMapper.put(new Integer((int)seBands[i].getId().longValue()), new Integer(i));
                }
                rParam.setSourceBands(bands);
                rParam.setBandMapper(bandMapper);
                ImageLayout layout = new ImageLayout();
                layout.setTileWidth(sourceRegion.width);
                layout.setTileHeight(sourceRegion.height);
                ParameterBlock pb = new ParameterBlock();
                pb.add(new Object());
                pb.add(new Integer(level));
                pb.add(Boolean.FALSE);
                pb.add(Boolean.FALSE);
                pb.add(Boolean.FALSE);
                pb.add(null);
                pb.add(null);
                pb.add(rParam);
                pb.add(this.imageIOReader);
                JAI.create((String)"ImageRead", (ParameterBlock)pb, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout)).getData();
            }
            GridCoverage2D gridCoverage2D = coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)outputImage, (Envelope)new GeneralEnvelope((Envelope)outputImageEnvelope), this.gridBands, null, null);
            return gridCoverage2D;
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            throw new DataSourceException((Throwable)e);
        }
        catch (SeException se) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, se.getSeError().getErrDesc(), se);
            }
            throw new DataSourceException((Throwable)se);
        }
        catch (UnavailableArcSDEConnectionException uce) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, uce.getLocalizedMessage(), uce);
            }
            throw new DataSourceException((Throwable)uce);
        }
        finally {
            if (scon != null) {
                scon.close();
            }
        }
    }

    static ArcSDEConnectionConfig sdeURLToConnectionConfig(StringBuffer sdeUrl) {
        String sdeHost;
        int sdePort;
        if (sdeUrl.indexOf("sde:/") == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName -- Got " + sdeUrl);
        }
        if (sdeUrl.indexOf("sde://") == -1) {
            sdeUrl.delete(0, 5);
        } else {
            sdeUrl.delete(0, 6);
        }
        int idx = sdeUrl.indexOf(":");
        if (idx == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
        }
        String sdeUser = sdeUrl.substring(0, idx).toString();
        sdeUrl.delete(0, idx);
        idx = sdeUrl.indexOf("@");
        if (idx == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
        }
        String sdePass = sdeUrl.substring(1, idx).toString();
        sdeUrl.delete(0, idx);
        idx = sdeUrl.indexOf(":");
        if (idx == -1) {
            sdePort = 5151;
            idx = sdeUrl.indexOf("/");
            if (idx == -1) {
                throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
            }
            sdeHost = sdeUrl.substring(1, idx).toString();
            sdeUrl.delete(0, idx);
        } else {
            sdeHost = sdeUrl.substring(1, idx).toString();
            sdeUrl.delete(0, idx);
            idx = sdeUrl.indexOf("/");
            if (idx == -1) {
                throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
            }
            sdePort = Integer.parseInt(sdeUrl.substring(1, idx).toString());
            sdeUrl.delete(0, idx);
        }
        idx = sdeUrl.indexOf("#");
        if (idx == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
        }
        String sdeDBName = sdeUrl.substring(1, idx).toString();
        sdeUrl.delete(0, idx);
        return new ArcSDEConnectionConfig("arcsde", sdeHost, sdePort + "", sdeDBName, sdeUser, sdePass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void calculateCoordinateReferenceSystem() throws DataSourceException {
        if (this.rasterAttributes == null) {
            throw new DataSourceException("Raster Attributes are null, can't calculated CRS info.");
        }
        ArcSDEPooledConnection con = null;
        try {
            try {
                con = this.connectionPool.getConnection();
                SeRasterColumn rCol = new SeRasterColumn((SeConnection)con, this.rasterAttributes.getRasterColumnId());
                PeProjectedCS pcs = new PeProjectedCS(rCol.getCoordRef().getProjectionDescription());
                this.epsgCode = -1;
                int[] projcs = PeFactory.projcsCodelist();
                for (int i = 0; i < projcs.length; ++i) {
                    try {
                        if (!PeFactory.projcs((int)projcs[i]).getName().trim().equals(pcs.getName())) continue;
                        this.epsgCode = projcs[i];
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (this.epsgCode == -1) {
                    LOGGER.warning("Couldn't determine EPSG code for this raster.  Using SDE's WKT-like coordSysDescription() instead.");
                    this.crs = CRS.parseWKT((String)rCol.getCoordRef().getCoordSysDescription());
                } else {
                    this.crs = CRS.decode((String)("EPSG:" + this.epsgCode));
                }
                SeExtent sdeExtent = this.rasterAttributes.getExtent();
                this.originalEnvelope = new GeneralEnvelope(this.crs);
                this.originalEnvelope.setRange(0, sdeExtent.getMinX(), sdeExtent.getMaxX());
                this.originalEnvelope.setRange(1, sdeExtent.getMinY(), sdeExtent.getMaxY());
            }
            catch (UnavailableArcSDEConnectionException e) {
                LOGGER.log(Level.SEVERE, "", e);
                throw new DataSourceException((Throwable)e);
            }
            catch (SeException e) {
                LOGGER.log(Level.SEVERE, "", e);
                throw new DataSourceException(e.getSeError().getErrDesc(), (Throwable)e);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.SEVERE, "", e);
                throw new DataSourceException((Throwable)e);
            }
            catch (PeProjectionException e) {
                LOGGER.log(Level.SEVERE, "", e);
                throw new DataSourceException((Throwable)e);
            }
            Object var8_12 = null;
            if (con == null) return;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (con == null) throw throwable;
            if (con.isClosed()) throw throwable;
            con.close();
            throw throwable;
        }
        if (con.isClosed()) return;
        con.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupConnectionPool(Object input) throws DataSourceException {
        if (input == null) {
            DataSourceException ex = new DataSourceException("No source set to read this coverage.");
            if (!LOGGER.isLoggable(Level.SEVERE)) throw ex;
            LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            throw ex;
        }
        String sdeUrl = null;
        if (input instanceof String) {
            sdeUrl = (String)input;
            LOGGER.warning("connecting to ArcSDE Raster: " + sdeUrl);
        } else {
            if (!(input instanceof File)) throw new IllegalArgumentException("Unsupported input type: " + input.getClass());
            sdeUrl = ((File)input).getPath();
            LOGGER.warning("connectiong via file-hack to ArcSDE Raster: " + sdeUrl);
        }
        ArcSDEConnectionConfig sdeConfig = ArcSDERasterGridCoverage2DReader.sdeURLToConnectionConfig(new StringBuffer(sdeUrl));
        if (sdeUrl.indexOf(";") != -1) {
            String extraParams = sdeUrl.substring(sdeUrl.indexOf(";") + 1, sdeUrl.length());
            sdeUrl = sdeUrl.substring(0, sdeUrl.indexOf(";"));
            if (extraParams.indexOf("LZERO_ORIGIN_TILE=") != -1) {
                String offsetTile = extraParams.substring(extraParams.indexOf("LZERO_ORIGIN_TILE=") + 18);
                int xOffsetTile = Integer.parseInt(offsetTile.substring(0, offsetTile.indexOf(",")));
                int yOffsetTile = Integer.parseInt(offsetTile.substring(offsetTile.indexOf(",") + 1));
                this._levelZeroPRP = new Point(xOffsetTile, yOffsetTile);
            }
        }
        this.rasterTable = sdeUrl.substring(sdeUrl.indexOf("#") + 1);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Building ArcSDEGridCoverageReader2D for " + sdeConfig + ", with raster table " + this.rasterTable);
        }
        this.connectionPool = ArcSDEConnectionPoolFactory.getInstance().createPool(sdeConfig);
        try {
            ArcSDEPooledConnection scon = this.connectionPool.getConnection();
            SeTable sTable = this.connectionPool.getSdeTable(scon, this.rasterTable);
            SeQuery q = null;
            try {
                try {
                    SeColumnDefinition[] cols = sTable.describe();
                    ArrayList<String> fetchColumns = new ArrayList<String>();
                    for (int i = 0; i < cols.length; ++i) {
                        if (cols[i].getType() != SeColumnDefinition.TYPE_RASTER) continue;
                        fetchColumns.add(cols[i].getName());
                    }
                    if (fetchColumns.size() == 0) {
                        throw new DataSourceException("Couldn't find any TYPE_RASTER columns in ArcSDE table " + this.rasterTable);
                    }
                    this.rasterColumns = fetchColumns.toArray(new String[fetchColumns.size()]);
                    q = new SeQuery((SeConnection)scon, this.rasterColumns, new SeSqlConstruct(this.rasterTable));
                    q.prepareQuery();
                    q.execute();
                    SeRow r = q.fetch();
                    this.rasterAttributes = r.getRaster(0);
                    q.close();
                }
                catch (SeException se) {
                    throw new DataSourceException("Error fetching raster connection data from " + this.rasterTable + ": " + se.getSeError().getErrDesc(), (Throwable)se);
                }
                Object var11_16 = null;
                if (scon == null) return;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                if (scon == null) throw throwable;
                if (scon.isClosed()) throw throwable;
                scon.close();
                throw throwable;
            }
            if (scon.isClosed()) return;
            scon.close();
            return;
        }
        catch (UnavailableArcSDEConnectionException uce) {
            throw new DataSourceException("Unable to fetch a connection to ArcSDE server at " + this.connectionPool.getConfig().getServerName() + ".", (Throwable)uce);
        }
    }

    private void calculateBandDependentInfo() throws DataSourceException {
        block9: {
            try {
                int i;
                SeRasterBand[] sdeBands = this.rasterAttributes.getBands();
                this.bandInfo = new HashMap();
                for (i = 0; i < sdeBands.length; ++i) {
                    this.bandInfo.put(new Long(sdeBands[i].getId()), ArcSDERasterBandCopier.getInstance(this.rasterAttributes.getPixelType(), this.pyramidInfo.tileHeight, this.pyramidInfo.tileWidth));
                }
                for (i = 0; i < this.rasterAttributes.getNumBands(); ++i) {
                    if (!this.rasterAttributes.getBandInfo(i + 1).hasColorMap()) continue;
                    throw new IllegalArgumentException("ArcSDERasterGridCoverage2DReader doesn't support reading from ColorMapped SDE rasters yet.");
                }
                if (this.rasterAttributes.getNumBands() == 1) {
                    if (this.rasterAttributes.getPixelType() == SeRaster.SE_PIXEL_TYPE_1BIT) {
                        LOGGER.warning("Discovered 1-bit single-band raster.  Using return image type: TYPE_BYTE_BINARY and 1-bit black/white category.");
                        NumberRange sampleValueRange = new NumberRange(0, 1);
                        Category bitBandCat = new Category((CharSequence)(this.coverageName + ": Band One (1-bit)"), new Color[]{Color.BLACK, Color.WHITE}, sampleValueRange, (MathTransform1D)LinearTransform1D.IDENTITY);
                        this.gridBands = new GridSampleDimension[1];
                        this.gridBands[0] = new GridSampleDimension((CharSequence)bitBandCat.getName(), new Category[]{bitBandCat}, null).geophysics(true);
                        this.bufferedImageType = 12;
                        break block9;
                    }
                    if (this.rasterAttributes.getPixelType() == SeRaster.SE_PIXEL_TYPE_8BIT_S || this.rasterAttributes.getPixelType() == SeRaster.SE_PIXEL_TYPE_8BIT_U) {
                        LOGGER.warning("Discovered 8-bit single-band raster.  Using return image type: TYPE_BYTE_GRAY");
                        NumberRange sampleValueRange = new NumberRange(0, 255);
                        Category greyscaleBandCat = new Category((CharSequence)(this.coverageName + ": Band One (grayscale)"), new Color[]{Color.BLACK, Color.WHITE}, sampleValueRange, (MathTransform1D)LinearTransform1D.IDENTITY);
                        this.gridBands = new GridSampleDimension[1];
                        this.gridBands[0] = new GridSampleDimension((CharSequence)greyscaleBandCat.getName(), new Category[]{greyscaleBandCat}, null).geophysics(true);
                        this.bufferedImageType = 10;
                        break block9;
                    }
                    throw new IllegalArgumentException("One-band, non-colormapped raster layers with type " + this.rasterAttributes.getPixelType() + " are not supported.");
                }
                if (this.rasterAttributes.getNumBands() == 3 || this.rasterAttributes.getNumBands() == 4) {
                    if (this.rasterAttributes.getPixelType() != SeRaster.SE_PIXEL_TYPE_8BIT_U) {
                        throw new IllegalArgumentException("3 or 4 band rasters are only supported if they have pixel type 8-bit unsigned pixels.");
                    }
                    LOGGER.warning("Three or four banded non-colormapped raster detected.  Assuming bands 1,2 and 3 constitue a 3-band RGB image.  Using return image type: TYPE_INT_ARGB (alpha will be used to support no-data pixels)");
                    NumberRange sampleValueRange = new NumberRange(0, 255);
                    Category nan = new Category((CharSequence)"no-data", new Color[]{new Color(0)}, new NumberRange(0, 0), (MathTransform1D)LinearTransform1D.IDENTITY);
                    Category white = new Category((CharSequence)"valid-data", new Color[]{new Color(-16777216)}, new NumberRange(255, 255), (MathTransform1D)LinearTransform1D.IDENTITY);
                    Category redBandCat = new Category((CharSequence)"red", new Color[]{Color.BLACK, Color.RED}, sampleValueRange, (MathTransform1D)LinearTransform1D.IDENTITY);
                    Category blueBandCat = new Category((CharSequence)"blue", new Color[]{Color.BLACK, Color.BLUE}, sampleValueRange, (MathTransform1D)LinearTransform1D.IDENTITY);
                    Category greenBandCat = new Category((CharSequence)"green", new Color[]{Color.BLACK, Color.GREEN}, sampleValueRange, (MathTransform1D)LinearTransform1D.IDENTITY);
                    this.gridBands = new GridSampleDimension[4];
                    this.gridBands[0] = new GridSampleDimension((CharSequence)"Red band", new Category[]{redBandCat}, null);
                    this.gridBands[1] = new GridSampleDimension((CharSequence)"Green band", new Category[]{blueBandCat}, null);
                    this.gridBands[2] = new GridSampleDimension((CharSequence)"Blue band", new Category[]{greenBandCat}, null);
                    this.gridBands[3] = new GridSampleDimension((CharSequence)"NODATA Mask Band", new Category[]{nan, white}, null);
                    this.bufferedImageType = 2;
                    break block9;
                }
                StringBuffer errmsg = new StringBuffer();
                errmsg.append("ArcSDERasterGridCoverage2DReader doesn't support ");
                errmsg.append(this.rasterAttributes.getNumBands());
                errmsg.append("-banded images of type ");
                errmsg.append(this.rasterAttributes.getPixelType());
                throw new IllegalArgumentException();
            }
            catch (SeException se) {
                LOGGER.log(Level.SEVERE, se.getSeError().getErrDesc(), se);
                throw new DataSourceException((Throwable)se);
            }
        }
    }

    private void setupCoverageMetadata() {
        ArcSDEPyramidLevel highestRes = this.pyramidInfo.getPyramidLevel(this.pyramidInfo.getNumLevels() - 1);
        Rectangle actualDim = new Rectangle(0, 0, highestRes.getNumTilesWide() * this.tileWidth, highestRes.getNumTilesHigh() * this.tileHeight);
        this.originalGridRange = new GeneralGridRange(actualDim);
        this.coverageName = this.rasterTable;
    }

    private void setupImageIOReader() throws DataSourceException {
        HashMap<String, Object> readerMap = new HashMap<String, Object>();
        readerMap.put("org.geotools.arcsde.gce.imageio.PYRAMID", this.pyramidInfo);
        readerMap.put("org.geotools.arcsde.gce.imageio.RASTER_TABLE", this.rasterTable);
        readerMap.put("org.geotools.arcsde.gce.imageio.RASTER_COLUMN", this.rasterColumns[0]);
        try {
            this.imageIOReader = (ArcSDERasterReader)new ArcSDERasterReaderSpi().createReaderInstance(readerMap);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Error creating ImageIOReader in ArcSDERasterGridCoverage2DReader", ioe);
            throw new DataSourceException((Throwable)ioe);
        }
    }

    private BufferedImage createInitialBufferedImage(int width, int height) throws DataSourceException {
        BufferedImage ret = new BufferedImage(width, height, this.bufferedImageType);
        int[] pixels = new int[width * height];
        for (int i = 0; i < width * height; ++i) {
            pixels[i] = 0xFFFFFF;
        }
        ret.setRGB(0, 0, width, height, pixels, 0, 1);
        return ret;
    }
}

