/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce.band;

import com.esri.sde.sdk.client.SeRasterTile;
import java.awt.image.WritableRaster;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.gce.band.ArcSDERasterBandCopier;
import org.geotools.data.DataSourceException;

public class UnsignedByteBandCopier
extends ArcSDERasterBandCopier {
    Logger LOGGER = Logger.getLogger(this.getClass().toString());

    UnsignedByteBandCopier() {
    }

    public void copyPixelData(SeRasterTile tile, WritableRaster raster, int copyOffX, int copyOffY, int targetBand) throws DataSourceException {
        byte[] bitmaskData;
        int numPixels;
        if (this.LOGGER.isLoggable(Level.FINER)) {
            this.LOGGER.finer("copying raster data band " + tile.getBandId() + " into image band " + targetBand);
        }
        if ((numPixels = tile.getNumPixels()) == 0) {
            if (this.LOGGER.isLoggable(Level.FINE)) {
                this.LOGGER.fine("no pixels to copy in raster tile " + tile.getColumnIndex() + "," + tile.getRowIndex());
            }
            return;
        }
        byte[] pixelData = new byte[numPixels];
        try {
            pixelData = tile.getPixels(pixelData);
            bitmaskData = tile.getBitMaskData();
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
        int imgWidth = raster.getWidth() + copyOffX > this.tileWidth ? this.tileWidth - copyOffX : raster.getWidth();
        int imgHeight = raster.getHeight() + copyOffY > this.tileHeight ? this.tileHeight - copyOffY : raster.getHeight();
        for (int x = 0; x < imgWidth; ++x) {
            for (int y = 0; y < imgHeight; ++y) {
                int pixArrayOffset = (y + copyOffY) * this.tileWidth + (x + copyOffX);
                if (bitmaskData.length > 0 && (bitmaskData[pixArrayOffset / 8] >> 7 - pixArrayOffset % 8 & 1) == 0) {
                    if (raster.getNumBands() == 4) {
                        raster.setSample(x, y, 3, 0);
                    }
                    raster.setSample(x, y, targetBand, 255);
                    continue;
                }
                try {
                    int transferType;
                    if (raster.getNumBands() == 4) {
                        raster.setSample(x, y, 3, 255);
                    }
                    if ((transferType = raster.getTransferType()) != 0 && transferType != 3) {
                        throw new IllegalArgumentException("Can't copy ArcSDE Raster data from an SE_PIXEL_TYPE_8BIT_U raster to a java.awt.Raster with a transferType of " + transferType);
                    }
                    byte sdePixelData = pixelData[pixArrayOffset];
                    int bandSample = sdePixelData & 0xFF;
                    raster.setSample(x, y, targetBand, bandSample);
                    continue;
                }
                catch (RuntimeException e) {
                    this.LOGGER.severe("at data " + (x + copyOffX) + "," + (y + copyOffY) + "(img pixel " + x + "," + y + ")");
                    this.LOGGER.severe("number of pixels reported in tile was " + numPixels);
                    e.printStackTrace();
                    throw e;
                }
            }
        }
    }
}

