/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce.imageio;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeRasterConstraint;
import com.esri.sde.sdk.client.SeRasterTile;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import org.geotools.arcsde.gce.ArcSDEPyramid;
import org.geotools.arcsde.gce.ArcSDEPyramidLevel;
import org.geotools.arcsde.gce.band.ArcSDERasterBandCopier;
import org.geotools.arcsde.gce.imageio.ArcSDERasterImageReadParam;
import org.geotools.arcsde.gce.imageio.ArcSDERasterReaderSpi;
import org.geotools.arcsde.pool.ArcSDEPooledConnection;
import org.geotools.data.DataSourceException;

public class ArcSDERasterReader
extends ImageReader {
    private static final boolean DEBUG = false;
    private static final ArrayList supportedImageTypes = new ArrayList();
    private final Logger LOGGER = Logger.getLogger(this.getClass().toString());
    private final ArcSDEPyramid _rasterPyramid;
    private final Dimension _tileSize;
    private final String _rasterTable;
    private final String _rasterColumn;

    public ArcSDERasterReader(ArcSDERasterReaderSpi parent, ArcSDEPyramid rasterPyramid, String rasterTable, String rasterColumn) {
        super(parent);
        this._tileSize = rasterPyramid.getTileDimension();
        this._rasterPyramid = rasterPyramid;
        this._rasterTable = rasterTable;
        this._rasterColumn = rasterColumn;
    }

    public int getHeight(int imageIndex) throws IOException {
        return this._rasterPyramid.getPyramidLevel((int)imageIndex).size.height;
    }

    public int getWidth(int imageIndex) throws IOException {
        return this._rasterPyramid.getPyramidLevel((int)imageIndex).size.width;
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        return supportedImageTypes.iterator();
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        return this._rasterPyramid.getNumLevels();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        BufferedImage destination;
        Point destOffset;
        if (!(param instanceof ArcSDERasterImageReadParam)) {
            throw new IllegalArgumentException("read() must be called with an ArcSDERasterReadImageParam, not a " + param.getClass());
        }
        ArcSDERasterImageReadParam sdeirp = (ArcSDERasterImageReadParam)param;
        if (sdeirp.getSourceBands() == null) {
            throw new IllegalArgumentException("You must provide source bands to the ArcSDERasterReader via param.setSourceBands()");
        }
        if (sdeirp.getConnection() == null) {
            throw new IllegalArgumentException("You must provide a connection to the ArcSDERasterReader via the param.setConnection() method.");
        }
        if (sdeirp.getBandMapper() == null) {
            throw new IllegalArgumentException("You must provide a hashmap bandmapper to the ArcSDERasterReader via the param.setBandMapper() method");
        }
        Rectangle sourceRegion = param.getSourceRegion();
        ArcSDEPyramidLevel curLevel = this._rasterPyramid.getPyramidLevel(imageIndex);
        Point point = destOffset = param.getDestinationOffset() == null ? new Point(0, 0) : param.getDestinationOffset();
        if (curLevel.getXOffset() != 0) {
            sourceRegion.x += curLevel.getXOffset();
        }
        if (curLevel.getYOffset() != 0) {
            if (this.LOGGER.isLoggable(Level.FINER)) {
                this.LOGGER.finer("y-axis is offset by " + curLevel.getYOffset() + " at SDE pyramid level " + curLevel.getLevel());
            }
            sourceRegion.y += curLevel.getYOffset();
        }
        if ((destination = param.getDestination()) == null && destOffset.x == 0 && destOffset.y == 0) {
            destination = new BufferedImage(sourceRegion.width, sourceRegion.height, 2);
        } else if (destination == null) {
            int imageWidth = destOffset.x + sourceRegion.width;
            int imageHeight = destOffset.y + sourceRegion.height;
            destination = new BufferedImage(imageWidth, imageHeight, 2);
        } else if (destination != null && (destOffset.x != 0 || destOffset.y != 0)) {
            int destWidth = sourceRegion.width;
            int destHeight = sourceRegion.height;
            if (destOffset.x + sourceRegion.width > destination.getWidth()) {
                destWidth = destination.getWidth() - destOffset.x;
            }
            if (destOffset.y + sourceRegion.height > destination.getHeight()) {
                destHeight = destination.getHeight() - destOffset.y;
            }
            destination = destination.getSubimage(destOffset.x, destOffset.y, destWidth, destHeight);
        }
        int minTileX = sourceRegion.x / this._tileSize.width;
        int minTileY = sourceRegion.y / this._tileSize.height;
        if (this.LOGGER.isLoggable(Level.FINER)) {
            this.LOGGER.finer("figured minTiles: " + minTileX + "," + minTileY + ".  Image is " + curLevel.getNumTilesWide() + "x" + curLevel.getNumTilesHigh() + " tiles wxh.");
        }
        int maxTileX = (sourceRegion.x + sourceRegion.width) / this._tileSize.width;
        int maxTileY = (sourceRegion.y + sourceRegion.height) / this._tileSize.height;
        if (maxTileX > curLevel.getNumTilesWide()) {
            maxTileX = curLevel.getNumTilesWide() - 1;
        }
        if (maxTileY > curLevel.getNumTilesHigh()) {
            maxTileY = curLevel.getNumTilesHigh() - 1;
        }
        int tilegridOffsetX = sourceRegion.x % this._tileSize.width;
        int tilegridOffsetY = sourceRegion.y % this._tileSize.height;
        if (this.LOGGER.isLoggable(Level.INFO)) {
            this.LOGGER.info("Reading " + param.getSourceRegion() + " offset by " + sdeirp.getDestinationOffset() + " (tiles " + minTileX + "," + minTileY + " to " + maxTileX + "," + maxTileY + " in level " + imageIndex + ")");
        }
        ArcSDEPooledConnection scon = sdeirp.getConnection();
        SeQuery query = null;
        try {
            try {
                WritableRaster destinationSubTile;
                query = new SeQuery((SeConnection)scon, new String[]{this._rasterColumn}, new SeSqlConstruct(this._rasterTable));
                query.prepareQuery();
                query.execute();
                SeRow r = query.fetch();
                SeRasterConstraint rConstraint = new SeRasterConstraint();
                rConstraint.setEnvelope(minTileX, minTileY, maxTileX, maxTileY);
                rConstraint.setLevel(imageIndex);
                rConstraint.setBands(sdeirp.getSourceBands());
                query.queryRasterTile(rConstraint);
                SeRasterTile curTile = r.getRasterTile();
                HashMap bandMapper = sdeirp.getBandMapper();
                ArcSDERasterBandCopier bandCopier = ArcSDERasterBandCopier.getInstance(r.getRaster(0).getPixelType(), this._tileSize.width, this._tileSize.height);
                while (curTile != null) {
                    if (curTile.getNumPixels() == 0) {
                        // empty if block
                    }
                    int curTileOffsetX = curTile.getColumnIndex() == minTileX ? tilegridOffsetX : 0;
                    int curTileOffsetY = curTile.getRowIndex() == minTileY ? tilegridOffsetY : 0;
                    int curTileX = curTile.getColumnIndex() - minTileX;
                    int destImageOffsetX = curTileX == 0 ? 0 : this._tileSize.width - tilegridOffsetX + (curTileX - 1) * this._tileSize.width;
                    int curTileY = curTile.getRowIndex() - minTileY;
                    int destImageOffsetY = curTileY == 0 ? 0 : this._tileSize.height - tilegridOffsetY + (curTileY - 1) * this._tileSize.height;
                    int destImageTileWidth = curTile.getColumnIndex() == maxTileX && destImageOffsetX + this._tileSize.width > destination.getWidth() ? destination.getWidth() - destImageOffsetX : (curTileX == 0 ? this._tileSize.width - curTileOffsetX : this._tileSize.width);
                    int destImageTileHeight = curTile.getRowIndex() == maxTileY && destImageOffsetY + this._tileSize.height > destination.getHeight() ? destination.getHeight() - destImageOffsetY : (curTileY == 0 ? this._tileSize.height - curTileOffsetY : this._tileSize.height);
                    if (destImageTileWidth == 0 || destImageTileHeight == 0) {
                        if (this.LOGGER.isLoggable(Level.FINER)) {
                            this.LOGGER.finer("Skipping tile " + curTileX + "," + curTileY + " because it has imagetile height " + destImageTileHeight + " and width " + destImageTileWidth);
                        }
                        curTile = r.getRasterTile();
                        continue;
                    }
                    BufferedImage subtile = destination.getSubimage(destImageOffsetX, destImageOffsetY, destImageTileWidth, destImageTileHeight);
                    destinationSubTile = subtile.getRaster();
                    Integer curBandId = new Integer((int)curTile.getBandId().longValue());
                    int targetBand = (Integer)bandMapper.get(curBandId);
                    bandCopier.copyPixelData(curTile, destinationSubTile, curTileOffsetX, curTileOffsetY, targetBand);
                    curTile = r.getRasterTile();
                }
                curTile = null;
                destinationSubTile = null;
            }
            catch (SeException se) {
                this.LOGGER.log(Level.SEVERE, se.getSeError().getErrDesc(), se);
                throw new DataSourceException((Throwable)se);
            }
            Object var34_34 = null;
        }
        catch (Throwable throwable) {
            Object var34_35 = null;
            try {
                if (query == null) throw throwable;
                query.close();
                throw throwable;
            }
            catch (SeException se) {
                this.LOGGER.log(Level.SEVERE, se.getSeError().getErrDesc(), se);
                throw new DataSourceException("Unable to clean up connections to database.  May have left one hanging.", (Throwable)se);
            }
        }
        try {}
        catch (SeException se) {
            this.LOGGER.log(Level.SEVERE, se.getSeError().getErrDesc(), se);
            throw new DataSourceException("Unable to clean up connections to database.  May have left one hanging.", (Throwable)se);
        }
        if (query == null) return destination;
        query.close();
        return destination;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    static {
        supportedImageTypes.add(ImageTypeSpecifier.createFromBufferedImageType(2));
    }
}

