/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.pool;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ArcSDEConnectionConfig {
    private static final Logger LOGGER = Logger.getLogger(ArcSDEConnectionConfig.class.getPackage().getName());
    private static final String NULL_ARGUMENTS_MSG = "Illegal arguments. At least one of them was null. Check to pass correct values to dbtype, server, port, database, user and password parameters";
    private static final String ILLEGAL_ARGUMENT_MSG = " is not valid for parameter ";
    public static final String DBTYPE_PARAM = "dbtype";
    public static final String DBTYPE_PARAM_VALUE = "arcsde";
    public static final String NAMESPACE_PARAM = "namespace";
    public static final String SERVER_NAME_PARAM = "server";
    public static final String PORT_NUMBER_PARAM = "port";
    public static final String INSTANCE_NAME_PARAM = "instance";
    public static final String USER_NAME_PARAM = "user";
    public static final String PASSWORD_PARAM = "password";
    public static final String MIN_CONNECTIONS_PARAM = "pool.minConnections";
    public static final String MAX_CONNECTIONS_PARAM = "pool.maxConnections";
    public static final String CONNECTION_TIMEOUT_PARAM = "pool.timeOut";
    protected static final String TABLE_NAME_PARAM = "table";
    URI namespaceUri;
    String serverName;
    Integer portNumber;
    String databaseName;
    String userName;
    String userPassword;
    Integer minConnections = null;
    Integer maxConnections = null;
    Integer connTimeOut = null;

    public ArcSDEConnectionConfig(Map params) throws NullPointerException, IllegalArgumentException {
        this.init(params);
    }

    public ArcSDEConnectionConfig(String dbType, String serverName, String portNumber, String databaseName, String userName, String userPassword) throws NullPointerException, IllegalArgumentException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DBTYPE_PARAM, dbType);
        params.put(SERVER_NAME_PARAM, serverName);
        params.put(PORT_NUMBER_PARAM, portNumber);
        params.put(INSTANCE_NAME_PARAM, databaseName);
        params.put(USER_NAME_PARAM, userName);
        params.put(PASSWORD_PARAM, userPassword);
        this.init(params);
    }

    private void init(Map params) throws NumberFormatException, IllegalArgumentException {
        String dbtype = (String)params.get(DBTYPE_PARAM);
        String server = (String)params.get(SERVER_NAME_PARAM);
        String port = String.valueOf(params.get(PORT_NUMBER_PARAM));
        String instance = (String)params.get(INSTANCE_NAME_PARAM);
        String user = (String)params.get(USER_NAME_PARAM);
        String pwd = (String)params.get(PASSWORD_PARAM);
        Integer _port = this.checkParams(dbtype, server, port, instance, user, pwd);
        this.serverName = server;
        this.portNumber = _port;
        this.databaseName = instance;
        this.userName = user;
        this.userPassword = pwd;
        this.setUpOptionalParams(params);
    }

    private void setUpOptionalParams(Map params) throws IllegalArgumentException {
        String exceptionMsg = null;
        Object ns = params.get(NAMESPACE_PARAM);
        if (ns != null) {
            try {
                this.namespaceUri = new URI(ns.toString());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("invalid namespace: " + ns);
            }
        }
        this.minConnections = ArcSDEConnectionConfig.getInt(params.get(MIN_CONNECTIONS_PARAM), 2);
        this.maxConnections = ArcSDEConnectionConfig.getInt(params.get(MAX_CONNECTIONS_PARAM), 2);
        this.connTimeOut = ArcSDEConnectionConfig.getInt(params.get(CONNECTION_TIMEOUT_PARAM), 1000);
        if (this.minConnections <= 0) {
            exceptionMsg = "pool.minConnections must be a positive integer";
        }
        if (this.maxConnections <= 0) {
            exceptionMsg = "pool.maxConnections must be a positive integer";
        }
        if (this.connTimeOut <= 0) {
            exceptionMsg = "pool.timeOut must be a positive integer";
        }
        if (this.minConnections > this.maxConnections) {
            exceptionMsg = "pool.minConnections must be lower than pool.maxConnections";
        }
        if (exceptionMsg != null) {
            throw new IllegalArgumentException(exceptionMsg);
        }
    }

    private static final Integer getInt(Object value, int defaultValue) {
        if (value == null) {
            return new Integer(defaultValue);
        }
        String sVal = String.valueOf(value);
        try {
            return Integer.valueOf(sVal);
        }
        catch (NumberFormatException ex) {
            return new Integer(defaultValue);
        }
    }

    private Integer checkParams(String dbType, String serverName, String portNumber, String databaseName, String userName, String userPassword) throws IllegalArgumentException, NullPointerException {
        if (!DBTYPE_PARAM_VALUE.equals(dbType)) {
            throw new IllegalArgumentException("parameter dbtype must be arcsde");
        }
        if (serverName == null || portNumber == null || userName == null || userPassword == null) {
            throw new NullPointerException(NULL_ARGUMENTS_MSG);
        }
        if (serverName.length() == 0) {
            this.throwIllegal(SERVER_NAME_PARAM, serverName);
        }
        if (databaseName == null || databaseName.length() == 0) {
            LOGGER.warning("No database name specified");
            databaseName = "";
        }
        if (userName.length() == 0) {
            this.throwIllegal(USER_NAME_PARAM, userName);
        }
        if (userPassword.length() == 0) {
            this.throwIllegal(PASSWORD_PARAM, userPassword);
        }
        Integer port = null;
        try {
            port = Integer.valueOf(portNumber);
        }
        catch (NumberFormatException ex) {
            this.throwIllegal(PORT_NUMBER_PARAM, portNumber);
        }
        return port;
    }

    private void throwIllegal(String paramName, String paramValue) throws IllegalArgumentException {
        throw new IllegalArgumentException("'" + paramValue + "'" + ILLEGAL_ARGUMENT_MSG + paramName);
    }

    public URI getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public int hashCode() {
        int hash = 37;
        hash *= this.getServerName().hashCode();
        hash *= this.getPortNumber().hashCode();
        return hash *= this.getUserName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArcSDEConnectionConfig)) {
            return false;
        }
        ArcSDEConnectionConfig config = (ArcSDEConnectionConfig)o;
        return config.getServerName().equals(this.getServerName()) && config.getPortNumber().equals(this.getPortNumber()) && config.getUserName().equals(this.getUserName());
    }

    public Integer getConnTimeOut() {
        return this.connTimeOut;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Integer getMinConnections() {
        return this.minConnections;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + "[");
        sb.append("dbtype=");
        sb.append(DBTYPE_PARAM_VALUE);
        sb.append(", server=");
        sb.append(this.serverName);
        sb.append(", port=");
        sb.append(this.portNumber);
        sb.append(", instance=");
        sb.append(this.databaseName);
        sb.append(", user=");
        sb.append(this.userName);
        sb.append(", password=*****");
        sb.append(", minConnections=");
        sb.append(this.minConnections);
        sb.append(", maxConnections=");
        sb.append(this.maxConnections);
        sb.append(", connTimeOut=");
        sb.append(this.connTimeOut);
        sb.append("]");
        return sb.toString();
    }
}

