/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.pool;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeInstance;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeRelease;
import com.esri.sde.sdk.client.SeTable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.geotools.arcsde.pool.ArcSDEConnectionConfig;
import org.geotools.arcsde.pool.ArcSDEPooledConnection;
import org.geotools.arcsde.pool.UnavailableArcSDEConnectionException;
import org.geotools.data.DataSourceException;

public class ArcSDEConnectionPool {
    protected static final Logger LOGGER = Logger.getLogger(ArcSDEConnectionPool.class.getPackage().getName());
    protected static final Level INFO_LOG_LEVEL = Level.WARNING;
    public static final int DEFAULT_CONNECTIONS = 2;
    public static final int DEFAULT_MAX_CONNECTIONS = 2;
    public static final int DEFAULT_MAX_WAIT_TIME = 1000;
    private SeConnectionFactory seConnectionFactory;
    private ArcSDEConnectionConfig config;
    private ObjectPool pool;
    private HashMap cachedLayers;
    private boolean closed = false;

    public ArcSDEConnectionPool(ArcSDEConnectionConfig config) throws DataSourceException {
        if (config == null) {
            throw new NullPointerException("parameter config can't be null");
        }
        this.config = config;
        this.cachedLayers = new HashMap();
        LOGGER.fine("populating ArcSDE connection pool");
        this.seConnectionFactory = new SeConnectionFactory(this.config);
        int minConnections = config.getMinConnections();
        int maxConnections = config.getMaxConnections();
        byte exhaustedAction = 1;
        long maxWait = config.getConnTimeOut().longValue();
        this.pool = new GenericObjectPool((PoolableObjectFactory)this.seConnectionFactory, maxConnections, exhaustedAction, maxWait);
        LOGGER.info("Created pool " + this.pool);
        ArcSDEPooledConnection[] preload = new ArcSDEPooledConnection[minConnections];
        try {
            int i;
            for (i = 0; i < minConnections; ++i) {
                preload[i] = (ArcSDEPooledConnection)((Object)this.pool.borrowObject());
            }
            for (i = 0; i < minConnections; ++i) {
                this.pool.returnObject((Object)preload[i]);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "can't connect to " + config, e);
            throw new DataSourceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        ObjectPool objectPool = this.pool;
        synchronized (objectPool) {
            return this.pool.getNumActive() + this.pool.getNumIdle();
        }
    }

    public void close() {
        try {
            this.pool.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Closing pool: " + e.getMessage(), e);
        }
        this.closed = true;
        LOGGER.fine("SDE connection pool closed. ");
    }

    public synchronized int getAvailableCount() {
        return this.pool.getNumIdle();
    }

    public synchronized int getInUseCount() {
        return this.pool.getNumActive();
    }

    public ArcSDEPooledConnection getConnection() throws DataSourceException, UnavailableArcSDEConnectionException {
        if (this.closed) {
            throw new IllegalStateException("The ConnectionPool has been closed.");
        }
        try {
            return (ArcSDEPooledConnection)((Object)this.pool.borrowObject());
        }
        catch (NoSuchElementException e) {
            LOGGER.log(Level.WARNING, "Getting connection: " + e.getMessage(), e);
            throw new UnavailableArcSDEConnectionException(this.pool.getNumActive(), this.config);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Getting connection: " + e.getMessage(), e);
            throw new DataSourceException(e.getMessage(), (Throwable)e);
        }
    }

    public SeTable getSdeTable(String tableName) throws DataSourceException {
        ArcSDEPooledConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (UnavailableArcSDEConnectionException e) {
            throw new DataSourceException((Throwable)e);
        }
        try {
            SeTable table;
            SeTable seTable = table = new SeTable((SeConnection)conn, tableName);
            return seTable;
        }
        catch (SeException ex) {
            throw new DataSourceException("Can't obtain the table " + tableName + ": " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            conn.close();
        }
    }

    public SeTable getSdeTable(SeConnection conn, String tableName) throws DataSourceException {
        try {
            SeTable table = new SeTable(conn, tableName);
            return table;
        }
        catch (SeException ex) {
            throw new DataSourceException("Can't obtain the table " + tableName + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SeLayer getSdeLayer(String typeName) throws NoSuchElementException, IOException {
        SeLayer layer;
        ArcSDEPooledConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (UnavailableArcSDEConnectionException e) {
            throw new DataSourceException((Throwable)e);
        }
        try {
            layer = this.getSdeLayer(conn, typeName);
        }
        finally {
            conn.close();
        }
        return layer;
    }

    public synchronized SeLayer getSdeLayer(SeConnection conn, String typeName) throws NoSuchElementException, IOException {
        SeLayer layer = null;
        if (this.cachedLayers.containsKey(typeName)) {
            String shapeColumn = (String)this.cachedLayers.get(typeName);
            try {
                layer = new SeLayer(conn, typeName, shapeColumn);
            }
            catch (SeException e) {
                throw new DataSourceException("Getting layer " + typeName, (Throwable)e);
            }
        }
        try {
            List layers = conn.getLayers();
            Iterator it = layers.iterator();
            while (it.hasNext() && !(layer = (SeLayer)it.next()).getQualifiedName().equalsIgnoreCase(typeName)) {
                layer = null;
            }
        }
        catch (SeException e) {
            throw new DataSourceException("Getting layer list: " + e.getMessage(), (Throwable)e);
        }
        if (layer == null) {
            throw new NoSuchElementException(typeName);
        }
        this.cachedLayers.put(typeName, layer.getSpatialColumn());
        return layer;
    }

    public List getAvailableLayerNames() throws DataSourceException {
        ArcSDEPooledConnection conn = null;
        LinkedList<String> layerNames = new LinkedList<String>();
        try {
            conn = this.getConnection();
            Iterator it = conn.getLayers().iterator();
            while (it.hasNext()) {
                layerNames.add(((SeLayer)it.next()).getQualifiedName());
            }
        }
        catch (SeException ex) {
            throw new DataSourceException("Error querying the layers list" + ex.getSeError().getSdeError() + " (" + ex.getSeError().getErrDesc() + ") ", (Throwable)ex);
        }
        catch (UnavailableArcSDEConnectionException ex) {
            throw new DataSourceException("No free connection found to query the layers list", (Throwable)ex);
        }
        finally {
            conn.close();
        }
        return layerNames;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ArcSDEConnectionConfig getConfig() {
        return this.config;
    }

    class SeConnectionFactory
    extends BasePoolableObjectFactory {
        private ArcSDEConnectionConfig config;

        public SeConnectionFactory(ArcSDEConnectionConfig config) {
            this.config = config;
        }

        public Object makeObject() throws SeException {
            ArcSDEPooledConnection seConn = new ArcSDEPooledConnection(ArcSDEConnectionPool.this.pool, this.config);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Created new connection with hashcode " + seConn.hashCode());
            }
            return seConn;
        }

        public void activateObject(Object obj) {
            ArcSDEPooledConnection seConn = (ArcSDEPooledConnection)((Object)obj);
            if (seConn.isActive()) {
                LOGGER.log(Level.SEVERE, "Activating an already active connection. This should never happen and is a bug inside the ArcSDE connection pooling code.  If you consistently see this error message, please email the geotools-devel list at geotools-devel@lists.sourceforge.net", new Exception());
            } else {
                seConn.activate();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("activating connection " + obj.hashCode());
                }
            }
        }

        public boolean validateObject(Object obj) {
            boolean valid;
            ArcSDEPooledConnection conn = (ArcSDEPooledConnection)((Object)obj);
            boolean bl = valid = !conn.isClosed();
            if (valid) {
                try {
                    LOGGER.finest("Validating SDE Connection");
                    String user = conn.getUser();
                    LOGGER.finer("Connection validated, returned user " + user);
                }
                catch (SeException e) {
                    LOGGER.info("Can't validate SeConnection, discarding it: " + (Object)((Object)conn));
                    valid = false;
                }
            }
            return valid;
        }

        public void destroyObject(Object obj) {
            ArcSDEPooledConnection seConn = (ArcSDEPooledConnection)((Object)obj);
            if (seConn.isActive()) {
                LOGGER.log(Level.SEVERE, "Destroying an active connection. This should never happen and is a bug inside the ArcSDE connection pooling code.  If you consistently see this error message, please email the geotools-devel list at geotools-devel@lists.sourceforge.net", new Exception());
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("destroying connection " + obj.hashCode());
            }
            ArcSDEPooledConnection conn = (ArcSDEPooledConnection)((Object)obj);
            conn.destroy();
        }

        public void passivateObject(Object obj) {
            ArcSDEPooledConnection seConn = (ArcSDEPooledConnection)((Object)obj);
            if (!seConn.isActive()) {
                LOGGER.log(Level.SEVERE, "Passivating an already passive connection. Likely this means that you've called 'close()' on an already closed ArcSDEPooledConnection.  Here's a stack trace to help you find where you've done this:", new Exception());
            } else {
                seConn.passivate();
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("passivating connection " + obj.hashCode());
            }
        }
    }

    private static class SeConfigReport {
        private SeConfigReport() {
        }

        static void reportConfiguration(ArcSDEConnectionConfig config) throws DataSourceException {
            try {
                SeInstance instanceInfo = new SeInstance(config.getServerName(), config.getPortNumber().intValue());
                if (!LOGGER.isLoggable(INFO_LOG_LEVEL)) {
                    return;
                }
                StringBuffer sb = new StringBuffer("***\nArcSDE configuration info:\n");
                sb.append("*** ArcSDE Server info: ****");
                sb.append("Server name: " + instanceInfo.getServerName());
                SeInstance.SeInstanceStatus status = instanceInfo.getStatus();
                SeRelease sdeRelease = status.getSeRelease();
                sb.append("\n ArcSDE version: ");
                sb.append(sdeRelease.getMajor());
                sb.append('.');
                sb.append(sdeRelease.getMinor());
                sb.append('.');
                sb.append(sdeRelease.getBugFix());
                sb.append(" - ");
                sb.append(sdeRelease.getDesc());
                sb.append("\nAccepting connections: ");
                sb.append(status.isAccepting());
                sb.append("\nBlocking connections: ");
                sb.append(status.isBlocking());
                SeInstance.SeInstanceConfiguration iconf = instanceInfo.getConfiguration();
                sb.append("\n---- Instance configuration: ----");
                sb.append("\nInstance is read-only: ");
                sb.append(iconf.getReadOnlyInstance());
                sb.append("\nHome path: ");
                sb.append(iconf.getHomePath());
                sb.append("\nLog path: ");
                sb.append(iconf.getLogPath());
                sb.append("\nMax. connections: ");
                sb.append(iconf.getMaxConnections());
                sb.append("\nMax. layers: ");
                sb.append(iconf.getMaxLayers());
                sb.append("\nMax. streams: ");
                sb.append(iconf.getMaxStreams() + " (maximum number of streams allowed by the ArcSde instance)");
                sb.append("\nStream pool size: ");
                sb.append(iconf.getStreamPoolSize() + " (maximum number of streams allowed in a native pool.)");
                sb.append("\n**************************");
                LOGGER.log(INFO_LOG_LEVEL, sb.toString());
            }
            catch (SeException e) {
                throw new DataSourceException("Error fetching information from  the server " + config.getServerName() + ":" + config.getPortNumber());
            }
        }
    }
}

