/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.arcsde.pool.ArcSDEConnectionConfig;
import org.geotools.arcsde.pool.ArcSDEConnectionPool;
import org.geotools.data.DataSourceException;

public class ArcSDEConnectionPoolFactory {
    private static Logger LOGGER = Logger.getLogger(ArcSDEConnectionPoolFactory.class.getPackage().getName());
    private static final ArcSDEConnectionPoolFactory singleton = new ArcSDEConnectionPoolFactory();
    private final Map currentPools = new HashMap();

    private ArcSDEConnectionPoolFactory() {
    }

    public static synchronized ArcSDEConnectionPoolFactory getInstance() {
        return singleton;
    }

    public synchronized ArcSDEConnectionPool createPool(ArcSDEConnectionConfig config) throws DataSourceException {
        ArcSDEConnectionPool pool = (ArcSDEConnectionPool)this.currentPools.get(config);
        if (pool == null) {
            pool = new ArcSDEConnectionPool(config);
            this.currentPools.put(config, pool);
        }
        return pool;
    }

    public void clear() {
        this.closeAll();
        this.currentPools.clear();
        LOGGER.fine("sde connection pools creared");
    }

    public void closeAll() {
        Iterator it = this.currentPools.values().iterator();
        while (it.hasNext()) {
            ((ArcSDEConnectionPool)it.next()).close();
        }
    }

    public void finalize() {
        this.closeAll();
    }
}

