/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.pool;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.ObjectPool;
import org.geotools.arcsde.pool.ArcSDEConnectionConfig;

public class ArcSDEPooledConnection
extends SeConnection {
    private static final Logger LOGGER = Logger.getLogger(ArcSDEPooledConnection.class.getPackage().getName());
    private ObjectPool pool;
    private ArcSDEConnectionConfig config;
    private boolean isActivated;

    public ArcSDEPooledConnection(ObjectPool pool, ArcSDEConnectionConfig config) throws SeException {
        super(config.getServerName(), config.getPortNumber().intValue(), config.getDatabaseName(), config.getUserName(), config.getUserPassword());
        this.config = config;
        this.pool = pool;
        this.isActivated = false;
    }

    boolean isActive() {
        return this.isActivated;
    }

    void activate() {
        this.isActivated = true;
    }

    void passivate() {
        this.isActivated = false;
    }

    public void close() {
        try {
            this.pool.returnObject((Object)this);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    void destroy() {
        try {
            super.close();
        }
        catch (SeException e) {
            LOGGER.log(Level.SEVERE, "closing connection: " + e.getSeError().getErrDesc(), e);
        }
    }

    public boolean equals(Object other) {
        return other == this;
    }

    public int hashCode() {
        return 0x11 ^ this.config.hashCode();
    }
}

