/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.color;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.PaletteSuitability;
import org.geotools.brewer.color.PaletteType;
import org.geotools.brewer.color.SampleScheme;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ColorBrewer {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.brewer.color");
    public static final PaletteType ALL = new PaletteType(true, true, "ALL");
    public static final PaletteType SUITABLE_RANGED = new PaletteType(true, false);
    public static final PaletteType SUITABLE_UNIQUE = new PaletteType(false, true);
    public static final PaletteType SEQUENTIAL = new PaletteType(true, false, "SEQUENTIAL");
    public static final PaletteType DIVERGING = new PaletteType(true, false, "DIVERGING");
    public static final PaletteType QUALITATIVE = new PaletteType(false, true, "QUALITATIVE");
    String name = null;
    String description = null;
    Hashtable palettes = new Hashtable();

    public static ColorBrewer instance() {
        ColorBrewer me = new ColorBrewer();
        me.loadPalettes();
        return me;
    }

    public static ColorBrewer instance(PaletteType type) throws IOException {
        ColorBrewer me = new ColorBrewer();
        me.loadPalettes(type);
        return me;
    }

    public void registerPalette(BrewerPalette pal) {
        this.palettes.put(pal.getName(), pal);
    }

    public boolean hasPalette(String paletteName) {
        return this.palettes.containsKey(paletteName);
    }

    public BrewerPalette[] getPalettes() {
        Object[] entry = this.palettes.keySet().toArray();
        BrewerPalette[] palettes = new BrewerPalette[entry.length];
        for (int i = 0; i < entry.length; ++i) {
            palettes[i] = this.getPalette(entry[i].toString());
        }
        return palettes;
    }

    public BrewerPalette[] getPalettes(PaletteType type) {
        return this.getPalettes(type, -1);
    }

    public BrewerPalette[] getPalettes(PaletteType type, int numClasses) {
        ArrayList<BrewerPalette> palettes = new ArrayList<BrewerPalette>();
        Object[] entry = this.palettes.keySet().toArray();
        for (int i = 0; i < entry.length; ++i) {
            BrewerPalette pal = this.getPalette(entry[i].toString());
            boolean match = true;
            if (numClasses > -1 && pal.getMaxColors() < numClasses) {
                match = false;
            }
            if (!pal.getType().isMatch(type)) {
                match = false;
            }
            if (!match) continue;
            palettes.add(pal);
        }
        return palettes.toArray(new BrewerPalette[palettes.size()]);
    }

    public BrewerPalette[] getPalettes(PaletteType type, int numClasses, int requiredViewers) {
        ArrayList<BrewerPalette> palettes = new ArrayList<BrewerPalette>();
        Object[] entry = this.palettes.keySet().toArray();
        for (int i = 0; i < entry.length; ++i) {
            BrewerPalette pal = this.getPalette(entry[i].toString());
            boolean match = true;
            if (numClasses > -1 && pal.getMaxColors() < numClasses) {
                match = false;
            }
            if (!pal.getType().isMatch(type)) {
                match = false;
            }
            int[] suitability = pal.getPaletteSuitability().getSuitability(numClasses);
            if (this.isSet(0, requiredViewers) && suitability[0] != 3) {
                match = false;
            } else if (this.isSet(4, requiredViewers) && suitability[4] != 3) {
                match = false;
            } else if (this.isSet(3, requiredViewers) && suitability[3] != 3) {
                match = false;
            } else if (this.isSet(1, requiredViewers) && suitability[1] != 3) {
                match = false;
            } else if (this.isSet(5, requiredViewers) && suitability[5] != 3) {
                match = false;
            } else if (this.isSet(2, requiredViewers) && suitability[2] != 3) {
                match = false;
            }
            if (!match) continue;
            palettes.add(pal);
        }
        return palettes.toArray(new BrewerPalette[palettes.size()]);
    }

    public String[] getPaletteNames() {
        Object[] keys = this.palettes.keySet().toArray();
        String[] paletteList = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            paletteList[i] = keys[i].toString();
        }
        return paletteList;
    }

    public String[] getPaletteNames(int minClasses, int maxClasses) {
        Object[] keys = this.palettes.keySet().toArray();
        HashSet<String> paletteSet = new HashSet<String>();
        for (int i = 0; i < keys.length; ++i) {
            BrewerPalette thisPalette = (BrewerPalette)this.palettes.get(keys[i]);
            int numColors = thisPalette.getMaxColors();
            if (numColors < minClasses || numColors > maxClasses) continue;
            paletteSet.add(thisPalette.getName());
        }
        String[] paletteList = new String[paletteSet.size()];
        Object[] paletteObjList = paletteSet.toArray();
        for (int i = 0; i < paletteSet.size(); ++i) {
            paletteList[i] = (String)paletteObjList[i];
        }
        return paletteList;
    }

    public BrewerPalette getPalette(String name) {
        return (BrewerPalette)this.palettes.get(name);
    }

    public void loadPalettes() {
        this.loadPalettes(SEQUENTIAL);
        this.loadPalettes(DIVERGING);
        this.loadPalettes(QUALITATIVE);
    }

    public void loadPalettes(PaletteType type) {
        InputStream stream;
        if (type.equals(ALL)) {
            this.loadPalettes();
            return;
        }
        if (type.equals(SUITABLE_RANGED)) {
            this.loadPalettes(SEQUENTIAL);
            this.loadPalettes(DIVERGING);
            return;
        }
        if (type.equals(SUITABLE_UNIQUE)) {
            this.loadPalettes(QUALITATIVE);
            return;
        }
        if (type.getName() == null) {
            return;
        }
        String paletteSet = type.getName().toLowerCase();
        URL url = this.getClass().getResource("resources/" + paletteSet + ".xml");
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "couldn't open input stream to load palette", e);
            return;
        }
        this.load(stream, type);
    }

    public void loadPalettes(InputStream XMLinput, PaletteType type) {
        this.load(XMLinput, type);
    }

    private void load(InputStream stream, PaletteType type) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(stream);
            this.name = this.fixToString(document.getElementsByTagName("name").item(0).getFirstChild().toString());
            this.description = this.fixToString(document.getElementsByTagName("description").item(0).getFirstChild().toString());
            SampleScheme scheme = new SampleScheme();
            NodeList samples = document.getElementsByTagName("sample");
            for (int i = 0; i < samples.getLength(); ++i) {
                Node sample = samples.item(i);
                int size = Integer.parseInt(sample.getAttributes().getNamedItem("size").getNodeValue());
                String values = this.fixToString(sample.getFirstChild().toString());
                int[] list = new int[size];
                StringTokenizer tok = new StringTokenizer(values);
                for (int j = 0; j < size; ++j) {
                    list[j] = Integer.parseInt(tok.nextToken(","));
                }
                scheme.setSampleScheme(size, list);
            }
            NodeList palettes = document.getElementsByTagName("palette");
            for (int i = 0; i < palettes.getLength(); ++i) {
                BrewerPalette pal = new BrewerPalette();
                PaletteSuitability suitability = new PaletteSuitability();
                NodeList paletteInfo = palettes.item(i).getChildNodes();
                for (int j = 0; j < paletteInfo.getLength(); ++j) {
                    Node item = paletteInfo.item(j);
                    if (item.getNodeName().equals("name")) {
                        pal.setName(this.fixToString(item.getFirstChild().toString()));
                    }
                    if (item.getNodeName().equals("description")) {
                        pal.setDescription(this.fixToString(item.getFirstChild().toString()));
                    }
                    if (item.getNodeName().equals("colors")) {
                        StringTokenizer oTok = new StringTokenizer(this.fixToString(item.getFirstChild().toString()));
                        int numColors = 0;
                        Color[] colors = new Color[15];
                        for (int k = 0; k < 15 && oTok.hasMoreTokens(); ++k) {
                            String entry = oTok.nextToken(":");
                            StringTokenizer iTok = new StringTokenizer(entry);
                            int r = Integer.parseInt(iTok.nextToken(",").trim());
                            int g = Integer.parseInt(iTok.nextToken(",").trim());
                            int b = Integer.parseInt(iTok.nextToken(",").trim());
                            colors[numColors] = new Color(r, g, b);
                            ++numColors;
                        }
                        pal.setColors(colors);
                    }
                    if (!item.getNodeName().equals("suitability")) continue;
                    NodeList schemeSuitability = item.getChildNodes();
                    for (int k = 0; k < schemeSuitability.getLength(); ++k) {
                        Node palScheme = schemeSuitability.item(k);
                        if (!palScheme.getNodeName().equals("scheme")) continue;
                        int paletteSize = Integer.parseInt(palScheme.getAttributes().getNamedItem("size").getNodeValue());
                        String values = this.fixToString(palScheme.getFirstChild().toString());
                        String[] list = new String[6];
                        StringTokenizer tok = new StringTokenizer(values);
                        for (int m = 0; m < 6; ++m) {
                            list[m] = tok.nextToken(",");
                        }
                        suitability.setSuitability(paletteSize, list);
                    }
                }
                pal.setType(type);
                pal.setColorScheme(scheme);
                pal.setPaletteSuitability(suitability);
                this.registerPalette(pal);
            }
        }
        catch (SAXException sxe) {
            LOGGER.log(Level.SEVERE, "Error during palette parsing", sxe);
        }
        catch (ParserConfigurationException pce) {
            LOGGER.log(Level.SEVERE, "Parser with specified options can't be built", pce);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "i/o error during palette parsing", ioe);
        }
    }

    private String fixToString(String input) {
        if (input.startsWith("[") && input.endsWith("]")) {
            input = input.substring(1, input.length() - 1);
            input = input.replaceAll("#text: ", "");
        }
        return input;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void reset() {
        this.name = null;
        this.description = null;
        this.palettes = new Hashtable();
    }

    public boolean isSet(int singleValue, int multipleValue) {
        return (singleValue & multipleValue) != 0;
    }
}

